/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.common.contentassist;

import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.ObjectUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.editor.common.CommonEditorPlugin;
import com.aptana.editor.common.contentassist.CompletionProposalType;
import com.aptana.editor.common.contentassist.ICommonCompletionProposal;
import com.aptana.editor.common.contentassist.ICompletionProposalExtend6;
import com.aptana.editor.common.contentassist.ICompletionProposalExtension4;
import com.aptana.editor.common.contentassist.ICompletionProposalExtension5;
import com.aptana.editor.common.contentassist.IReContentAssistCompletionProposalExtension;
import com.aptana.editor.common.contentassist.ProposalShowInfo;
import com.aptana.editor.common.contentassist.UserAgentManager;
import com.aptana.editor.common.link.LinkedModeUI2;
import com.aptana.parsing.lexer.IRange;
import com.aptana.parsing.lexer.Range;
import com.aptana.ui.util.UIUtils;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension2;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension3;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class CommonCompletionProposal
implements IReContentAssistCompletionProposalExtension,
ICommonCompletionProposal,
ICompletionProposalExtension,
ICompletionProposalExtension2,
ICompletionProposalExtension3,
ICompletionProposalExtension4,
ICompletionProposalExtension5,
ICompletionProposalExtend6,
Comparable<ICompletionProposal> {
    public static final int FILE_TYPE_FOLDER = 2;
    protected String _replacementString;
    protected int _replacementOffset;
    protected int _replacementLength;
    protected final int _initReplacementLength;
    protected int _cursorPosition;
    protected Image _image;
    protected String _displayString;
    protected IContextInformation _contextInformation;
    protected String _additionalProposalInformation;
    protected String _fileLocation;
    protected boolean _needApplyReContentAssist;
    protected boolean _needHiddenReContentAssist;
    protected boolean _isNestedProposal = false;
    protected int prefixReplaceLength;
    protected Point _selectPoint = null;
    private int _hash;
    private Map<String, String> _userAgentImages;
    private char[] _triggerChars;
    protected boolean _isDefaultSelection;
    private boolean _isSuggestedSelection;
    private int _relevance;
    private long validateeEventModificationStamp;
    private CompletionProposalType completionProposalType;
    private String currentElementName;
    private ProposalShowInfo proposalShowInfo;
    protected boolean lastValidated = true;
    private boolean isItalics;
    private int linkedCursorPosition;
    private boolean autoReplace = true;
    private boolean isShowImage = false;
    private String showImagePath = null;
    private boolean selfPrefix = false;
    private boolean isHTML = false;
    private String h5PlusURL;
    private boolean fShowContextInfo;

    public String getCurrentElementName() {
        return this.currentElementName;
    }

    public void setCurrentElementName(String currentElementName) {
        this.currentElementName = currentElementName;
    }

    public boolean isShowImage() {
        return this.isShowImage;
    }

    public void setShowImage(boolean isShowImage) {
        this.isShowImage = isShowImage;
    }

    public String getShowImagePath() {
        return this.showImagePath;
    }

    public void setShowImagePath(String showImagePath) {
        this.showImagePath = showImagePath;
    }

    public CommonCompletionProposal(String replacementString, int replacementOffset, int replacementLength, int cursorPosition, Image image, String displayString, IContextInformation contextInformation, String additionalProposalInfo) {
        this._replacementString = replacementString == null ? "" : replacementString;
        this._replacementOffset = replacementOffset;
        this._replacementLength = replacementLength;
        this._initReplacementLength = replacementLength;
        this._cursorPosition = cursorPosition;
        this._image = image;
        this._displayString = displayString == null ? "" : displayString;
        this._contextInformation = contextInformation;
        this._additionalProposalInformation = additionalProposalInfo;
    }

    public void setFileInfo(File file, boolean needAdd) {
        if (file == null) {
            return;
        }
        if (file.isDirectory()) {
            this._image = UIUtils.getImage((AbstractUIPlugin)CommonEditorPlugin.getDefault(), (String)"/icons/folder.png");
        } else {
            this._image = UIUtils.getImage((AbstractUIPlugin)CommonEditorPlugin.getDefault(), (String)"/icons/file.png");
            String extention = this.getExtention(file.getName());
            if (StringUtil.isNotBlank((String)extention)) {
                try {
                    Image image = UIUtils.getImage((AbstractUIPlugin)CommonEditorPlugin.getDefault(), (String)("icons/" + extention.toLowerCase() + ".png"));
                    this._image = image != null ? image : this._image;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        if (needAdd && file.isDirectory() && !this._replacementString.endsWith("/")) {
            this._replacementString = String.valueOf(this._replacementString) + "/";
            ++this._cursorPosition;
        }
    }

    public void setSelfPrefix(boolean selfPrefix) {
        this.selfPrefix = selfPrefix;
    }

    public boolean isSelfPrefix() {
        return this.selfPrefix;
    }

    protected String getExtention(String name) {
        if (StringUtil.isNotBlank((String)name) && name.indexOf(".") > 0) {
            int index = name.lastIndexOf(".") + 1;
            return name.substring(index);
        }
        return null;
    }

    public void apply(IDocument document) {
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (this == obj) {
            result = true;
        } else if (obj instanceof CommonCompletionProposal) {
            CommonCompletionProposal that = (CommonCompletionProposal)obj;
            result = ObjectUtil.areEqual((Object)this._replacementString, (Object)that._replacementString) && this._replacementOffset == that._replacementOffset && this._replacementLength == that._replacementLength && this._cursorPosition == that._cursorPosition && ObjectUtil.areEqual((Object)this._image, (Object)that._image) && ObjectUtil.areEqual((Object)this._displayString, (Object)that._displayString) && ObjectUtil.areEqual((Object)this._contextInformation, (Object)that._contextInformation) && ObjectUtil.areEqual((Object)this._fileLocation, (Object)that._fileLocation);
        }
        return result;
    }

    public int hashCode() {
        if (this._hash == 0) {
            this._hash = this._hash * 31 + (this._replacementString != null ? this._replacementString.hashCode() : 0);
            this._hash = this._hash * 31 + this._replacementOffset;
            this._hash = this._hash * 31 + this._replacementLength;
            this._hash = this._hash * 31 + this._cursorPosition;
            this._hash = this._hash * 31 + (this.getImage() != null ? this.getImage().hashCode() : 0);
            this._hash = this._hash * 31 + (this.getDisplayString() != null ? this.getDisplayString().hashCode() : 0);
            this._hash = this._hash * 31 + (this.getContextInformation() != null ? this.getContextInformation().hashCode() : 0);
            this._hash = this._hash * 31 + (this.getFileLocation() != null ? this.getFileLocation().hashCode() : 0);
        }
        return this._hash;
    }

    public String getAdditionalProposalInfo() {
        return this._additionalProposalInformation;
    }

    public IContextInformation getContextInformation() {
        return this._contextInformation;
    }

    public String getDisplayString() {
        return this._displayString;
    }

    public String getFileLocation() {
        return this._fileLocation != null ? this._fileLocation : "";
    }

    public Image getImage() {
        return this._image;
    }

    public void setImage(Image image) {
        this._image = image;
    }

    public IRange getReplaceRange() {
        return new Range(this._replacementOffset, this._replacementOffset + this._replacementLength - 1);
    }

    public Point getSelection(IDocument document) {
        return this._selectPoint != null ? new Point(this._selectPoint.x, this._selectPoint.y) : new Point(this._replacementOffset + this._cursorPosition, 0);
    }

    public void setSelection(Point selectPoint) {
        if (selectPoint != null) {
            this._selectPoint = new Point(selectPoint.x, selectPoint.y);
        }
    }

    public Map<String, String> getUserAgentImages(IProject project) {
        if (!CollectionsUtil.isEmpty(this._userAgentImages) && this._userAgentImages.containsKey("_lazy_")) {
            if (project == null) {
                return null;
            }
            HashMap<String, String> agents = new HashMap<String, String>();
            agents.putAll(this._userAgentImages);
            agents.remove("_lazy_");
            if (agents.containsKey("url")) {
                this.h5PlusURL = (String)agents.get("url");
                agents.remove("url");
            }
            return UserAgentManager.getInstance().getUserAgentPath(project, agents);
        }
        return this._userAgentImages;
    }

    public boolean isDefaultSelection() {
        return this._isDefaultSelection;
    }

    public boolean isSuggestedSelection() {
        return this._isSuggestedSelection;
    }

    public void setFileLocation(String location) {
        this._fileLocation = location;
    }

    public void setIsDefaultSelection(boolean value) {
        this._isDefaultSelection = value;
    }

    public void setIsSuggestedSelection(boolean value) {
        this._isSuggestedSelection = value;
    }

    public void setUserAgentImages(Map<String, String> images) {
        this._userAgentImages = images;
    }

    public IInformationControlCreator getInformationControlCreator() {
        return null;
    }

    public CharSequence getPrefixCompletionText(IDocument document, int completionOffset) {
        return this._replacementString;
    }

    public int getPrefixCompletionStart(IDocument document, int completionOffset) {
        return this._replacementOffset;
    }

    public void apply(ITextViewer viewer, char trigger, int stateMask, int offset, int startOffset) {
        this._replacementOffset = startOffset;
        this._replacementLength = startOffset - offset;
        this.apply(viewer, trigger, stateMask, offset);
    }

    public void apply(ITextViewer viewer, char trigger, int stateMask, int offset) {
        String str;
        CommonCompletionProposal ext5;
        Point p = viewer.getSelectedRange();
        if (p != null && p.y > 0) {
            this._replacementOffset = p.x;
            this._replacementLength = p.y;
        }
        if (this._selectPoint != null && this._replacementString != null) {
            this._selectPoint.x += this._replacementString.length() - this._replacementLength;
        }
        if (this instanceof ICompletionProposalExtension5 && (ext5 = this).isNestedProposal()) {
            this._replacementString = this._replacementString.replace("\"", "'");
        }
        IDocument document = viewer.getDocument();
        boolean validPrefix = this.isValidPrefix(this.getPrefix(document, offset), this._replacementString, true);
        boolean validPrefixCaseSensitive = this.isValidPrefix(this.getPrefix(document, offset), this._replacementString, false);
        boolean addedTrigger = false;
        char[] triggers = this.getTriggerCharacters();
        if (triggers != null && (str = new String(triggers)).indexOf(trigger) >= 0 && this._replacementString != null && this._replacementString.indexOf(trigger) < 0) {
            this._replacementString = String.valueOf(this._replacementString) + trigger;
            addedTrigger = true;
        }
        int shift = 0;
        if (validPrefix && validPrefixCaseSensitive) {
            shift = offset - this._replacementOffset;
        }
        if (shift <= this._replacementString.length()) {
            try {
                int length = this._replacementLength;
                String toReplace = this._replacementString;
                String printString = document.get(this._replacementOffset, shift);
                if (StringUtil.isNotBlank((String)printString) && (printString.indexOf("link:") > -1 || printString.indexOf("script:") > -1)) {
                    toReplace = this._replacementString;
                    offset = this._replacementOffset;
                    length = printString.length();
                } else if (this.isAutoReplace()) {
                    length = Math.max(0, this._replacementLength - shift);
                    toReplace = this._replacementString.substring(shift);
                    if (!validPrefix || validPrefix && !validPrefixCaseSensitive) {
                        String prefix = this.getPrefix(document, offset);
                        length = prefix.length();
                        offset = this._replacementOffset;
                    }
                } else {
                    offset = this._replacementOffset;
                }
                if (addedTrigger) {
                    ++this._cursorPosition;
                }
                this.replace(viewer, offset, document, length + this.prefixReplaceLength, toReplace);
                this.prefixReplaceLength = 0;
                if (this.linkedCursorPosition != 0) {
                    try {
                        LinkedModeModel model = new LinkedModeModel();
                        LinkedPositionGroup group = new LinkedPositionGroup();
                        group.addPosition(new LinkedPosition(document, this.getSelection((IDocument)document).x, 0));
                        model.addGroup(group);
                        model.forceInstall();
                        LinkedModeUI2 ui = new LinkedModeUI2(model, viewer);
                        ui.setCyclingMode(LinkedModeUI2.CYCLE_NEVER);
                        ui.setExitPosition(viewer, this.linkedCursorPosition + (this._replacementString.length() - this._initReplacementLength), 0, Integer.MAX_VALUE);
                        ui.enter();
                    }
                    catch (BadLocationException e) {
                        e.printStackTrace();
                    }
                }
            }
            catch (BadLocationException badLocationException) {}
        }
        if (this.fShowContextInfo) {
            this.showContentInfo(viewer);
        }
    }

    public void replace(ITextViewer viewer, int offset, IDocument document, int length, String toReplace) throws BadLocationException {
        document.replace(offset, length, toReplace);
    }

    public void selected(ITextViewer viewer, boolean smartToggle) {
    }

    public void unselected(ITextViewer viewer) {
    }

    public boolean validate(IDocument document, int offset, DocumentEvent event) {
        if (offset < this._replacementOffset) {
            return false;
        }
        String prefix = this.getPrefix(document, offset);
        return this.validate(document, offset, prefix, event);
    }

    public boolean validate(IDocument document, int offset, String prefix, DocumentEvent event) {
        boolean validated;
        if (this.isSelfPrefix()) {
            prefix = this.getPrefix(document, offset);
        }
        String endPortion = this.getDisplayString();
        if (this.getDisplayString().equals("HTML 5") && this._replacementString.equals("HTML")) {
            endPortion = this._replacementString;
        }
        if ((validated = this.isValidPrefix(prefix, endPortion)) && event != null && this.validateeEventModificationStamp != event.getModificationStamp()) {
            String text = event.fText;
            int delta = (text == null ? 0 : text.length()) - event.fLength;
            if (event != null && text.startsWith("(")) {
                return validated;
            }
            if (StringUtil.isEmpty((String)prefix) && text.equals(" ")) {
                ++this._replacementOffset;
                ++this.linkedCursorPosition;
                return validated;
            }
            if (delta >= 0 || this.validateeEventModificationStamp != 0L) {
                if (this.lastValidated || delta >= 0) {
                    int newLength;
                    if (text.contains("\r\n") && delta > 0) {
                        delta = 1;
                    }
                    this._replacementLength = newLength = Math.max(this._replacementLength + delta, 0);
                    if (this._selectPoint != null) {
                        int sx = this._selectPoint.x;
                        this._selectPoint.x = sx = Math.max(sx + delta, 0);
                    }
                }
                this.validateeEventModificationStamp = event.getModificationStamp();
            }
        }
        this.lastValidated = validated;
        return validated;
    }

    public String getPrefix(IDocument document, int offset) {
        String prefix = "";
        try {
            int length = offset - this._replacementOffset;
            if (length > 0 && (prefix = document.get(this._replacementOffset, length)).startsWith("\"") && "__html_tag".equals(document.getPartition(offset).getType())) {
                prefix = prefix.substring(1);
                ++this._replacementOffset;
            }
        }
        catch (BadLocationException badLocationException) {}
        return prefix;
    }

    protected boolean isValidPrefix(String prefix, String displayString) {
        return this.isValidPrefix(prefix, displayString, true);
    }

    protected boolean isAutoReplace() {
        return this.autoReplace;
    }

    public void setAutoReplace(boolean autoReplace) {
        this.autoReplace = autoReplace;
    }

    protected boolean isValidPrefix(String prefix, String displayString, boolean ignoreCase) {
        if (prefix == null || displayString == null || prefix.length() > displayString.length()) {
            return false;
        }
        String start = displayString.substring(0, prefix.length());
        if (ignoreCase) {
            prefix = prefix.toLowerCase();
            displayString = displayString.toLowerCase();
            boolean equals = this.checkPrefix(displayString, prefix);
            if (StringUtil.isNotEmpty((String)prefix) && StringUtil.isNotEmpty((String)displayString) && Character.isUpperCase(prefix.charAt(0))) {
                return prefix.charAt(0) == displayString.charAt(0) && equals;
            }
            return equals;
        }
        return start.equals(prefix);
    }

    private boolean checkPrefix(String displayString, String prefix) {
        if (StringUtil.isBlank((String)prefix)) {
            return true;
        }
        int pLength = prefix.length();
        char[] prefixs = new char[pLength];
        prefix.getChars(0, pLength, prefixs, 0);
        boolean equals = false;
        int preIndex = -1;
        char[] cArray = prefixs;
        int n = prefixs.length;
        int n2 = 0;
        while (n2 < n) {
            int index;
            char p = cArray[n2];
            int index_ = index = displayString.indexOf(String.valueOf(p));
            if (preIndex > -1) {
                index_ += preIndex + 1;
            }
            if (index_ <= preIndex) {
                equals = false;
                break;
            }
            preIndex = index;
            equals = true;
            displayString = displayString.substring(index + 1);
            ++n2;
        }
        return equals;
    }

    public String getExtraInfo() {
        return null;
    }

    @Override
    public int compareTo(ICompletionProposal o) {
        if (this == o) {
            return 0;
        }
        return StringUtil.compareCaseInsensitive((String)this.getDisplayString(), (String)o.getDisplayString());
    }

    public int getRelevance() {
        return this._relevance;
    }

    public void setRelevance(int relevance) {
        this._relevance = relevance;
    }

    public void apply(IDocument document, char trigger, int offset) {
    }

    public boolean isValidFor(IDocument document, int offset) {
        return false;
    }

    public void setTriggerCharacters(char[] chars) {
        this._triggerChars = chars;
    }

    public char[] getTriggerCharacters() {
        return this._triggerChars;
    }

    public int getContextInformationPosition() {
        return 0;
    }

    public boolean validateTrigger(IDocument document, int offset, KeyEvent keyEvent) {
        return true;
    }

    public void replaceReplacementStringChar(char oldChar, char newChar) {
        this._replacementString = this._replacementString.replace(oldChar, newChar);
    }

    public String toString() {
        return this.getDisplayString();
    }

    public boolean isApplyNeedReContentAssist(ITextViewer viewer, int offset) {
        return this._needApplyReContentAssist;
    }

    public void setApplyNeedReContentAssist(boolean needReContentAssist) {
        this._needApplyReContentAssist = needReContentAssist;
    }

    public void setActualReplacementOffset(int offset) {
        this._replacementOffset = offset;
    }

    public int getReplacementOffset() {
        return this._replacementOffset;
    }

    public void setNestedProposal(boolean nested) {
        this._isNestedProposal = nested;
    }

    public boolean isNestedProposal() {
        return this._isNestedProposal;
    }

    public void setCompletionProposalType(CompletionProposalType completionProposalType) {
        this.completionProposalType = completionProposalType;
    }

    public CompletionProposalType getCompletionProposalType() {
        if (this.completionProposalType == null) {
            return CompletionProposalType.DEFALUT;
        }
        return this.completionProposalType;
    }

    public void setProposalShowInfo(ProposalShowInfo proposalShowInfo) {
        this.proposalShowInfo = proposalShowInfo;
    }

    public ProposalShowInfo getProposalShowInfo() {
        return this.proposalShowInfo;
    }

    public String getReplacementString() {
        return this._replacementString;
    }

    public void setReplacementString(String replacementString) {
        this._replacementString = replacementString;
    }

    public void setDisplayString(String displayString) {
        this._displayString = displayString;
    }

    public void setIsItalics(boolean isItalics) {
        this.isItalics = isItalics;
    }

    public boolean IsItalics() {
        return this.isItalics;
    }

    public void addReplacementLength(int l) {
        this.prefixReplaceLength += l;
    }

    public int getCursorPosition() {
        return this._cursorPosition;
    }

    public void setCursorPosition(int _cursorPosition) {
        this._cursorPosition = _cursorPosition;
    }

    public int getlinkedCursorPosition() {
        return this.linkedCursorPosition;
    }

    public void setlinkedCursorPosition(int linkedCursorPosition) {
        this.linkedCursorPosition = linkedCursorPosition;
    }

    public void setIsHTML(boolean isHTML) {
        this.isHTML = isHTML;
    }

    public boolean isHTML() {
        return this.isHTML;
    }

    public String getH5PlusURL() {
        if (StringUtil.isBlank((String)this.h5PlusURL) && !CollectionsUtil.isEmpty(this._userAgentImages) && this._userAgentImages.containsKey("url")) {
            this.h5PlusURL = this._userAgentImages.get("url");
        }
        return this.h5PlusURL;
    }

    public void setShowContextInfo(boolean showContextInfo) {
        this.fShowContextInfo = showContextInfo;
    }

    protected void showContentInfo(final ITextViewer viewer) {
        try {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (((ITextOperationTarget)viewer).canDoOperation(14)) {
                        ((ITextOperationTarget)viewer).doOperation(14);
                    }
                }
            });
        }
        catch (Exception exception) {}
    }
}

