/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.common;

import com.aptana.editor.common.AbstractThemeableEditor;
import com.aptana.editor.common.CommonSourceViewerConfiguration;
import com.aptana.editor.common.IPartitionerSwitchStrategy;
import com.aptana.editor.common.ISourceViewerConfiguration;
import com.aptana.editor.common.TextUtils;
import com.aptana.editor.common.text.rules.CompositePartitionScanner;
import com.aptana.editor.common.text.rules.SingleTagRule;
import com.aptana.editor.common.text.rules.ThemeingDamagerRepairer;
import java.util.ArrayList;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.source.ISourceViewer;

public abstract class CompositeSourceViewerConfiguration
extends CommonSourceViewerConfiguration {
    private ITokenScanner startEndTokenScanner;
    private ISourceViewerConfiguration defaultSourceViewerConfiguration;
    private ISourceViewerConfiguration primarySourceViewerConfiguration;
    private String[][] topContentTypesArray;

    protected CompositeSourceViewerConfiguration(ISourceViewerConfiguration defaultSourceViewerConfiguration, ISourceViewerConfiguration primarySourceViewerConfiguration, IPreferenceStore preferences, AbstractThemeableEditor editor) {
        super(preferences, editor);
        this.defaultSourceViewerConfiguration = defaultSourceViewerConfiguration;
        this.primarySourceViewerConfiguration = primarySourceViewerConfiguration;
        String[][] defaultTopContentTypesArray = defaultSourceViewerConfiguration.getTopContentTypes();
        int i = 0;
        while (i < defaultTopContentTypesArray.length) {
            defaultTopContentTypesArray[i][0] = this.getTopContentType();
            ++i;
        }
        String[][] primaryContentTypesArray = primarySourceViewerConfiguration.getTopContentTypes();
        int i2 = 0;
        while (i2 < primaryContentTypesArray.length) {
            String[] topContentTypes = primaryContentTypesArray[i2];
            primaryContentTypesArray[i2] = new String[topContentTypes.length + 1];
            primaryContentTypesArray[i2][0] = this.getTopContentType();
            System.arraycopy(topContentTypes, 0, primaryContentTypesArray[i2], 1, topContentTypes.length);
            ++i2;
        }
        this.topContentTypesArray = TextUtils.combineArrays(defaultTopContentTypesArray, primaryContentTypesArray);
    }

    public final String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return TextUtils.combine(new String[][]{{"__dftl_partition_content_type"}, CompositePartitionScanner.SWITCHING_CONTENT_TYPES, this.primarySourceViewerConfiguration.getContentTypes(), this.defaultSourceViewerConfiguration.getContentTypes()});
    }

    @Override
    public String[][] getTopContentTypes() {
        return this.topContentTypesArray;
    }

    protected abstract String getTopContentType();

    @Override
    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        PresentationReconciler reconciler = (PresentationReconciler)super.getPresentationReconciler(sourceViewer);
        ThemeingDamagerRepairer dr = new ThemeingDamagerRepairer(this.getStartEndTokenScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__common_start_switch_tag");
        reconciler.setRepairer((IPresentationRepairer)dr, "__common_start_switch_tag");
        reconciler.setDamager((IPresentationDamager)dr, "__common_end_switch_tag");
        reconciler.setRepairer((IPresentationRepairer)dr, "__common_end_switch_tag");
        this.defaultSourceViewerConfiguration.setupPresentationReconciler(reconciler, sourceViewer);
        this.primarySourceViewerConfiguration.setupPresentationReconciler(reconciler, sourceViewer);
        return reconciler;
    }

    protected abstract IPartitionerSwitchStrategy getPartitionerSwitchStrategy();

    protected abstract String getStartEndTokenType();

    private ITokenScanner getStartEndTokenScanner() {
        if (this.startEndTokenScanner == null) {
            RuleBasedScanner ts = new RuleBasedScanner();
            Token seqToken = new Token((Object)this.getStartEndTokenType());
            ArrayList<SingleTagRule> rules = new ArrayList<SingleTagRule>();
            String[][] stringArray = this.getPartitionerSwitchStrategy().getSwitchTagPairs();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String[] pair = stringArray[n2];
                rules.add(new SingleTagRule(pair[0], (IToken)seqToken));
                rules.add(new SingleTagRule(pair[1], (IToken)seqToken));
                ++n2;
            }
            ts.setRules(rules.toArray(new IRule[rules.size()]));
            ts.setDefaultReturnToken((IToken)new Token((Object)"text"));
            this.startEndTokenScanner = ts;
        }
        return this.startEndTokenScanner;
    }
}

