/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.common;

import com.aptana.core.build.BuildFileManager;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.EclipseUtil;
import com.aptana.editor.common.AbstractThemeableEditor;
import com.aptana.editor.common.FilenameDifferentiator;
import com.aptana.editor.common.index.IReferIndexQueryHelper;
import com.aptana.editor.common.internal.scripting.ContentTypeTranslation;
import com.aptana.editor.common.internal.scripting.DocumentScopeManager;
import com.aptana.editor.common.scripting.IContentTypeTranslator;
import com.aptana.editor.common.scripting.IDocumentScopeManager;
import com.aptana.editor.common.spelling.SpellingPreferences;
import com.aptana.index.core.IndexPlugin;
import com.aptana.theme.Theme;
import com.aptana.theme.ThemePlugin;
import com.aptana.ui.util.StatusLineUtils;
import com.pandora.core.stats.Stats;
import com.pandora.core.utils.RegistryUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.State;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.editors.text.templates.ContributionTemplateStore;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import org.eclipse.ui.internal.editors.text.NonExistingFileEditorInput;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.texteditor.ITextEditorExtension5;
import org.eclipse.ui.views.contentoutline.ContentOutline;
import org.osgi.framework.BundleContext;
import org.osgi.service.prefs.BackingStoreException;

public class CommonEditorPlugin
extends AbstractUIPlugin {
    public static final String COLON = ":";
    public static final String BACKSLASH = "\\";
    public static final String SLASH = "/";
    public static final String TEMP_STR = "\u5f10&T";
    public static final String SLASH_STR = "\u5f10_";
    public static final String BACKSLASH_STR = "\u5f10_";
    public static final String COLON_STR = "\u5f10\uff1a";
    public static Map<String, File> TEMP_FILES;
    public static final String SNIPPET = "/icons/assistant/snippet.png";
    public static final String COMMAND = "/icons/command.png";
    public static final String QUICKFIXERROR = "/icons/quickfix_error.png";
    public static final String PLUGIN_ID = "com.aptana.editor.common";
    private static final String TEMPLATES = "com.aptana.editor.common.templates";
    private static final String OUTLINE_VIEW_ID = "org.eclipse.ui.views.ContentOutline";
    private static final String BINDINGS_VIEW_ID = "com.pandora.ui.views.Bindings";
    private static final String COMMAND_ID = "com.aptana.editor.common.commands.toggleOutline";
    private static final String COMMAND_STATE = "org.eclipse.ui.commands.toggleState";
    public static int VALIDATOR_BUILD_TYPE;
    public static final int DOCUMENTLINELARGENUMBER = 4000;
    public static final String NEED_FILTER = "NEED_FILTER";
    public static final String NEED_FILTER_WINDOW = "NEED_FILTER_WINDOW";
    private static CommonEditorPlugin plugin;
    private Map<ContextTypeRegistry, ContributionTemplateStore> fTemplateStoreMap;
    private FilenameDifferentiator differentiator;
    private IReferIndexQueryHelper referIndexQueryHelper = null;
    private RGB occurrenceLightColor = new RGB(128, 64, 64);
    private RGB occurrenceDarkColor = new RGB(0, 191, 0);
    private static Job job;
    private final IPartListener fPartListener = new IPartListener(){

        public void partActivated(IWorkbenchPart part) {
            if (part instanceof ITextEditorExtension5) {
                ITextEditorExtension5 ext5 = (ITextEditorExtension5)part;
                ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
                try {
                    Command command = commandService.getCommand("com.pandora.ui.toggleBlockSelectionMode");
                    if (command != null) {
                        command.getState(CommonEditorPlugin.COMMAND_STATE).setValue((Object)ext5.isBlockSelectionModeEnabled());
                    }
                }
                catch (Exception e) {
                    IdeLog.logError((Plugin)CommonEditorPlugin.getDefault(), (Throwable)e);
                }
            }
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
            if (part instanceof ContentOutline) {
                try {
                    IEclipsePreferences prefs = EclipseUtil.instanceScope().getNode(CommonEditorPlugin.PLUGIN_ID);
                    boolean first = prefs.getBoolean("com.aptana.editor.common.firstOutlineAutoOpen", true);
                    if (first && !PlatformUI.getWorkbench().isClosing()) {
                        prefs.putBoolean("com.aptana.editor.common.firstOutlineAutoOpen", false);
                        CommonEditorPlugin.this.showOutlineHelper();
                    }
                }
                catch (Exception e) {
                    Stats.addExceptionInfo((Throwable)e);
                }
            } else {
                boolean cfr_ignored_0 = part instanceof IEditorPart;
            }
        }

        public void partDeactivated(IWorkbenchPart part) {
        }

        public void partOpened(IWorkbenchPart part) {
            IEclipsePreferences prefs;
            if (part instanceof IEditorPart) {
                prefs = EclipseUtil.defaultScope().getNode("io.emmet.eclipse");
                if (prefs != null) {
                    prefs.putBoolean("tabExpand", true);
                }
                BuildFileManager.getInstance().addProjectHighPriorityIFiles((IEditorPart)part);
            }
            if (part instanceof AbstractThemeableEditor) {
                try {
                    prefs = EclipseUtil.instanceScope().getNode(CommonEditorPlugin.PLUGIN_ID);
                    boolean firstBinding = prefs.getBoolean("com.aptana.editor.common.firstBindingViewAutoOpen", true);
                    if (firstBinding) {
                        CommonEditorPlugin.this.showBindingsView();
                        prefs.putBoolean("com.aptana.editor.common.firstBindingViewAutoOpen", false);
                    }
                    boolean outlineAutoOpen = prefs.getBoolean("com.aptana.editor.common.outlineAutoOpen", true);
                    boolean first = prefs.getBoolean("com.aptana.editor.common.firstOutlineAutoOpen", true);
                    if (outlineAutoOpen) {
                        CommonEditorPlugin.this.showOutlineView();
                        if (first) {
                            prefs.putBoolean("com.aptana.editor.common.outlineAutoOpen", false);
                        }
                    }
                }
                catch (Exception e) {
                    Stats.addExceptionInfo((Throwable)e);
                }
                CommonEditorPlugin.openTempFile((AbstractThemeableEditor)part, null);
            }
        }
    };
    private final IPerspectiveListener fPerspectiveListener = new IPerspectiveListener(){

        public void perspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
            this.setCommandState(this.findView(page, CommonEditorPlugin.OUTLINE_VIEW_ID) != null);
        }

        public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, String changeId) {
            if (changeId.equals("viewHide")) {
                if (this.findView(page, CommonEditorPlugin.OUTLINE_VIEW_ID) == null) {
                    this.setCommandState(false);
                }
            } else if (changeId.equals("viewShow") && this.findView(page, CommonEditorPlugin.OUTLINE_VIEW_ID) != null) {
                this.setCommandState(true);
            }
        }

        private void setCommandState(boolean state) {
            ICommandService service = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
            Command command = service.getCommand(CommonEditorPlugin.COMMAND_ID);
            State commandState = command.getState(CommonEditorPlugin.COMMAND_STATE);
            if ((Boolean)commandState.getValue() != state) {
                commandState.setValue((Object)state);
                service.refreshElements(CommonEditorPlugin.COMMAND_ID, null);
            }
        }

        protected IViewReference findView(IWorkbenchPage page, String viewId) {
            IViewReference[] iViewReferenceArray = page.getViewReferences();
            int n = iViewReferenceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IViewReference ref = iViewReferenceArray[n2];
                if (viewId.equals(ref.getId())) {
                    return ref;
                }
                ++n2;
            }
            return null;
        }
    };
    private final IWindowListener fWindowListener = new IWindowListener(){

        public void windowActivated(IWorkbenchWindow window) {
        }

        public void windowClosed(IWorkbenchWindow window) {
            IPartService partService = window.getPartService();
            if (partService != null) {
                partService.removePartListener(CommonEditorPlugin.this.fPartListener);
            }
            window.removePerspectiveListener(CommonEditorPlugin.this.fPerspectiveListener);
        }

        public void windowDeactivated(IWorkbenchWindow window) {
        }

        public void windowOpened(IWorkbenchWindow window) {
            IPartService partService = window.getPartService();
            if (partService != null) {
                partService.addPartListener(CommonEditorPlugin.this.fPartListener);
            }
            window.addPerspectiveListener(CommonEditorPlugin.this.fPerspectiveListener);
        }
    };
    private DocumentScopeManager fDocumentScopeManager;
    private IEclipsePreferences.IPreferenceChangeListener fThemeChangeListener;
    private SpellingPreferences spellingPreferences;
    private static boolean isDeleted;

    static {
        VALIDATOR_BUILD_TYPE = 99;
        isDeleted = false;
    }

    public static void deleteTempFile(AbstractThemeableEditor editor) {
        File file;
        File tempDir;
        if (TEMP_FILES == null) {
            CommonEditorPlugin.initTempFile();
        }
        String title = editor.getTitle();
        String fileName = CommonEditorPlugin.getTempFileName(editor);
        if (title.startsWith(TEMP_STR) || title.startsWith("*\u65e0\u6807\u9898")) {
            fileName = fileName.replace("\u5f10_", SLASH);
            fileName = fileName.replace("\u5f10_", BACKSLASH);
            fileName = fileName.replace(COLON_STR, COLON);
            fileName = new File(fileName).getName();
        }
        if ((tempDir = CommonEditorPlugin.getTempFileDir()) != null && fileName != null && (file = new File(tempDir, fileName)).exists()) {
            file.delete();
        }
    }

    public static void deleteAllTempFiles() {
        File[] files;
        if (isDeleted) {
            return;
        }
        File tempDir = CommonEditorPlugin.getTempFileDir();
        if (!tempDir.exists()) {
            return;
        }
        File[] fileArray = files = tempDir.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            file.delete();
            ++n2;
        }
        isDeleted = true;
    }

    public static void openTempFile(final AbstractThemeableEditor editor, File file) {
        block25: {
            if (TEMP_FILES == null) {
                CommonEditorPlugin.initTempFile();
            }
            if (CollectionsUtil.isEmpty(TEMP_FILES)) {
                return;
            }
            String fileName = "";
            boolean isNone = false;
            if (file == null) {
                String title = editor.getTitle();
                fileName = CommonEditorPlugin.getTempFileName(editor);
                if (title.startsWith(TEMP_STR) || title.startsWith("*\u65e0\u6807\u9898")) {
                    fileName = fileName.replace("\u5f10_", SLASH);
                    fileName = fileName.replace("\u5f10_", BACKSLASH);
                    fileName = fileName.replace(COLON_STR, COLON);
                    fileName = new File(fileName).getName();
                    isNone = true;
                }
                if (!TEMP_FILES.containsKey(fileName)) {
                    return;
                }
                file = TEMP_FILES.get(fileName);
                if (file == null) {
                    return;
                }
            }
            if (!file.exists()) {
                return;
            }
            FileInputStream fis = null;
            ByteArrayOutputStream bos = null;
            try {
                try {
                    final StringBuilder stringBuilder = new StringBuilder();
                    fis = new FileInputStream(file);
                    int size = fis.available();
                    if (size > 0) {
                        bos = new ByteArrayOutputStream(size);
                        byte[] bytes = new byte[size];
                        int start = 0;
                        String charSet = CommonEditorPlugin.getCharSetString(editor);
                        while ((start = fis.read(bytes)) != -1) {
                            bos.write(bytes, 0, start);
                        }
                        bytes = bos.toByteArray();
                        stringBuilder.append(new String(bytes, charSet));
                    }
                    if (isNone) {
                        IWorkbenchPage page = editor.getSite().getPage();
                        IFileStore fileStore = CommonEditorPlugin.queryFileStore();
                        String title = fileName.replace(TEMP_STR, "");
                        final IEditorInput input = CommonEditorPlugin.createEditorInput(fileStore, page, title);
                        Display.getDefault().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    ISelection selection = editor.getSelectionProvider().getSelection();
                                    editor.setInput(input);
                                    editor.getDocument().set(stringBuilder.toString());
                                    editor.getSelectionProvider().setSelection(selection);
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                        });
                        break block25;
                    }
                    editor.getDocument().set(stringBuilder.toString());
                }
                catch (Exception e) {
                    IdeLog.logError((Plugin)CommonEditorPlugin.getDefault(), (Throwable)e);
                    try {
                        if (fis != null) {
                            fis.close();
                        }
                        if (bos != null) {
                            bos.close();
                        }
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                try {
                    if (fis != null) {
                        fis.close();
                    }
                    if (bos != null) {
                        bos.close();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static IFileStore queryFileStore() {
        IPath stateLocation = EditorsPlugin.getDefault().getStateLocation();
        IPath path = stateLocation.append("/_" + new Object().hashCode());
        return EFS.getLocalFileSystem().getStore(path);
    }

    private static IEditorInput createEditorInput(IFileStore fileStore, IWorkbenchPage page, String title) {
        IEditorReference[] editorReference = page.getEditorReferences();
        ArrayList<String> names = new ArrayList<String>();
        int i = 0;
        while (i < editorReference.length) {
            names.add(editorReference[i].getName());
            ++i;
        }
        return new NonExistingFileEditorInput(fileStore, title, names);
    }

    private static String getEditorId(IFileStore fileStore) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IEditorRegistry editorRegistry = workbench.getEditorRegistry();
        IEditorDescriptor descriptor = editorRegistry.getDefaultEditor(fileStore.getName());
        if (descriptor != null) {
            return descriptor.getId();
        }
        return "com.aptana.editor.html";
    }

    public static String getCharSetString(AbstractThemeableEditor editor) {
        String name = ResourcesPlugin.getEncoding();
        try {
            IEditorInput editorInput = editor.getEditorInput();
            if (editorInput instanceof FileEditorInput) {
                IFile file = (IFile)editorInput.getAdapter(IFile.class);
                name = file.getCharset();
            }
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)CommonEditorPlugin.getDefault(), (Throwable)e);
        }
        return name;
    }

    protected void showOutlineHelper() {
        StatusLineUtils.showStatusMessage((String)"\u82e5\u9700\u518d\u6b21\u6253\u5f00\u5927\u7eb2\u89c6\u56fe\uff0c\u8bf7\u70b9\u51fb\u83dc\u5355\u89c6\u56fe->\u663e\u793a\u89c6\u56fe->\u5927\u7eb2\uff0c\u5feb\u6377\u952e\u662fF10\u3002", (long)5000L);
    }

    protected void showOutlineView() {
        try {
            IViewPart viewPart;
            IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            if (activePage != null && (viewPart = activePage.findView(OUTLINE_VIEW_ID)) == null) {
                activePage.showView(OUTLINE_VIEW_ID);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void showBindingsView() {
        try {
            IViewPart viewPart;
            IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            if (activePage != null && (viewPart = activePage.findView(BINDINGS_VIEW_ID)) == null) {
                activePage.showView(BINDINGS_VIEW_ID, null, 3);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void activateProjectExplorer(IWorkbenchPage page) {
        IViewPart view = page.findView("org.eclipse.ui.navigator.ProjectExplorer");
        if (view != null) {
            page.activate((IWorkbenchPart)view);
            view.setFocus();
        }
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.listenForThemeChanges();
        IndexPlugin.getDefault();
        this.differentiator = new FilenameDifferentiator();
        this.differentiator.schedule();
        this.spellingPreferences = new SpellingPreferences();
        this.listenForPartState();
    }

    private void listenForPartState() {
        new UIJob("adding part listener"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                CommonEditorPlugin.this.addPartListener();
                return Status.OK_STATUS;
            }
        }.schedule(1000L);
    }

    private void listenForThemeChanges() {
        UIJob job = new UIJob("Set occurrence colors to theme"){

            private void setOccurrenceColors() {
                IEclipsePreferences prefs = EclipseUtil.instanceScope().getNode("org.eclipse.ui.editors");
                Theme theme = ThemePlugin.getDefault().getThemeManager().getCurrentTheme();
                if (theme.getName().contains("Monokai")) {
                    prefs.put("OccurrenceIndicationColor", StringConverter.asString((RGB)CommonEditorPlugin.this.occurrenceDarkColor));
                } else if (theme.getName().contains("\u7eff\u67d4")) {
                    prefs.put("OccurrenceIndicationColor", StringConverter.asString((RGB)CommonEditorPlugin.this.occurrenceLightColor));
                } else {
                    prefs.put("OccurrenceIndicationColor", StringConverter.asString((RGB)theme.getSearchResultColor()));
                }
                try {
                    prefs.flush();
                }
                catch (BackingStoreException backingStoreException) {}
            }

            public IStatus runInUIThread(IProgressMonitor monitor) {
                CommonEditorPlugin.this.fThemeChangeListener = new IEclipsePreferences.IPreferenceChangeListener(){

                    public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
                        if (event.getKey().equals("THEME_CHANGED")) {
                            this.setOccurrenceColors();
                        }
                    }
                };
                this.setOccurrenceColors();
                EclipseUtil.instanceScope().getNode("com.aptana.theme").addPreferenceChangeListener(CommonEditorPlugin.this.fThemeChangeListener);
                return Status.OK_STATUS;
            }
        };
        EclipseUtil.setSystemForJob((Job)job);
        job.schedule(2000L);
    }

    public void stop(BundleContext context) throws Exception {
        try {
            if (job != null) {
                job.cancel();
            }
            if (this.fThemeChangeListener != null) {
                EclipseUtil.instanceScope().getNode("com.aptana.theme").removePreferenceChangeListener(this.fThemeChangeListener);
                this.fThemeChangeListener = null;
            }
            this.differentiator.dispose();
            this.removePartListener();
            if (this.fDocumentScopeManager != null) {
                this.fDocumentScopeManager.dispose();
            }
            if (this.spellingPreferences != null) {
                this.spellingPreferences.dispose();
                this.spellingPreferences = null;
            }
        }
        finally {
            this.fDocumentScopeManager = null;
            this.differentiator = null;
            plugin = null;
            super.stop(context);
        }
    }

    public static CommonEditorPlugin getDefault() {
        return plugin;
    }

    protected void initializeImageRegistry(ImageRegistry reg) {
        reg.put(SNIPPET, CommonEditorPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)SNIPPET));
        reg.put(COMMAND, CommonEditorPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)COMMAND));
        reg.put(QUICKFIXERROR, CommonEditorPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)QUICKFIXERROR));
    }

    public Image getImageFromImageRegistry(String imageID) {
        return this.getImageRegistry().get(imageID);
    }

    public SpellingPreferences getSpellingPreferences() {
        return this.spellingPreferences;
    }

    public ContributionTemplateStore getTemplateStore(ContextTypeRegistry contextTypeRegistry) {
        ContributionTemplateStore store;
        if (this.fTemplateStoreMap == null) {
            this.fTemplateStoreMap = new HashMap<ContextTypeRegistry, ContributionTemplateStore>();
        }
        if ((store = this.fTemplateStoreMap.get(contextTypeRegistry)) == null) {
            store = new ContributionTemplateStore(contextTypeRegistry, this.getPreferenceStore(), TEMPLATES);
            try {
                store.load();
                this.fTemplateStoreMap.put(contextTypeRegistry, store);
            }
            catch (IOException e) {
                IdeLog.logError((Plugin)CommonEditorPlugin.getDefault(), (Throwable)e);
            }
        }
        return store;
    }

    public synchronized IDocumentScopeManager getDocumentScopeManager() {
        if (this.fDocumentScopeManager == null) {
            this.fDocumentScopeManager = new DocumentScopeManager();
        }
        return this.fDocumentScopeManager;
    }

    public IContentTypeTranslator getContentTypeTranslator() {
        return ContentTypeTranslation.getDefault();
    }

    private void addPartListener() {
        try {
            IWorkbench workbench = PlatformUI.getWorkbench();
            if (workbench != null) {
                IWorkbenchWindow[] windows;
                IWorkbenchWindow[] iWorkbenchWindowArray = windows = workbench.getWorkbenchWindows();
                int n = windows.length;
                int n2 = 0;
                while (n2 < n) {
                    IWorkbenchWindow window = iWorkbenchWindowArray[n2];
                    IPartService partService = window.getPartService();
                    if (partService != null) {
                        partService.addPartListener(this.fPartListener);
                    }
                    window.addPerspectiveListener(this.fPerspectiveListener);
                    ++n2;
                }
                PlatformUI.getWorkbench().addWindowListener(this.fWindowListener);
            }
        }
        catch (Exception exception) {}
    }

    private void removePartListener() {
        IWorkbench workbench = null;
        try {
            workbench = PlatformUI.getWorkbench();
        }
        catch (Exception exception) {}
        if (workbench != null) {
            IWorkbenchWindow[] windows;
            IWorkbenchWindow[] iWorkbenchWindowArray = windows = workbench.getWorkbenchWindows();
            int n = windows.length;
            int n2 = 0;
            while (n2 < n) {
                IWorkbenchWindow window = iWorkbenchWindowArray[n2];
                IPartService partService = window.getPartService();
                if (partService != null) {
                    partService.removePartListener(this.fPartListener);
                }
                window.removePerspectiveListener(this.fPerspectiveListener);
                ++n2;
            }
            PlatformUI.getWorkbench().removeWindowListener(this.fWindowListener);
        }
    }

    public IReferIndexQueryHelper getReferIndexQueryHelper() {
        if (this.referIndexQueryHelper != null) {
            return this.referIndexQueryHelper;
        }
        try {
            List helpers = RegistryUtils.getEp(IReferIndexQueryHelper.class, (String)"com.pandora.core.index.IndexQueryHelper", (String)"IndexQueryHelper", (String)"class");
            if (!CollectionsUtil.isEmpty((Collection)helpers)) {
                this.referIndexQueryHelper = (IReferIndexQueryHelper)helpers.get(0);
                return this.referIndexQueryHelper;
            }
        }
        catch (CoreException e) {
            IdeLog.logError((Plugin)CommonEditorPlugin.getDefault(), (Throwable)e);
        }
        return null;
    }

    public static File getTempFileDir() {
        IPath path = CommonEditorPlugin.getDefault().getStateLocation().append("temp");
        String pathString = path.getDevice() == null ? path.toString() : path.toOSString();
        File dir = new File(pathString);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return dir;
    }

    public static String getIFileTempName(IFile file) {
        IPath path = file.getProjectRelativePath();
        String name = path.toString();
        name = String.valueOf(file.getProject().getName()) + SLASH + name;
        return CommonEditorPlugin.getTempName(name);
    }

    public static String getTempName(String name) {
        name = name.replace(SLASH, "\u5f10_");
        name = name.replace(BACKSLASH, "\u5f10_");
        name = name.replace(COLON, COLON_STR);
        return name;
    }

    public static String getTempFileName(AbstractThemeableEditor editor) {
        IEditorInput editorInput = editor.getEditorInput();
        String fileName = null;
        if (editorInput instanceof FileEditorInput) {
            IFile file = (IFile)editorInput.getAdapter(IFile.class);
            fileName = CommonEditorPlugin.getIFileTempName(file);
        } else if (editorInput instanceof FileStoreEditorInput) {
            FileStoreEditorInput fileStoreEditorInput = (FileStoreEditorInput)editorInput;
            fileName = CommonEditorPlugin.getLocalFileTempName(fileStoreEditorInput);
        } else if (editorInput instanceof NonExistingFileEditorInput) {
            String title = editor.getTitle();
            fileName = TEMP_STR + title;
        }
        return fileName;
    }

    public static String getLocalFileTempName(FileStoreEditorInput fileStoreEditorInput) {
        URI uri = fileStoreEditorInput.getURI();
        File file = new File(uri);
        String fileName = file.getAbsolutePath();
        return CommonEditorPlugin.getTempName(fileName);
    }

    public static void initTempFile() {
        File[] files;
        File tempDir;
        if (TEMP_FILES == null) {
            TEMP_FILES = new HashMap<String, File>();
        }
        if (!(tempDir = CommonEditorPlugin.getTempFileDir()).exists()) {
            return;
        }
        File[] fileArray = files = tempDir.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            TEMP_FILES.put(file.getName(), file);
            ++n2;
        }
        final HashMap modifyStampMap = new HashMap();
        job = new Job("\u5b9a\u65f6\u4fdd\u5b58\u672a\u4fdd\u5b58\u6587\u4ef6"){

            protected IStatus run(final IProgressMonitor monitor) {
                try {
                    if (monitor.isCanceled()) {
                        IStatus iStatus = Status.CANCEL_STATUS;
                        return iStatus;
                    }
                    final IWorkbench workbench = PlatformUI.getWorkbench();
                    if (workbench == null) {
                        IStatus iStatus = Status.CANCEL_STATUS;
                        return iStatus;
                    }
                    if (monitor.isCanceled()) {
                        IStatus iStatus = Status.CANCEL_STATUS;
                        return iStatus;
                    }
                    final IWorkbenchWindow[] workbenchWindow = new IWorkbenchWindow[1];
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            workbenchWindow[0] = workbench.getActiveWorkbenchWindow();
                        }
                    });
                    IWorkbenchPage page = workbenchWindow[0].getActivePage();
                    if (page == null) {
                        IStatus iStatus = Status.CANCEL_STATUS;
                        return iStatus;
                    }
                    try {
                        IEditorReference[] references;
                        IEditorReference[] iEditorReferenceArray = references = page.getEditorReferences();
                        int n = references.length;
                        int n2 = 0;
                        while (n2 < n) {
                            AbstractThemeableEditor abstractThemeableEditor;
                            IDocument document;
                            IEditorPart editorPart;
                            IEditorReference reference = iEditorReferenceArray[n2];
                            if (reference != null && (editorPart = reference.getEditor(false)) instanceof AbstractThemeableEditor && editorPart.isDirty() && (document = (abstractThemeableEditor = (AbstractThemeableEditor)editorPart).getDocument()) instanceof IDocumentExtension4) {
                                IDocumentExtension4 doc4 = (IDocumentExtension4)document;
                                long modification = doc4.getModificationStamp();
                                if (modifyStampMap.containsKey(abstractThemeableEditor)) {
                                    Long prestamp = (Long)modifyStampMap.get(abstractThemeableEditor);
                                    if (prestamp != modification) {
                                        abstractThemeableEditor.doSaveTempFile(false);
                                    }
                                } else {
                                    abstractThemeableEditor.doSaveTempFile(false);
                                }
                                modifyStampMap.put(abstractThemeableEditor, modification);
                            }
                            ++n2;
                        }
                        Display.getDefault().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                                    public void run() throws Exception {
                                        try {
                                            if (monitor.isCanceled()) {
                                                return;
                                            }
                                            if (workbench instanceof Workbench) {
                                                Workbench w = (Workbench)workbench;
                                                if (monitor.isCanceled()) {
                                                    return;
                                                }
                                                w.saveMemen();
                                            }
                                        }
                                        catch (Exception e) {
                                            e.printStackTrace();
                                        }
                                    }
                                });
                            }
                        });
                    }
                    catch (Exception e) {
                        IdeLog.logError((Plugin)CommonEditorPlugin.getDefault(), (Throwable)e);
                    }
                }
                finally {
                    this.schedule(60000L);
                }
                return Status.OK_STATUS;
            }
        };
        job.setUser(false);
        job.setSystem(true);
        job.schedule(60000L);
    }
}

