/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.common;

import com.aptana.core.CorePlugin;
import com.aptana.core.build.UnifiedBuilder;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.EclipseUtil;
import com.aptana.core.util.PlatformUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.editor.common.CommonEditorPlugin;
import com.aptana.editor.common.CommonOccurrencesUpdater;
import com.aptana.editor.common.CommonSourceViewerConfiguration;
import com.aptana.editor.common.Messages;
import com.aptana.editor.common.UntitledFileStorageEditorInput;
import com.aptana.editor.common.actions.FilterThroughCommandAction;
import com.aptana.editor.common.actions.FoldingActionsGroup;
import com.aptana.editor.common.actions.ShowIndentGuideAction;
import com.aptana.editor.common.dnd.SnippetTransfer;
import com.aptana.editor.common.extensions.FindBarEditorExtension;
import com.aptana.editor.common.extensions.IThemeableEditor;
import com.aptana.editor.common.extensions.ThemeableEditorExtension;
import com.aptana.editor.common.internal.AbstractFoldingEditor;
import com.aptana.editor.common.internal.peer.CharacterPairMatcher;
import com.aptana.editor.common.internal.peer.PeerCharacterCloser;
import com.aptana.editor.common.internal.scripting.CommandElementsProvider;
import com.aptana.editor.common.link.LinkedModeUI2;
import com.aptana.editor.common.outline.CommonOutlinePage;
import com.aptana.editor.common.properties.CommonEditorPropertySheetPage;
import com.aptana.editor.common.scripting.commands.CommandExecutionUtils;
import com.aptana.editor.common.text.reconciler.IFoldingComputer;
import com.aptana.editor.common.text.reconciler.RubyRegexpFolder;
import com.aptana.editor.common.util.EditorUtil;
import com.aptana.editor.common.viewer.CommonProjectionViewer;
import com.aptana.editor.common.viewer.IndentGuidePainter;
import com.aptana.parsing.ParseResult;
import com.aptana.parsing.ParserPoolFactory;
import com.aptana.parsing.ast.IParseNode;
import com.aptana.parsing.ast.IParseRootNode;
import com.aptana.parsing.lexer.IRange;
import com.aptana.scripting.model.BundleElement;
import com.aptana.scripting.model.CommandElement;
import com.aptana.scripting.model.CommandResult;
import com.aptana.scripting.model.InvocationType;
import com.aptana.scripting.model.SnippetElement;
import com.aptana.scripting.ui.ICommandElementsProvider;
import com.aptana.theme.Theme;
import com.aptana.theme.ThemePlugin;
import com.aptana.ui.commands.OpenFileManagerContributionItem;
import com.aptana.ui.util.UIUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.net.URI;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.State;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.IFileBuffer;
import org.eclipse.core.filebuffers.manipulation.RemoveTrailingWhitespaceOperation;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.jface.text.IPainter;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension2;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.CommonLineNumberChangeRulerColumn;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.IChangeRulerColumn;
import org.eclipse.jface.text.source.ICharacterPairMatcher;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.IVerticalRulerColumn;
import org.eclipse.jface.text.source.LineNumberRulerColumn;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.osgi.internal.profile.Profile;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.dnd.IDragAndDropService;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.editors.text.TextFileDocumentProvider;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import org.eclipse.ui.internal.editors.text.NonExistingFileEditorInput;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.menus.CommandContributionItemParameter;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.services.IServiceLocator;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;
import org.eclipse.ui.texteditor.IUpdate;
import org.eclipse.ui.texteditor.SourceViewerDecorationSupport;
import org.eclipse.ui.texteditor.TextOperationAction;
import org.eclipse.ui.views.contentoutline.ContentOutline;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.ui.views.properties.IPropertySheetPage;

public abstract class AbstractThemeableEditor
extends AbstractFoldingEditor
implements IThemeableEditor {
    public static final String EDITOR_PART_PROPERTY_TYPE_KEY = "EDITOR_PART_PROPERTY_TYPE_KEY";
    public static final Color TABFOLDER_BACKGROUND_COLOR = new Color((Device)Display.getDefault(), 238, 232, 216);
    public final boolean profile = Profile.STARTUP;
    private LinkedPositionGroup fLinkedPositionGroup;
    protected static final char[] DEFAULT_PAIR_MATCHING_CHARS = new char[]{'<', '>', '(', ')', '{', '}', '[', ']', '`', '`', '\'', '\'', '\"', '\"'};
    private static final List<String> TO_REMOVE_POPUP_MENU = new ArrayList<String>();
    private IndentGuidePainter painter = null;
    private ICommandElementsProvider fCommandElementsProvider;
    private CommonOutlinePage fOutlinePage;
    private boolean fCursorChangeListened;
    private SelectionChangedListener fSelectionChangedListener;
    private DoubleClickSelectionParisMouseListener fDoubleClickSelectionMouseListener;
    private LinkModelOnClickMouseListener fLinkModelOnClickMouseListener;
    private FindBarEditorExtension fThemeableEditorFindBarExtension;
    private ThemeableEditorExtension fThemeableEditorColorsExtension;
    private IPropertyChangeListener fThemeListener;
    private PeerCharacterCloser fPeerCharacterCloser;
    private FoldingActionsGroup foldingActionsGroup;
    private ControlListener fWordWrapControlListener;
    private CommonOccurrencesUpdater occurrencesUpdater;
    private IPropertyChangeListener fontChangeListener;
    private Job linkWithEditorJob;
    protected boolean outlineAutoExpanded;
    private long lastModificationStamp = -1L;
    private SoftReference<ParseResult> lastAstForModificationStamp = null;
    private Object modificationStampLock = new Object();
    public boolean openManualValidator;
    private boolean isClose;

    static {
        TO_REMOVE_POPUP_MENU.add("compareWithMenu");
        TO_REMOVE_POPUP_MENU.add("replaceWithMenu");
        TO_REMOVE_POPUP_MENU.add("ValidationAction");
    }

    public LinkedPositionGroup getfLinkedPositionGroup() {
        return this.fLinkedPositionGroup;
    }

    public void setfLinkedPositionGroup(LinkedPositionGroup fLinkedPositionGroup) {
        this.fLinkedPositionGroup = fLinkedPositionGroup;
    }

    protected AbstractThemeableEditor() {
        this.fThemeableEditorFindBarExtension = new FindBarEditorExtension((IAdaptable)this);
        this.fThemeableEditorColorsExtension = new ThemeableEditorExtension(this);
    }

    protected void manageEditorPopupMenu(Menu menu) {
        if (menu != null) {
            MenuItem[] items;
            MenuItem[] menuItemArray = items = menu.getItems();
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                MenuItem menuItem = menuItemArray[n2];
                Object data = menuItem.getData();
                if (data instanceof IContributionItem) {
                    IContributionItem item = (IContributionItem)data;
                    String itemId = item.getId();
                    if (itemId == null && item instanceof MenuManager && (item = ((MenuManager)item).find("viewsShowIn")) != null) {
                        menuItem.dispose();
                    } else if (TO_REMOVE_POPUP_MENU.contains(itemId)) {
                        IdeLog.logInfo((Plugin)CorePlugin.getDefault(), (String)("\u79fb\u9664\u7f16\u8f91\u5668\u53f3\u952e\u83dc\u5355\uff1a" + menuItem.getText()));
                        menuItem.dispose();
                    }
                }
                ++n2;
            }
        }
    }

    @Override
    public final ISourceViewer getISourceViewer() {
        return super.getSourceViewer();
    }

    public final SourceViewerConfiguration getISourceViewerConfiguration() {
        return super.getSourceViewerConfiguration();
    }

    @Override
    public final IVerticalRuler getIVerticalRuler() {
        return super.getVerticalRuler();
    }

    @Override
    public void createPartControl(Composite parent) {
        this.fThemeableEditorColorsExtension.setParent(parent);
        Composite findBarComposite = this.fThemeableEditorFindBarExtension.createFindBarComposite(parent);
        Assert.isNotNull((Object)findBarComposite);
        if (this.profile) {
            Profile.logEnter((String)"hbuilder.absEditor.super.createPartControl");
        }
        super.createPartControl(findBarComposite);
        try {
            this.getSourceViewer().getTextWidget().setData("needDropOutBounds", (Object)true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.profile) {
            Profile.logExit((String)"hbuilder.absEditor.super.createPartControl");
        }
        this.fThemeableEditorFindBarExtension.createFindBar(this.getSourceViewer());
        this.fThemeableEditorColorsExtension.overrideThemeColors();
        this.fPeerCharacterCloser = new PeerCharacterCloser(this, (ITextViewer)this.getSourceViewer());
        this.fPeerCharacterCloser.install();
        this.fPeerCharacterCloser.setAutoInsertEnabled(this.getPreferenceStore().getBoolean("com.aptana.editor.common.editorPeerCharacterClose"));
        this.fPeerCharacterCloser.setAutoWrapEnabled(this.getPreferenceStore().getBoolean("com.aptana.editor.common.editorWrapSelection"));
        this.fCursorChangeListened = true;
        this.fSelectionChangedListener = new SelectionChangedListener();
        this.fSelectionChangedListener.install(this.getSelectionProvider());
        this.fDoubleClickSelectionMouseListener = new DoubleClickSelectionParisMouseListener();
        this.getSourceViewer().getTextWidget().addMouseListener((MouseListener)this.fDoubleClickSelectionMouseListener);
        this.fLinkModelOnClickMouseListener = new LinkModelOnClickMouseListener();
        this.getSourceViewer().getTextWidget().addMouseListener((MouseListener)this.fLinkModelOnClickMouseListener);
        this.fThemeListener = new PropertyChangeListener();
        ThemePlugin.getDefault().getPreferenceStore().addPropertyChangeListener(this.fThemeListener);
        this.fThemeableEditorFindBarExtension.activateContexts(new String[]{"com.aptana.editor.context", "com.aptana.scripting.context"});
        if (this.isWordWrapEnabled()) {
            this.setWordWrapEnabled(true);
        }
        this.installOccurrencesUpdater();
        try {
            this.initPopupMenu();
            this.installMouseWheelSupport();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void installMouseWheelSupport() {
        CtrlMouseWheelListener ctrlMouseWheelListener = new CtrlMouseWheelListener();
        this.getSourceViewer().getTextWidget().addListener(37, (Listener)ctrlMouseWheelListener);
        this.getSourceViewer().getTextWidget().addListener(6, (Listener)ctrlMouseWheelListener);
        this.getSourceViewer().getTextWidget().addListener(7, (Listener)ctrlMouseWheelListener);
    }

    private boolean isKeyCharacter(char character) {
        char[] pairs = this.getPairMatchingCharacters();
        int i = 0;
        while (i < pairs.length) {
            if (pairs[i] == character) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void initPopupMenu() {
        this.getSourceViewer().getTextWidget().getMenu().addMenuListener(new MenuListener(){

            public void menuShown(MenuEvent e) {
                if (e.getSource() instanceof Menu) {
                    Menu menu = (Menu)e.getSource();
                    AbstractThemeableEditor.this.manageEditorPopupMenu(menu);
                }
            }

            public void menuHidden(MenuEvent e) {
            }
        });
    }

    protected void installOccurrencesUpdater() {
        this.occurrencesUpdater = new CommonOccurrencesUpdater(this);
        this.occurrencesUpdater.initialize(CommonEditorPlugin.getDefault().getPreferenceStore());
    }

    protected void initializeDragAndDrop(ISourceViewer viewer) {
        super.initializeDragAndDrop(viewer);
        IDragAndDropService dndService = (IDragAndDropService)this.getSite().getService(IDragAndDropService.class);
        if (dndService == null) {
            return;
        }
        StyledText st = viewer.getTextWidget();
        DropTarget dropTarget = (DropTarget)st.getData("DropTarget");
        if (dropTarget != null) {
            Object[] transfers = dropTarget.getTransfer();
            List allTransfers = CollectionsUtil.newList((Object[])transfers);
            allTransfers.add(SnippetTransfer.getInstance());
            dropTarget.setTransfer(allTransfers.toArray(new Transfer[allTransfers.size()]));
            dropTarget.addDropListener((DropTargetListener)new SnippetDropTargetListener());
        } else {
            dndService.addMergedDropTarget((Control)st, 1, new Transfer[]{SnippetTransfer.getInstance()}, (DropTargetListener)new SnippetDropTargetListener());
        }
    }

    public Object getAdapter(Class adapter) {
        Object adaptable;
        if (SourceViewerConfiguration.class == adapter) {
            return this.getSourceViewerConfiguration();
        }
        if (IContentOutlinePage.class == adapter) {
            return this.getOutlinePage();
        }
        if (ISourceViewer.class == adapter || ITextViewer.class == adapter) {
            return this.getSourceViewer();
        }
        if (IPreferenceStore.class == adapter) {
            return this.getPluginPreferenceStore();
        }
        if (ICommandElementsProvider.class == adapter) {
            return this.getCommandElementsProvider();
        }
        if (this.fThemeableEditorFindBarExtension != null && (adaptable = this.fThemeableEditorFindBarExtension.getFindBarDecoratorAdapter(adapter)) != null) {
            return adaptable;
        }
        if (adapter == IPropertySheetPage.class) {
            return new CommonEditorPropertySheetPage(this.getSourceViewer());
        }
        return super.getAdapter(adapter);
    }

    public CommonOutlinePage getOutlinePage() {
        if (this.fOutlinePage == null) {
            this.fOutlinePage = this.createOutlinePage();
        }
        return this.fOutlinePage;
    }

    public ITreeContentProvider getOutlineContentProvider() {
        return null;
    }

    public ILabelProvider getOutlineLabelProvider() {
        return null;
    }

    protected CommonOutlinePage createOutlinePage() {
        ITreeContentProvider outlineContentProvider = this.getOutlineContentProvider();
        ILabelProvider outlineLabelProvider = this.getOutlineLabelProvider();
        if (outlineContentProvider == null || outlineLabelProvider == null) {
            return null;
        }
        CommonOutlinePage outline = new CommonOutlinePage(this, this.getOutlinePreferenceStore());
        outline.setContentProvider(outlineContentProvider);
        outline.setLabelProvider(outlineLabelProvider);
        return outline;
    }

    protected abstract IPreferenceStore getPluginPreferenceStore();

    protected void initializeLineNumberRulerColumn(LineNumberRulerColumn rulerColumn) {
        super.initializeLineNumberRulerColumn(rulerColumn);
        if (rulerColumn instanceof CommonLineNumberChangeRulerColumn) {
            ((CommonLineNumberChangeRulerColumn)rulerColumn).showLineNumbers(this.isLineNumberRulerVisible());
        }
        this.fThemeableEditorColorsExtension.initializeLineNumberRulerColumn(rulerColumn);
    }

    @Override
    protected ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        this.fAnnotationAccess = this.getAnnotationAccess();
        this.fOverviewRuler = this.createOverviewRuler(this.getSharedColors());
        CommonProjectionViewer viewer = new CommonProjectionViewer(parent, ruler, this.getOverviewRuler(), this.isOverviewRulerVisible(), styles);
        viewer.addAdapter(AbstractThemeableEditor.class, this);
        viewer.addAdapter(ITextEditor.class, this);
        this.getSourceViewerDecorationSupport((ISourceViewer)viewer);
        this.fThemeableEditorColorsExtension.createBackgroundPainter((ISourceViewer)viewer);
        return viewer;
    }

    protected void configureSourceViewerDecorationSupport(SourceViewerDecorationSupport support) {
        super.configureSourceViewerDecorationSupport(support);
        support.setCharacterPairMatcher((ICharacterPairMatcher)new CharacterPairMatcher(this.getPairMatchingCharacters()));
        support.setMatchingCharacterPainterPreferenceKeys("com.aptana.editor.common.enableCharacterPairColoring", "com.aptana.editor.common.characterPairColor");
    }

    public char[] getPairMatchingCharacters() {
        return DEFAULT_PAIR_MATCHING_CHARS;
    }

    @Override
    public void dispose() {
        try {
            ProjectionViewer viewer;
            ISourceViewer sourceViewer;
            SourceViewerConfiguration svc;
            if (!this.isClose) {
                CommonEditorPlugin.deleteTempFile(this);
            }
            if (this.lastAstForModificationStamp != null) {
                this.lastAstForModificationStamp.clear();
                this.lastAstForModificationStamp = null;
            }
            if (this.fontChangeListener != null) {
                try {
                    PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().getFontRegistry().removeListener(this.fontChangeListener);
                }
                catch (Exception exception) {}
                this.fontChangeListener = null;
            }
            if ((svc = this.getSourceViewerConfiguration()) instanceof CommonSourceViewerConfiguration) {
                ((CommonSourceViewerConfiguration)svc).dispose();
            }
            if ((sourceViewer = this.getSourceViewer()) != null) {
                if (sourceViewer instanceof CommonProjectionViewer) {
                    ((CommonProjectionViewer)sourceViewer).removeAdapter(AbstractThemeableEditor.class);
                    ((CommonProjectionViewer)sourceViewer).removeAdapter(ITextEditor.class);
                }
                StyledText textWidget = sourceViewer.getTextWidget();
                if (this.fWordWrapControlListener != null) {
                    if (textWidget != null && !textWidget.isDisposed()) {
                        textWidget.removeControlListener(this.fWordWrapControlListener);
                    }
                    this.fWordWrapControlListener = null;
                }
                if (this.fDoubleClickSelectionMouseListener != null) {
                    if (textWidget != null && !textWidget.isDisposed()) {
                        textWidget.removeMouseListener((MouseListener)this.fDoubleClickSelectionMouseListener);
                    }
                    this.fDoubleClickSelectionMouseListener = null;
                }
                if (this.fLinkModelOnClickMouseListener != null) {
                    if (textWidget != null && !textWidget.isDisposed()) {
                        textWidget.removeMouseListener((MouseListener)this.fLinkModelOnClickMouseListener);
                    }
                    this.fLinkModelOnClickMouseListener = null;
                }
            }
            if (this.occurrencesUpdater != null) {
                this.occurrencesUpdater.dispose();
                this.occurrencesUpdater = null;
            }
            if (this.fSelectionChangedListener != null) {
                this.fSelectionChangedListener.uninstall(this.getSelectionProvider());
                this.fSelectionChangedListener = null;
            }
            if (this.fThemeListener != null) {
                ThemePlugin.getDefault().getPreferenceStore().removePropertyChangeListener(this.fThemeListener);
                this.fThemeListener = null;
            }
            if (this.fThemeableEditorColorsExtension != null) {
                this.fThemeableEditorColorsExtension.dispose();
                this.fThemeableEditorColorsExtension = null;
            }
            if (this.fThemeableEditorFindBarExtension != null) {
                this.fThemeableEditorFindBarExtension.dispose();
                this.fThemeableEditorFindBarExtension = null;
            }
            if (this.foldingActionsGroup != null) {
                this.foldingActionsGroup.dispose();
                this.foldingActionsGroup = null;
            }
            if (this.fOutlinePage != null) {
                this.fOutlinePage.dispose();
                this.fOutlinePage = null;
            }
            this.fCommandElementsProvider = null;
            this.fPeerCharacterCloser = null;
            IDragAndDropService dndService = (IDragAndDropService)this.getSite().getService(IDragAndDropService.class);
            if (dndService != null && (viewer = (ProjectionViewer)this.getSourceViewer()) != null) {
                StyledText st = viewer.getTextWidget();
                dndService.removeMergedDropTarget((Control)st);
            }
            if (this.painter != null && this.getSourceViewer() instanceof ITextViewerExtension2) {
                ((ITextViewerExtension2)this.getSourceViewer()).removePainter((IPainter)this.painter);
                this.painter.dispose();
                this.painter = null;
            }
        }
        finally {
            super.dispose();
        }
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        if (this.profile) {
            Profile.logEnter((String)"hbuilder.absEditor.super.init");
        }
        super.init(site, input);
        if (this.profile) {
            Profile.logExit((String)"hbuilder.absEditor.super.init");
        }
        this.setEditorContextMenuId(this.getSite().getId());
        this.applyEditorFont();
    }

    protected void applyEditorFont() {
        try {
            if (this.fontChangeListener == null) {
                this.fontChangeListener = new IPropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent event) {
                        FontData[] fontData;
                        if ("org.eclipse.jface.textfont".equals(event.getProperty()) && event.getNewValue() instanceof FontData[] && (fontData = (FontData[])event.getNewValue()) != null && fontData.length > 0) {
                            WorkbenchPlugin.getDefault().getPreferenceStore().putValue(event.getProperty(), fontData[0].toString());
                        }
                    }
                };
            }
            PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().getFontRegistry().addListener(this.fontChangeListener);
        }
        catch (Exception exception) {}
    }

    protected void initializeEditor() {
        this.setPreferenceStore((IPreferenceStore)new ChainedPreferenceStore(new IPreferenceStore[]{CommonEditorPlugin.getDefault().getPreferenceStore(), EditorsPlugin.getDefault().getPreferenceStore()}));
    }

    public void doSave(IProgressMonitor progressMonitor) {
        if (this.getPreferenceStore().getBoolean("com.aptana.editor.common.removeTrailingWhitespace")) {
            RemoveTrailingWhitespaceOperation removeSpacesOperation = new RemoveTrailingWhitespaceOperation();
            try {
                removeSpacesOperation.run((IFileBuffer)FileBuffers.getTextFileBufferManager().getTextFileBuffer(this.getDocument()), progressMonitor);
            }
            catch (Exception e) {
                IdeLog.logError((Plugin)CommonEditorPlugin.getDefault(), (String)"Error while removing the trailing whitespaces.", (Throwable)e);
            }
        }
        if (this.getEditorInput() instanceof UntitledFileStorageEditorInput) {
            this.performSaveAs(progressMonitor);
        } else {
            if (this.getEditorInput() instanceof IFileEditorInput) {
                try {
                    UnifiedBuilder.saveMap.put(((IFileEditorInput)this.getEditorInput()).getFile().getLocationURI(), true);
                }
                catch (Exception e) {
                    IdeLog.logError((Plugin)CommonEditorPlugin.getDefault(), (Throwable)e);
                }
            }
            super.doSave(progressMonitor);
        }
        CommonEditorPlugin.deleteTempFile(this);
    }

    public boolean isDirty() {
        if (this.getEditorInput() instanceof UntitledFileStorageEditorInput) {
            return true;
        }
        return super.isDirty();
    }

    protected void performSaveAs(IProgressMonitor progressMonitor) {
        progressMonitor = progressMonitor == null ? new NullProgressMonitor() : progressMonitor;
        IEditorInput input = this.getEditorInput();
        if (input instanceof UntitledFileStorageEditorInput) {
            boolean success;
            block16: {
                IFileStore fileStore;
                Shell shell = this.getSite().getShell();
                FileDialog fileDialog = new FileDialog(shell, 8192);
                fileDialog.setFileName(input.getName());
                String path = fileDialog.open();
                if (path == null) {
                    progressMonitor.setCanceled(true);
                    return;
                }
                File localFile = new File(path);
                if (localFile.exists() && !MessageDialog.openConfirm((Shell)shell, (String)Messages.AbstractThemeableEditor_ConfirmOverwrite_Title, (String)MessageFormat.format(Messages.AbstractThemeableEditor_ConfirmOverwrite_Message, path))) {
                    progressMonitor.setCanceled(true);
                }
                try {
                    fileStore = EFS.getStore((URI)localFile.toURI());
                }
                catch (CoreException e) {
                    IdeLog.logError((Plugin)CommonEditorPlugin.getDefault(), (Throwable)e);
                    MessageDialog.openError((Shell)shell, (String)Messages.AbstractThemeableEditor_Error_Title, (String)MessageFormat.format(Messages.AbstractThemeableEditor_Error_Message, path));
                    return;
                }
                IDocumentProvider provider = this.getDocumentProvider();
                if (provider == null) {
                    return;
                }
                IFile file = this.getWorkspaceFile(fileStore);
                Object newInput = file != null ? new FileEditorInput(file) : new FileStoreEditorInput(fileStore);
                success = false;
                try {
                    try {
                        provider.aboutToChange(newInput);
                        provider.saveDocument(progressMonitor, newInput, provider.getDocument((Object)input), true);
                        success = true;
                    }
                    catch (CoreException e) {
                        IStatus status = e.getStatus();
                        if (status == null || status.getSeverity() != 8) {
                            MessageDialog.openError((Shell)shell, (String)Messages.AbstractThemeableEditor_Error_Title, (String)MessageFormat.format(Messages.AbstractThemeableEditor_Error_Message, path));
                        }
                        provider.changed(newInput);
                        if (success) {
                            this.setInput((IEditorInput)newInput);
                        }
                        break block16;
                    }
                }
                catch (Throwable throwable) {
                    provider.changed(newInput);
                    if (success) {
                        this.setInput((IEditorInput)newInput);
                    }
                    throw throwable;
                }
                provider.changed(newInput);
                if (success) {
                    this.setInput((IEditorInput)newInput);
                }
            }
            progressMonitor.setCanceled(!success);
        } else {
            super.performSaveAs(progressMonitor);
        }
        CommonEditorPlugin.deleteTempFile(this);
    }

    private IFile getWorkspaceFile(IFileStore fileStore) {
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IFile[] files = workspaceRoot.findFilesForLocationURI(fileStore.toURI());
        if (files != null && files.length > 0) {
            return files[0];
        }
        return null;
    }

    public String getContentType() {
        try {
            IContentType contentType = ((TextFileDocumentProvider)this.getDocumentProvider()).getContentType((Object)this.getEditorInput());
            if (contentType != null) {
                return contentType.getId();
            }
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)CommonEditorPlugin.getDefault(), (Throwable)e);
        }
        return null;
    }

    protected void initializeViewerColors(ISourceViewer viewer) {
        if (viewer == null || viewer.getTextWidget() == null) {
            return;
        }
        super.initializeViewerColors(viewer);
    }

    protected void handlePreferenceStoreChanged(PropertyChangeEvent event) {
        super.handlePreferenceStoreChanged(event);
        if (this.fThemeableEditorColorsExtension == null) {
            return;
        }
        this.fThemeableEditorColorsExtension.handlePreferenceStoreChanged(event);
        String property = event.getProperty();
        if (property.equals("lineNumberRuler")) {
            ((CommonLineNumberChangeRulerColumn)this.fLineNumberRulerColumn).showLineNumbers(this.isLineNumberRulerVisible());
            try {
                ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
                Command command = commandService.getCommand("com.pandora.ui.lineNumberToggle");
                State state = command.getState("org.eclipse.ui.commands.toggleState");
                if (state != null) {
                    state.setValue(event.getNewValue());
                }
            }
            catch (Exception e) {
                IdeLog.logError((Plugin)CommonEditorPlugin.getDefault(), (Throwable)e);
            }
        } else if (property.equals("com.aptana.editor.common.editorPeerCharacterClose")) {
            this.fPeerCharacterCloser.setAutoInsertEnabled(Boolean.parseBoolean(StringUtil.getStringValue((Object)event.getNewValue())));
        } else if (property.equals("com.aptana.editor.common.editorWrapSelection")) {
            this.fPeerCharacterCloser.setAutoWrapEnabled(Boolean.parseBoolean(StringUtil.getStringValue((Object)event.getNewValue())));
        } else if (property.equals("com.aptana.editor.common.enableFolding")) {
            SourceViewerConfiguration config = this.getSourceViewerConfiguration();
            if (config instanceof CommonSourceViewerConfiguration) {
                ((CommonSourceViewerConfiguration)config).forceReconcile();
            }
        } else {
            if ("com.aptana.editor.common.useGlobalDefaults".equals(property)) {
                IPreferenceStore store = this.getPreferenceStore();
                if (store != null) {
                    this.getSourceViewer().getTextWidget().setTabs(store.getInt("tabWidth"));
                }
                if (this.isTabsToSpacesConversionEnabled()) {
                    this.installTabsToSpacesConverter();
                } else {
                    this.uninstallTabsToSpacesConverter();
                }
                return;
            }
            if ("com.aptana.editor.common.showIndentGuide".equals(property)) {
                IAction action = this.getAction("com.pandora.editor.ui.toggleShowIndentGuide");
                if (action instanceof IUpdate) {
                    ((IUpdate)action).update();
                }
                return;
            }
        }
    }

    public Object computeHighlightedOutlineNode(int caretOffset) {
        return this.getOutlineElementAt(caretOffset);
    }

    public int getCaretOffset() {
        ISourceViewer sourceViewer = this.getSourceViewer();
        if (sourceViewer == null) {
            return -1;
        }
        StyledText styledText = sourceViewer.getTextWidget();
        if (styledText == null) {
            return -1;
        }
        if (sourceViewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 extension = (ITextViewerExtension5)sourceViewer;
            return extension.widgetOffset2ModelOffset(styledText.getCaretOffset());
        }
        int offset = sourceViewer.getVisibleRegion().getOffset();
        return offset + styledText.getCaretOffset();
    }

    public void select(IRange element, boolean checkIfOutlineActive) {
        try {
            if (element != null && (!checkIfOutlineActive || this.isOutlinePageActive())) {
                this.fCursorChangeListened = false;
                this.setSelectedElement(element);
            }
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)CommonEditorPlugin.getDefault(), (Throwable)e);
        }
    }

    protected void setSelectedElement(IRange element) {
        if (element == null || element.getStartingOffset() == -1) {
            return;
        }
        try {
            int offset = element.getStartingOffset();
            int length = element.getLength();
            this.setHighlightRange(offset, length, false);
            this.selectAndReveal(offset, length);
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)CommonEditorPlugin.getDefault(), (Throwable)e);
        }
    }

    protected void selectionChanged() {
        if (CommonOutlinePage.isClosed) {
            return;
        }
        try {
            if (this.fCursorChangeListened) {
                if (this.hasOutlinePageCreated() && this.isLinkedWithEditor()) {
                    final int caretOffset = this.getCaretOffset();
                    if (this.linkWithEditorJob != null) {
                        this.linkWithEditorJob.cancel();
                    }
                    this.linkWithEditorJob = new Job("Computing Outline node to select..."){

                        protected IStatus run(IProgressMonitor monitor) {
                            final Object outlineNode = AbstractThemeableEditor.this.computeHighlightedOutlineNode(caretOffset);
                            UIUtils.getDisplay().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    AbstractThemeableEditor.this.getOutlinePage().select(outlineNode);
                                }
                            });
                            return Status.OK_STATUS;
                        }
                    };
                    EclipseUtil.setSystemForJob((Job)this.linkWithEditorJob);
                    this.linkWithEditorJob.schedule();
                }
            } else {
                this.fCursorChangeListened = true;
            }
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)CommonEditorPlugin.getDefault(), (Throwable)e);
        }
    }

    protected void createActions() {
        IAction cutAction;
        super.createActions();
        this.setAction("com.aptana.editor.common.scripting.commands.FilterThroughCommand", FilterThroughCommandAction.create((ITextEditor)this));
        this.fThemeableEditorFindBarExtension.createFindBarActions();
        Object action = new TextOperationAction(Messages.getBundleForConstructedKeys(), "Format.", (ITextEditor)this, 15);
        action.setActionDefinitionId("com.aptana.editor.commands.Format");
        this.setAction("com.aptana.editor.action.Format", (IAction)action);
        this.markAsStateDependentAction("com.aptana.editor.action.Format", true);
        this.markAsSelectionDependentAction("com.aptana.editor.action.Format", true);
        this.foldingActionsGroup = new FoldingActionsGroup((ITextEditor)this);
        IAction copyAction = this.getAction(ITextEditorActionConstants.COPY);
        if (copyAction != null) {
            copyAction.setText("\u590d\u5236\u9009\u533a\u6216\u5f53\u524d\u884c(&C)");
        }
        if ((cutAction = this.getAction(ITextEditorActionConstants.CUT)) != null) {
            cutAction.setText("\u526a\u5207\u9009\u533a\u6216\u5f53\u524d\u884c(&T)");
        }
        action = new ShowIndentGuideAction(Messages.getBundleForConstructedKeys(), "Editor.ShowIndentGuide.", (ITextEditor)this, CommonEditorPlugin.getDefault().getPreferenceStore());
        action.setActionDefinitionId("com.pandora.editor.ui.toggleShowIndentGuide");
        this.setAction("com.pandora.editor.ui.toggleShowIndentGuide", (IAction)action);
    }

    protected void rulerContextMenuAboutToShow(IMenuManager menu) {
        super.rulerContextMenuAboutToShow(menu);
        IAction lineNumberAction = this.getAction("Linenumbers.Toggle");
        lineNumberAction.setChecked(this.isLineNumberRulerVisible());
        MenuManager foldingMenu = new MenuManager(Messages.Folding_GroupName, "folding");
        menu.appendToGroup("rulers", (IContributionItem)foldingMenu);
        this.getFoldingActionsGroup().fillMenu((IMenuManager)foldingMenu);
    }

    synchronized ICommandElementsProvider getCommandElementsProvider() {
        if (this.fCommandElementsProvider == null) {
            this.fCommandElementsProvider = new CommandElementsProvider((ITextEditor)this, (ITextViewer)this.getSourceViewer());
        }
        return this.fCommandElementsProvider;
    }

    protected String getCursorPosition() {
        String raw = null;
        try {
            raw = super.getCursorPosition();
            StringTokenizer tokenizer = new StringTokenizer(raw, " :");
            String line = tokenizer.nextToken();
            String column = tokenizer.nextToken();
            if (column.equals("\uff1a")) {
                tokenizer = new StringTokenizer(raw, "\uff1a");
                line = tokenizer.nextToken();
                column = tokenizer.nextToken();
            }
            return MessageFormat.format(Messages.AbstractThemeableEditor_CursorPositionLabel, line.trim(), column.trim());
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)CommonEditorPlugin.getDefault(), (Throwable)e);
            return raw;
        }
    }

    protected Object getOutlineElementAt(int caret) {
        IParseNode astNode;
        block5: {
            block4: {
                try {
                    if (this.fOutlinePage != null) break block4;
                    return null;
                }
                catch (Exception e) {
                    IdeLog.logError((Plugin)CommonEditorPlugin.getDefault(), (Throwable)e);
                    return null;
                }
            }
            astNode = this.getASTNodeAt(caret, this.fOutlinePage.getCurrentAst());
            if (astNode != null) break block5;
            return null;
        }
        return this.fOutlinePage.getOutlineItem(astNode);
    }

    protected IPreferenceStore getOutlinePreferenceStore() {
        return CommonEditorPlugin.getDefault().getPreferenceStore();
    }

    public IDocument getDocument() {
        IDocumentProvider documentProvider = this.getDocumentProvider();
        if (documentProvider == null) {
            return null;
        }
        return documentProvider.getDocument((Object)this.getEditorInput());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doSetInput(IEditorInput input) throws CoreException {
        Object object = this.modificationStampLock;
        synchronized (object) {
            this.lastModificationStamp = -1L;
            this.lastAstForModificationStamp = null;
        }
        super.doSetInput(input);
    }

    public IParseRootNode getAST() {
        ParseResult pr = this.getParseResult();
        if (pr != null) {
            return pr.getRootNode();
        }
        return null;
    }

    protected ParseResult doGetAST(IDocument document) throws Exception {
        if (this.profile) {
            Profile.logEnter((String)"hbuilder.absEditor.doGetAST");
        }
        ParseResult result = ParserPoolFactory.parse((String)this.getContentType(), (String)document.get());
        if (this.profile) {
            Profile.logExit((String)"hbuilder.absEditor.doGetAST");
        }
        return result;
    }

    protected IParseNode getASTNodeAt(int offset, IParseRootNode root) {
        block3: {
            try {
                if (root != null) break block3;
                return null;
            }
            catch (Exception e) {
                IdeLog.logError((Plugin)CommonEditorPlugin.getDefault(), (Throwable)e);
                return null;
            }
        }
        return root.getNodeAtOffset(offset);
    }

    protected FoldingActionsGroup getFoldingActionsGroup() {
        return this.foldingActionsGroup;
    }

    private boolean isLinkedWithEditor() {
        return this.getOutlinePreferenceStore().getBoolean("com.aptana.editor.common.linkOutlineWithEditor");
    }

    private boolean isOutlinePageActive() {
        IWorkbenchPart part = this.getActivePart();
        return part instanceof ContentOutline && ((ContentOutline)part).getCurrentPage() == this.fOutlinePage;
    }

    private IWorkbenchPart getActivePart() {
        IWorkbenchWindow window = this.getSite().getWorkbenchWindow();
        return window.getPartService().getActivePart();
    }

    public boolean isTabsToSpacesConversionEnabled() {
        return super.isTabsToSpacesConversionEnabled();
    }

    public int getTabSize() {
        SourceViewerConfiguration config = this.getSourceViewerConfiguration();
        if (config != null) {
            return config.getTabWidth(this.getSourceViewer());
        }
        return 4;
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public boolean hasOutlinePageCreated() {
        return this.fOutlinePage != null;
    }

    public boolean isFoldingEnabled() {
        IPreferenceStore store = this.getPreferenceStore();
        return store != null && store.getBoolean("com.aptana.editor.common.enableFolding");
    }

    public boolean isMarkingOccurrences() {
        IPreferenceStore store = CommonEditorPlugin.getDefault().getPreferenceStore();
        return store != null && store.getBoolean("com.aptana.editor.common.editorMarkOccurrences");
    }

    public IFoldingComputer createFoldingComputer(IDocument document) {
        return new RubyRegexpFolder(this, document);
    }

    public boolean getWordWrapEnabled() {
        return this.getSourceViewer().getTextWidget().getWordWrap();
    }

    public void setWordWrapEnabled(boolean enabled) {
        StyledText textWidget = this.getSourceViewer().getTextWidget();
        if (textWidget.getWordWrap() != enabled) {
            textWidget.setWordWrap(enabled);
            this.fLineNumberRulerColumn.redraw();
        }
    }

    protected IVerticalRulerColumn createLineNumberRulerColumn() {
        this.fLineNumberRulerColumn = new CommonLineNumberChangeRulerColumn(this.getSharedColors());
        ((IChangeRulerColumn)this.fLineNumberRulerColumn).setHover((IAnnotationHover)this.createChangeHover());
        this.initializeLineNumberRulerColumn(this.fLineNumberRulerColumn);
        return this.fLineNumberRulerColumn;
    }

    private boolean isWordWrapEnabled() {
        return Platform.getPreferencesService().getBoolean("com.aptana.editor.common", "com.aptana.editor.common.enableWordWrap", false, null);
    }

    public void refreshOutline(final IParseRootNode ast) {
        if (!this.hasOutlinePageCreated()) {
            return;
        }
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                CommonOutlinePage page = AbstractThemeableEditor.this.getOutlinePage();
                page.refresh(ast);
                if (!AbstractThemeableEditor.this.outlineAutoExpanded) {
                    page.expandToLevel(3);
                    AbstractThemeableEditor.this.outlineAutoExpanded = true;
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ParseResult getParseResult() {
        try {
            IDocument document = this.getDocument();
            if (document == null) {
                return null;
            }
            long modificationStamp = -1L;
            if (document instanceof IDocumentExtension4) {
                Object object = this.modificationStampLock;
                synchronized (object) {
                    IDocumentExtension4 iDocumentExtension = (IDocumentExtension4)document;
                    modificationStamp = iDocumentExtension.getModificationStamp();
                    if (modificationStamp != -1L && modificationStamp == this.lastModificationStamp) {
                        if (this.lastAstForModificationStamp != null && this.lastAstForModificationStamp.get() != null) {
                            return this.lastAstForModificationStamp.get();
                        }
                        if (this.lastAstForModificationStamp == null) {
                            return null;
                        }
                    }
                }
            }
            ParseResult ast = this.doGetAST(document);
            Object object = this.modificationStampLock;
            synchronized (object) {
                if (ast != null && ast.getRootNode() != null) {
                    this.lastAstForModificationStamp = new SoftReference<ParseResult>(ast);
                }
                this.lastModificationStamp = modificationStamp;
                return ast;
            }
        }
        catch (Throwable e) {
            IdeLog.logTrace((Plugin)CommonEditorPlugin.getDefault(), (String)e.getMessage(), (Throwable)e, (String)"com.aptana.editor.common/debug/ast");
            return null;
        }
    }

    protected void editorContextMenuAboutToShow(IMenuManager menu) {
        CommandContributionItemParameter commandParm = new CommandContributionItemParameter((IServiceLocator)PlatformUI.getWorkbench().getActiveWorkbenchWindow(), "org.eclipse.ui.edit.text.contentAssist.proposals", "org.eclipse.ui.edit.text.contentAssist.proposals", null, null, null, null, "\u6fc0\u6d3b\u4ee3\u7801\u52a9\u624b(&A)", null, "", 8, null, false);
        menu.add((IContributionItem)new CommandContributionItem(commandParm));
        super.editorContextMenuAboutToShow(menu);
        IEditorInput editorInput = this.getEditorInput();
        if (!(editorInput instanceof NonExistingFileEditorInput)) {
            menu.appendToGroup("group.open", (IContributionItem)new OpenFileManagerContributionItem("com.aptana.ui.command.ShowInFileManager"));
        }
    }

    protected boolean isNavigationTarget(Annotation annotation) {
        String key;
        AnnotationPreference preference = this.getAnnotationPreferenceLookup().getAnnotationPreference(annotation);
        String string = key = preference == null ? null : preference.getIsGoToNextNavigationTargetKey();
        return key != null && (key.equals("isTaskGoToNextNavigationTarget") || key.equals("isBookmarkGoToNextNavigationTarget") || this.getPreferenceStore().getBoolean(key));
    }

    public void addLinkedModelPosition(boolean isClick) {
        ISelection selection = this.getSelectionProvider().getSelection();
        if (selection instanceof ITextSelection) {
            ITextSelection tSelection = (ITextSelection)selection;
            int caretPos = tSelection.getOffset();
            IDocument doc = this.getDocument();
            try {
                int endPos;
                int startPos;
                boolean isBackSpace = false;
                if (tSelection.getLength() > 0) {
                    startPos = caretPos;
                    endPos = tSelection.getOffset() + tSelection.getLength();
                } else {
                    startPos = this.getStartPos(caretPos, doc);
                    endPos = this.getEndtPos(caretPos, doc);
                    if (endPos != startPos) {
                        ++startPos;
                    } else if (caretPos > 0) {
                        startPos = this.getStartPos(caretPos - 1, doc);
                        endPos = this.getEndtPos(caretPos - 1, doc);
                        if (endPos != startPos) {
                            ++startPos;
                        } else {
                            startPos = endPos = caretPos;
                            isBackSpace = true;
                        }
                    } else {
                        startPos = endPos = caretPos;
                        isBackSpace = true;
                    }
                }
                this.addLinkedModelUI(doc, startPos, endPos, isBackSpace, isClick, caretPos);
            }
            catch (BadLocationException x) {
                x.printStackTrace();
            }
        }
    }

    public int getStartPos(int pos, IDocument doc) throws BadLocationException {
        while (pos >= 0) {
            char c = doc.getChar(pos);
            if (!this.isIdentifierPart(c)) break;
            --pos;
        }
        return pos;
    }

    public int getEndtPos(int pos, IDocument doc) throws BadLocationException {
        int length = doc.getLength();
        while (pos < length) {
            char c = doc.getChar(pos);
            if (!this.isIdentifierPart(c)) break;
            ++pos;
        }
        return pos;
    }

    public void addLinkedModelUI(IDocument doc, int startPos, int endPos, boolean isBackSpace, boolean isClick, int caretPos) throws BadLocationException {
        boolean isInstalled = LinkedModeModel.hasInstalledModel((IDocument)doc);
        LinkedModeModel.closeAllModels((IDocument)doc);
        LinkedPosition[] linkedPositions = this.fLinkedPositionGroup.getPositions();
        this.fLinkedPositionGroup = new LinkedPositionGroup();
        int replaceLength = endPos - startPos > -1 ? endPos - startPos : 0;
        LinkedPosition newLinkedPosition = new LinkedPosition(doc, startPos, replaceLength);
        boolean isRemoved = false;
        if (isInstalled) {
            ArrayList<LinkedPosition> linkedPositionList = new ArrayList<LinkedPosition>();
            LinkedPosition[] linkedPositionArray = linkedPositions;
            int n = linkedPositions.length;
            int n2 = 0;
            while (n2 < n) {
                LinkedPosition linkedPosition = linkedPositionArray[n2];
                if (isClick && linkedPosition.includes(caretPos)) {
                    isRemoved = true;
                } else {
                    linkedPositionList.add(linkedPosition);
                }
                ++n2;
            }
            if (isRemoved) {
                linkedPositions = new LinkedPosition[linkedPositionList.size()];
                linkedPositionList.toArray(linkedPositions);
            }
            Arrays.sort(linkedPositions, new Comparator<LinkedPosition>(){

                @Override
                public int compare(LinkedPosition o1, LinkedPosition o2) {
                    int o1Offset = o1.getOffset();
                    int o2Offset = o2.getOffset();
                    return Integer.valueOf(o2Offset).compareTo(o1Offset);
                }
            });
            if (!isRemoved && linkedPositions != null && linkedPositions.length > 0 && newLinkedPosition.getContent().equals(linkedPositions[0].getContent())) {
                for (LinkedPosition linkedPosition : linkedPositionList) {
                    this.fLinkedPositionGroup.addPosition(linkedPosition);
                }
            } else if (isRemoved) {
                for (LinkedPosition linkedPosition : linkedPositionList) {
                    this.fLinkedPositionGroup.addPosition(linkedPosition);
                }
            }
        }
        if (!isRemoved) {
            this.fLinkedPositionGroup.addPosition(newLinkedPosition);
        }
        if (this.fLinkedPositionGroup.getPositions().length < 1) {
            return;
        }
        LinkedModeModel model = new LinkedModeModel();
        model.addGroup(this.fLinkedPositionGroup);
        model.forceInstall();
        LinkedModeUI2 linkUI = new LinkedModeUI2(model, (ITextViewer)this.getISourceViewer());
        linkUI.setNeedAddExitPosition(true);
        linkUI.setCyclingMode(LinkedModeUI2.CYCLE_ALWAYS);
        linkUI.setfAnnotationPreferenceColor(this.getThemeSelectionColor());
        linkUI.enter();
    }

    protected boolean isIdentifierPart(char c) {
        return Character.isJavaIdentifierPart(c);
    }

    protected Theme getCurrentTheme() {
        return ThemePlugin.getDefault().getThemeManager().getCurrentTheme();
    }

    protected String getThemeSelectionColor() {
        RGB bg = this.getCurrentTheme().getSelectionAgainstBG();
        return StringConverter.asString((RGB)bg);
    }

    public void setBlockSelectionMode(boolean enable) {
        super.setBlockSelectionMode(enable);
        ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        try {
            Command command = commandService.getCommand("com.pandora.ui.toggleBlockSelectionMode");
            if (command != null) {
                command.getState("org.eclipse.ui.commands.toggleState").setValue((Object)this.isBlockSelectionModeEnabled());
            }
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)CommonEditorPlugin.getDefault(), (Throwable)e);
        }
    }

    protected SourceViewerDecorationSupport getSourceViewerDecorationSupport(ISourceViewer viewer) {
        return super.getSourceViewerDecorationSupport(viewer);
    }

    public boolean isOpenManualValidator() {
        return this.openManualValidator;
    }

    public void setOpenManualValidator(boolean openManualValidator) {
        this.openManualValidator = openManualValidator;
    }

    public boolean isEnableTransformChinesePunctuation(int offset, char character) {
        return false;
    }

    public char[] getChinesePunctuationCharacters() {
        String cs = this.getPreferenceStore().getString("CHINESE_PUNCTUATION_CHARACTERS");
        if (StringUtil.isNotBlank((String)cs)) {
            char[] chars = new char[cs.length()];
            int i = 0;
            while (i < cs.length()) {
                chars[i] = cs.charAt(i);
                ++i;
            }
            return chars;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized boolean doSaveTempFile(boolean isClose) {
        String fileName;
        this.isClose = isClose;
        boolean result = true;
        if (isClose) {
            CommonEditorPlugin.deleteAllTempFiles();
        }
        if (!StringUtil.isNotBlank((String)(fileName = CommonEditorPlugin.getTempFileName(this)))) return false;
        IDocument document = this.getDocument();
        String content = document.get();
        File tempDir = CommonEditorPlugin.getTempFileDir();
        File tempFile = new File(tempDir, fileName);
        BufferedInputStream inBuff = null;
        FilterOutputStream outBuff = null;
        try {
            try {
                int len;
                if (!this.isDirty()) {
                    result = false;
                }
                ByteArrayInputStream bais = new ByteArrayInputStream(content.getBytes(CommonEditorPlugin.getCharSetString(this)));
                inBuff = new BufferedInputStream(bais);
                FileOutputStream fis = new FileOutputStream(tempFile);
                outBuff = new BufferedOutputStream(fis);
                byte[] b = new byte[5120];
                while ((len = inBuff.read(b)) != -1) {
                    ((BufferedOutputStream)outBuff).write(b, 0, len);
                }
                ((BufferedOutputStream)outBuff).flush();
                bais.close();
                fis.close();
                return result;
            }
            catch (Exception e) {
                IdeLog.logError((Plugin)CommonEditorPlugin.getDefault(), (Throwable)e);
                try {
                    if (inBuff != null) {
                        inBuff.close();
                    }
                    if (outBuff == null) return result;
                    outBuff.close();
                    return result;
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
            return result;
        }
        finally {
            try {
                if (inBuff != null) {
                    inBuff.close();
                }
                if (outBuff != null) {
                    outBuff.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private class CtrlMouseWheelListener
    implements Listener {
        private CtrlMouseWheelListener() {
        }

        public void handleEvent(Event e) {
            Display display = e.display;
            switch (e.type) {
                case 37: {
                    if (!PlatformUtil.isWindows() || e.stateMask != SWT.MOD1) break;
                    if (e.count > 0) {
                        EditorUtil.executeCommand("com.pandora.ui.view.ruby.bigger");
                    } else if (e.count < 0) {
                        EditorUtil.executeCommand("com.pandora.ui.view.ruby.smaller");
                    }
                    e.doit = false;
                    e.type = 0;
                    break;
                }
                case 6: {
                    display.addFilter(37, (Listener)this);
                    break;
                }
                case 7: {
                    display.removeFilter(37, (Listener)this);
                    break;
                }
            }
        }
    }

    private class DoubleClickSelectionParisMouseListener
    implements MouseListener {
        int selectionOffset = -1;

        private DoubleClickSelectionParisMouseListener() {
        }

        public void mouseDoubleClick(MouseEvent e) {
            ISelection selection = AbstractThemeableEditor.this.getSelectionProvider().getSelection();
            if (selection instanceof TextSelection) {
                TextSelection textSelection = (TextSelection)selection;
                int offset = textSelection.getOffset();
                if (textSelection.isEmpty()) {
                    return;
                }
                try {
                    IDocument document = AbstractThemeableEditor.this.getDocument();
                    if (document == null || document.getLength() < 1) {
                        return;
                    }
                    if (offset == document.getLength()) {
                        --offset;
                    }
                    if (offset == 0) {
                        ++offset;
                    }
                    char select = document.getChar(offset);
                    char select1 = document.getChar(offset - 1);
                    if (!AbstractThemeableEditor.this.isKeyCharacter(select) && !AbstractThemeableEditor.this.isKeyCharacter(select1)) {
                        return;
                    }
                    CharacterPairMatcher characterPairMatcher = new CharacterPairMatcher(AbstractThemeableEditor.this.getPairMatchingCharacters());
                    IRegion region = characterPairMatcher.match(document, offset);
                    if (region != null && (this.selectionOffset == region.getOffset() || this.selectionOffset == region.getOffset() + 1 || this.selectionOffset == region.getOffset() + region.getLength() || this.selectionOffset == region.getOffset() + region.getLength() - 1)) {
                        AbstractThemeableEditor.this.getSourceViewer().setSelectedRange(region.getOffset() + 1, region.getLength() - 2);
                    }
                }
                catch (BadLocationException e1) {
                    e1.printStackTrace();
                }
            }
        }

        public void mouseDown(MouseEvent e) {
            TextSelection textSelection;
            ISelection selection = AbstractThemeableEditor.this.getSelectionProvider().getSelection();
            if (selection instanceof TextSelection && !(textSelection = (TextSelection)selection).isEmpty() && textSelection.getLength() == 0) {
                this.selectionOffset = textSelection.getOffset();
            }
        }

        public void mouseUp(MouseEvent e) {
        }
    }

    public static enum EDITOR_PART_PROPERTY_TYPE {
        IS_HTML_EDITOR("IS_HTML_EDITOR"),
        IS_JS_EDITOR("IS_JS_EDITOR"),
        IS_CSS_EDITOR("IS_CSS_EDITOR"),
        OTHER("OTHER");

        private final String value;

        private EDITOR_PART_PROPERTY_TYPE(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    private class LinkModelOnClickMouseListener
    implements MouseListener {
        public LinkModelOnClickMouseListener() {
            if (AbstractThemeableEditor.this.fLinkedPositionGroup == null) {
                AbstractThemeableEditor.this.fLinkedPositionGroup = new LinkedPositionGroup();
            }
        }

        public void mouseDoubleClick(MouseEvent e) {
        }

        public void mouseDown(MouseEvent e) {
            String hyperlinkKeyStr = EditorsUI.getPreferenceStore().getString("hyperlinkKeyModifier");
            int hyperlinkKey = Action.findModifier((String)hyperlinkKeyStr);
            int multiselectKey = SWT.MOD1;
            if (hyperlinkKey == 262144) {
                multiselectKey = SWT.MOD3;
            }
            if (e.stateMask == multiselectKey && e.button == 1) {
                AbstractThemeableEditor.this.addLinkedModelPosition(true);
            }
        }

        public void mouseUp(MouseEvent e) {
        }
    }

    private class PropertyChangeListener
    implements IPropertyChangeListener {
        private PropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            AbstractThemeableEditor.this.handlePreferenceStoreChanged(event);
        }
    }

    private class SelectionChangedListener
    implements ISelectionChangedListener {
        private SelectionChangedListener() {
        }

        public void install(ISelectionProvider selectionProvider) {
            if (selectionProvider == null) {
                return;
            }
            if (selectionProvider instanceof IPostSelectionProvider) {
                ((IPostSelectionProvider)selectionProvider).addPostSelectionChangedListener((ISelectionChangedListener)this);
            } else {
                selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this);
            }
        }

        public void uninstall(ISelectionProvider selectionProvider) {
            if (selectionProvider == null) {
                return;
            }
            if (selectionProvider instanceof IPostSelectionProvider) {
                ((IPostSelectionProvider)selectionProvider).removePostSelectionChangedListener((ISelectionChangedListener)this);
            } else {
                selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this);
            }
        }

        public void selectionChanged(SelectionChangedEvent event) {
            try {
                if (!AbstractThemeableEditor.this.isMarkingOccurrences() && event.getSelection() instanceof TextSelection) {
                    if (((TextSelection)event.getSelection()).getLength() > 0) {
                        AbstractThemeableEditor.this.occurrencesUpdater.updateAnnotations(event.getSelection(), false);
                    } else {
                        AbstractThemeableEditor.this.occurrencesUpdater.updateAnnotations(event.getSelection(), true);
                    }
                }
            }
            catch (Throwable e) {
                IdeLog.logError((Plugin)CommonEditorPlugin.getDefault(), (Throwable)e);
            }
            AbstractThemeableEditor.this.selectionChanged();
        }
    }

    private class SnippetDropTargetListener
    extends DropTargetAdapter {
        private SnippetDropTargetListener() {
        }

        public void drop(DropTargetEvent event) {
            if (event.data instanceof SnippetElement) {
                SnippetElement snippet = (SnippetElement)event.data;
                CommandResult commandResult = CommandExecutionUtils.executeCommand((CommandElement)snippet, InvocationType.MENU, (ITextEditor)AbstractThemeableEditor.this);
                if (commandResult == null) {
                    BundleElement bundle = snippet.getOwningBundle();
                    String bundleName = bundle == null ? "Unknown bundle" : bundle.getDisplayName();
                    IdeLog.logError((Plugin)CommonEditorPlugin.getDefault(), (String)StringUtil.format((String)"Error executing command {0} in bundle {1}. Command returned null.", (Object[])new String[]{snippet.getDisplayName(), bundleName}), (String)"com.aptana.editor.common/debug/drag_drop");
                } else {
                    CommandExecutionUtils.processCommandResult((CommandElement)snippet, commandResult, (ITextEditor)AbstractThemeableEditor.this);
                    AbstractThemeableEditor.this.setFocus();
                }
            }
        }

        public void dragOver(DropTargetEvent event) {
            if (event.data instanceof SnippetElement) {
                event.feedback |= 8;
            }
        }

        public void dragEnter(DropTargetEvent event) {
            if (event.data instanceof SnippetElement) {
                event.detail = 1;
            }
        }
    }
}

