/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.markdown.text.rules;

import com.aptana.editor.common.text.rules.CharacterMapRule;
import com.aptana.editor.common.text.rules.RegexpRule;
import com.aptana.editor.common.text.rules.WhitespaceDetector;
import com.aptana.editor.common.text.rules.WordDetector;
import com.aptana.editor.markdown.text.rules.EscapeCharacterRule;
import java.util.ArrayList;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.PatternRule;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.jface.text.rules.WordRule;

public class MarkdownScanner
extends RuleBasedScanner {
    private IToken fLastToken;
    private boolean nextMayBeLink;

    public MarkdownScanner() {
        ArrayList<Object> rules = new ArrayList<Object>();
        rules.add(new WhitespaceRule((IWhitespaceDetector)new WhitespaceDetector()));
        rules.add(new SingleLineRule("`", "`", this.getToken("markup.raw.inline.markdown"), '\\'));
        rules.add(new RegexpRule("\\[([^\\]]+?)\\](?=\\s*\\[([^\\]]+?)\\])", this.getToken("string.other.link.title.markdown")));
        rules.add(new RegexpRule("\\[([^\\]]+?)\\](?=\\s*\\(([^\\)]+?)\\))", this.getToken("string.other.link.title.markdown")));
        rules.add(new RegexpRule("\\[([^\\]]+?)\\]", this.getToken("constant.other.reference.link.markdown")));
        rules.add(new RegexpRule("(http:/)?/[^\\)\\(\\s]+", this.getToken("markup.underline.link.markdown")));
        rules.add(new PatternRule("\"", "\"", this.getToken("string.other.link.description.title.markdown"), '\\', false));
        rules.add(new PatternRule("'", "'", this.getToken("string.other.link.description.title.markdown"), '\\', false, false));
        CharacterMapRule cmRule = new CharacterMapRule();
        cmRule.add('(', this.getToken("punctuation.definition.metadata.markdown"));
        cmRule.add(')', this.getToken("punctuation.definition.metadata.markdown"));
        rules.add(cmRule);
        rules.add(new SingleLineRule("**", "**", this.getToken("markup.bold.markdown")));
        rules.add(new SingleLineRule("__", "__", this.getToken("markup.bold.markdown")));
        rules.add(new SingleLineRule("*", "*", this.getToken("markup.italic.markdown"), '\\'));
        rules.add(new SingleLineRule("_", "_", this.getToken("markup.italic.markdown"), '\\'));
        rules.add((Object)new EscapeCharacterRule(this.getToken("constant.character.escape.markdown")));
        WordRule rule = new WordRule(new IWordDetector(){

            public boolean isWordStart(char c) {
                return c == '#';
            }

            public boolean isWordPart(char c) {
                return Character.isJavaIdentifierPart(c);
            }
        }, this.getToken("markup.underline.link.markdown"));
        rules.add(rule);
        rule = new WordRule((IWordDetector)new WordDetector(), this.getToken(""));
        rules.add(rule);
        this.setRules(rules.toArray(new IRule[rules.size()]));
        this.setDefaultReturnToken(this.getToken(""));
    }

    protected IToken getToken(String tokenName) {
        return new Token((Object)tokenName);
    }

    public IToken nextToken() {
        IToken token = super.nextToken();
        try {
            if (this.tokenIs(token, "constant.other.reference.link.markdown")) {
                this.nextMayBeLink = true;
            } else if (this.nextMayBeLink) {
                if (token.equals(Token.WHITESPACE) || this.tokenIs(token, "markup.underline.link.markdown")) {
                    IToken iToken = token;
                    return iToken;
                }
                if (!this.tokenIs(token, "") || this.getTokenLength() != 1) {
                    this.nextMayBeLink = false;
                }
            }
            if (this.tokenIs(token, "punctuation.definition.metadata.markdown") && !this.lastTokenIs("string.other.link.description.title.markdown", "string.other.link.title.markdown", "markup.underline.link.markdown")) {
                token = this.getToken("");
            } else if (this.tokenIs(token, "markup.underline.link.markdown") && !this.lastTokenIs("punctuation.definition.metadata.markdown")) {
                token = this.getToken("");
            }
        }
        finally {
            this.fLastToken = token;
        }
        return token;
    }

    private boolean lastTokenIs(String ... precedingTokens) {
        return this.tokenIs(this.fLastToken, precedingTokens);
    }

    private boolean tokenIs(IToken token, String ... tokenScope) {
        if (token == null) {
            return false;
        }
        Object data = token.getData();
        if (data == null) {
            return false;
        }
        String[] stringArray = tokenScope;
        int n = tokenScope.length;
        int n2 = 0;
        while (n2 < n) {
            String precedingToken = stringArray[n2];
            if (precedingToken.equals(data)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void setRange(IDocument document, int offset, int length) {
        this.reset();
        super.setRange(document, offset, length);
    }

    protected void reset() {
        this.nextMayBeLink = false;
        this.fLastToken = null;
    }
}

