/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.scripting.model;

import com.aptana.core.projects.templates.HMobileProjectTemplate;
import com.aptana.core.projects.templates.IProjectTemplate;
import com.aptana.core.projects.templates.ProjectTemplate;
import com.aptana.core.projects.templates.TemplateAbility;
import com.aptana.core.projects.templates.TemplateType;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.SourcePrinter;
import com.aptana.scripting.model.AbstractBundleElement;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;

public class ProjectTemplateElement
extends AbstractBundleElement
implements IProjectTemplate {
    private TemplateType fType = TemplateType.UNDEFINED;
    private String fLocation;
    private String fDescription;
    private String fId;
    private String fIconPath;
    private URL fIconURL;
    private int fPriority;
    private List<String> fTags;
    private String natureID;

    public void setNatureID(String natureID) {
        this.natureID = natureID;
    }

    public ProjectTemplateElement(String path) {
        super(path);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ProjectTemplateElement)) {
            return false;
        }
        ProjectTemplateElement other = (ProjectTemplateElement)obj;
        return this.getType() == other.getType() && this.getDisplayName().equals(other.getDisplayName()) && this.getLocation().equals(other.getLocation());
    }

    public String getDescription() {
        return this.fDescription;
    }

    public File getDirectory() {
        return this.getOwningBundle().getBundleDirectory();
    }

    @Override
    public String getElementName() {
        return "project_template";
    }

    public String getLocation() {
        return this.fLocation;
    }

    public TemplateType getType() {
        return this.fType;
    }

    public TemplateAbility getAbility() {
        return TemplateAbility.TEMPLATE;
    }

    public String getTypeString() {
        return this.fType.toString();
    }

    public List<String> getTags() {
        return CollectionsUtil.getListValue(this.fTags);
    }

    public int hashCode() {
        int hash = 31 + this.getType().hashCode();
        hash = 31 * hash + this.getDisplayName().hashCode();
        hash = 31 * hash + this.getLocation().hashCode();
        return hash;
    }

    @Override
    protected void printBody(SourcePrinter printer, boolean includeBlocks) {
        ProjectTemplate.printBody((SourcePrinter)printer, (boolean)includeBlocks, (IProjectTemplate)this);
    }

    public void setDescription(String description) {
        this.fDescription = description;
    }

    public void setLocation(String location) {
        this.fLocation = location;
    }

    public void setType(String type) {
        try {
            this.fType = TemplateType.valueOf((String)type.toUpperCase());
        }
        catch (Exception exception) {
            this.fType = TemplateType.UNDEFINED;
        }
    }

    public void setType(TemplateType type) {
        this.fType = type;
    }

    public void setTags(List<String> tags) {
        this.fTags = CollectionsUtil.isEmpty(tags) ? null : new ArrayList<String>(tags);
    }

    public URL getIconURL() {
        if (this.fIconURL != null) {
            return this.fIconURL;
        }
        this.fIconURL = this.getURLFromPath(this.fIconPath);
        return this.fIconURL;
    }

    public void setIcon(String iconPath) {
        this.fIconPath = iconPath;
        this.fIconURL = null;
    }

    public String getIcon() {
        return this.fIconPath;
    }

    public int getPriority() {
        return this.fPriority;
    }

    public void setPriority(int priority) {
        this.fPriority = priority;
    }

    public boolean isReplacingParameters() {
        Object replace = this.get("replace_parameters");
        if (replace == null) {
            return false;
        }
        return Boolean.parseBoolean(replace.toString());
    }

    public void setId(String id) {
        this.fId = id;
    }

    public String getId() {
        return this.fId;
    }

    @Override
    public void setDisplayName(String displayName) {
        super.setDisplayName(displayName);
        if ("".equals(this.getId()) || this.getId() == null) {
            this.setId(displayName);
        }
    }

    public IStatus apply(IProject project, boolean promptForOverwrite) {
        return this.createProjectTemplate().apply(project, promptForOverwrite);
    }

    protected ProjectTemplate createProjectTemplate() {
        TemplateType type = this.getType();
        if (type == TemplateType.APP) {
            return new HMobileProjectTemplate(new File(this.getDirectory(), this.getLocation()).getAbsolutePath(), this.getType(), this.getDisplayName(), this.isReplacingParameters(), this.getDescription(), this.getIconURL(), this.getId(), this.getPriority(), this.getTags(), this.getNatureID());
        }
        return new ProjectTemplate(new File(this.getDirectory(), this.getLocation()).getAbsolutePath(), this.getType(), this.getDisplayName(), this.isReplacingParameters(), this.getDescription(), this.getIconURL(), this.getId(), this.getPriority(), this.getTags(), this.getNatureID());
    }

    public String getNatureID() {
        return this.natureID;
    }
}

