/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.scripting.model;

import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.SourcePrinter;
import com.aptana.core.util.StringUtil;
import com.aptana.scope.ScopeSelector;
import com.aptana.scripting.model.AbstractBundleElement;
import com.aptana.scripting.model.AbstractElement;
import com.aptana.scripting.model.BundleElement;
import com.aptana.scripting.model.BundleEntry;
import com.aptana.scripting.model.BundleManager;
import com.aptana.scripting.model.CommandElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class MenuElement
extends AbstractBundleElement {
    private static final String SEPARATOR_TEXT = "-";
    private MenuElement _parent;
    private List<MenuElement> _children;
    private String _commandName;
    private String id = null;
    private String locationURI = null;
    private Object childrenLock = new Object();

    public MenuElement() {
        this(null);
    }

    public MenuElement(String path) {
        super(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMenu(MenuElement menu) {
        if (menu != null) {
            Object object = this.childrenLock;
            synchronized (object) {
                if (this._children == null) {
                    this._children = new ArrayList<MenuElement>(1);
                }
                menu._parent = this;
                this._children.add(menu);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized List<MenuElement> getChildren() {
        List<MenuElement> result;
        Object object = this.childrenLock;
        synchronized (object) {
            result = !CollectionsUtil.isEmpty(this._children) ? new ArrayList<MenuElement>(this._children) : Collections.emptyList();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setChildren(List<MenuElement> children) {
        if (children != null) {
            Object object = this.childrenLock;
            synchronized (object) {
                this._children = new ArrayList<MenuElement>(children);
                for (MenuElement child : children) {
                    child._parent = this;
                }
            }
        }
    }

    public CommandElement getCommand() {
        BundleEntry be;
        BundleElement owningBundle = this.getOwningBundle();
        CommandElement result = null;
        if (this.isLeafMenu() && owningBundle != null && (be = BundleManager.getInstance().getBundleEntry(owningBundle.getDisplayName())) != null) {
            for (CommandElement cmd : be.getCommands()) {
                if (!cmd.getDisplayName().equals(this._commandName)) continue;
                result = cmd;
                break;
            }
        }
        return result;
    }

    public String getCommandName() {
        return this._commandName;
    }

    @Override
    protected String getElementName() {
        return "menu";
    }

    @Override
    public BundleElement getOwningBundle() {
        MenuElement currentMenu = this;
        BundleElement result = null;
        while (currentMenu != null) {
            BundleElement bundle = currentMenu.owningBundle;
            if (bundle != null) {
                result = bundle;
                break;
            }
            currentMenu = currentMenu._parent;
        }
        return result;
    }

    public MenuElement getParent() {
        return this._parent;
    }

    @Override
    public ScopeSelector getScopeSelector() {
        MenuElement currentMenu = this;
        ScopeSelector result = null;
        while (currentMenu != null) {
            String scope = currentMenu.getScope();
            if (scope != null && scope.length() > 0) {
                result = new ScopeSelector(scope);
                break;
            }
            currentMenu = currentMenu.getParent();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasChildren() {
        Object object = this.childrenLock;
        synchronized (object) {
            return !CollectionsUtil.isEmpty(this._children);
        }
    }

    public boolean isHierarchicalMenu() {
        return !this.isSeparator() && this.hasChildren();
    }

    public boolean isLeafMenu() {
        return !this.isSeparator() && !this.hasChildren();
    }

    @Override
    public void setDisplayName(String displayName) {
        if (StringUtil.startsWith((String)displayName, (String)SEPARATOR_TEXT)) {
            displayName = SEPARATOR_TEXT;
        }
        super.setDisplayName(displayName);
    }

    public boolean isSeparator() {
        String displayName = this.getDisplayName();
        return StringUtil.startsWith((String)displayName, (String)SEPARATOR_TEXT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void printBody(SourcePrinter printer, boolean includeBlocks) {
        printer.printWithIndent("path: ").println(this.getPath());
        if (this.getScopeSelector() != null) {
            printer.printWithIndent("scope: ").println(this.getScopeSelector().toString());
        }
        printer.printWithIndent("command: ").println(this.getCommandName());
        Object object = this.childrenLock;
        synchronized (object) {
            if (this.hasChildren()) {
                for (MenuElement menu : this._children) {
                    menu.toSource(printer, includeBlocks);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChildren() {
        Object object = this.childrenLock;
        synchronized (object) {
            for (MenuElement child : this.getChildren()) {
                this.removeMenu(child);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMenu(MenuElement menu) {
        Object object = this.childrenLock;
        synchronized (object) {
            if (this._children != null && this._children.remove(menu)) {
                AbstractElement.unregisterElement(menu);
                menu.removeChildren();
            }
        }
    }

    public void setCommandName(String name) {
        if (name != null && name.startsWith(SEPARATOR_TEXT)) {
            name = SEPARATOR_TEXT;
        }
        this._commandName = name;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getLocationURI() {
        return this.locationURI;
    }

    public void setLocationURI(String locationURI) {
        this.locationURI = locationURI;
    }
}

