/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.scripting.model;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.EclipseUtil;
import com.aptana.core.util.IConfigurationElementProcessor;
import com.aptana.scripting.ScriptingActivator;
import com.aptana.scripting.model.CommandElement;
import com.aptana.scripting.model.ContextContributor;
import com.aptana.scripting.model.Messages;
import com.aptana.scripting.model.OutputType;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Plugin;

public class CommandContext {
    public static final String INIT_SCRIPT = "init_script";
    public static final String INPUT_TYPE = "input_type";
    public static final String INVOKED_VIA = "invoked_via";
    private static final String CONTEXT_CONTRIBUTOR_ID = "contextContributors";
    private static final String TAG_CONTRIBUTOR = "contributor";
    private static final String ATTR_CLASS = "class";
    private static ContextContributor[] contextContributors;
    private Map<String, Object> _map = new HashMap<String, Object>();
    private InputStream _inputStream;
    private OutputStream _outputStream;
    private OutputStream _errorStream;
    private OutputStream _consoleStream;
    private OutputType _outputType;
    private boolean _forcedExit;

    public static ContextContributor[] getContextContributors() {
        if (contextContributors == null) {
            final ArrayList contributors = new ArrayList();
            EclipseUtil.processConfigurationElements((String)"com.aptana.scripting", (String)CONTEXT_CONTRIBUTOR_ID, (IConfigurationElementProcessor)new IConfigurationElementProcessor(){

                public void processElement(IConfigurationElement element) {
                    try {
                        ContextContributor contributor = (ContextContributor)element.createExecutableExtension(CommandContext.ATTR_CLASS);
                        contributors.add(contributor);
                    }
                    catch (CoreException e) {
                        String message = MessageFormat.format(Messages.CommandElement_Error_Creating_Contributor, e.getMessage());
                        IdeLog.logError((Plugin)ScriptingActivator.getDefault(), (String)message, (Throwable)e);
                    }
                }

                public Set<String> getSupportElementNames() {
                    return CollectionsUtil.newSet((Object[])new String[]{CommandContext.TAG_CONTRIBUTOR});
                }
            });
            contextContributors = contributors.toArray(new ContextContributor[contributors.size()]);
        }
        return contextContributors;
    }

    CommandContext(CommandElement command) {
        ContextContributor[] contextContributorArray = CommandContext.getContextContributors();
        int n = contextContributorArray.length;
        int n2 = 0;
        while (n2 < n) {
            ContextContributor contributor = contextContributorArray[n2];
            contributor.modifyContext(command, this);
            ++n2;
        }
    }

    public Object get(String key) {
        return this._map.get(key);
    }

    public OutputStream getConsoleStream() {
        return this._consoleStream;
    }

    public OutputStream getErrorStream() {
        return this._errorStream;
    }

    public InputStream getInputStream() {
        return this._inputStream;
    }

    public OutputStream getOutputStream() {
        return this._outputStream;
    }

    public Map<String, Object> getMap() {
        return this._map;
    }

    public OutputType getOutputType() {
        return this._outputType;
    }

    public boolean isForcedExit() {
        return this._forcedExit;
    }

    public void put(String key, Object value) {
        this._map.put(key, value);
    }

    public void putAll(Map<String, Object> entries) {
        this._map.putAll(entries);
    }

    public void setConsoleStream(OutputStream stream) {
        this._consoleStream = stream;
    }

    public void setErrorStream(OutputStream stream) {
        this._errorStream = stream;
    }

    public void setForcedExit(boolean value) {
        this._forcedExit = value;
    }

    public void setInputStream(InputStream inputStream) {
        this._inputStream = inputStream;
    }

    public void setOutputStream(OutputStream stream) {
        this._outputStream = stream;
    }

    public void setOutputType(OutputType type) {
        this._outputType = type;
    }

    public void setOutputType(String output) {
        this._outputType = OutputType.get(output);
    }
}

