/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.scripting.model;

import com.aptana.scope.ScopeSelector;
import com.aptana.scripting.ScriptUtils;
import com.aptana.scripting.model.AbstractCommandRunner;
import com.aptana.scripting.model.BundleManager;
import com.aptana.scripting.model.CommandContext;
import com.aptana.scripting.model.CommandElement;
import com.aptana.scripting.model.CommandResult;
import com.aptana.scripting.model.EnvironmentElement;
import com.aptana.scripting.model.Messages;
import com.aptana.scripting.model.filters.ScopeFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyGlobal;
import org.jruby.RubyHash;
import org.jruby.RubyIO;
import org.jruby.RubyProc;
import org.jruby.RubySystemExit;
import org.jruby.exceptions.RaiseException;
import org.jruby.javasupport.JavaEmbedUtils;
import org.jruby.runtime.GlobalVariable;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class CommandBlockRunner
extends AbstractCommandRunner {
    private static final String STDIN_GLOBAL = "$stdin";
    private static final String STDIN_CONSTANT = "STDIN";
    private static final String DEFERR_GLOBAL = "$deferr";
    private static final String STDERR_GLOBAL = "$stderr";
    private static final String DEFOUT_GLOBAL = "$defout";
    private static final String STDOUT_GLOBAL2 = "$>";
    private static final String STDOUT_CONSTANT = "STDOUT";
    private static final String STDOUT_GLOBAL = "$stdout";
    private static final String STDERR_CONSTANT = "STDERR";
    private static final String CONSOLE_CONSTANT = "CONSOLE";
    private static final String CONSOLE_VARIABLE = "$console";
    private static final String CONTEXT_RUBY_CLASS = "Context";
    private static final String OUTPUT_PROPERTY = "output";
    private static final String ENV_PROPERTY = "ENV";
    private RubyHash _originalEnvironment;
    private IRubyObject _oldReader;
    private IRubyObject _oldWriter;
    private IRubyObject _oldErrorWriter;
    private IRubyObject _oldConsole;

    public CommandBlockRunner(CommandElement command, CommandContext context, List<String> loadPaths) {
        super("Execute JRuby Block", command, context, loadPaths);
    }

    protected void afterExecute() {
        Ruby runtime = this.getRuntime();
        this.registerLibraries(runtime, this.getCommand().getPath());
        this.unapplyLoadPaths(runtime);
        this.unapplyStreams();
        this.unapplyEnvironment();
    }

    protected void applyEnvironment() {
        Ruby runtime = this.getRuntime();
        IRubyObject env = runtime.getObject().getConstant(ENV_PROPERTY);
        if (env != null && env instanceof RubyHash) {
            RubyHash hash = (RubyHash)env;
            this._originalEnvironment = (RubyHash)hash.dup();
            hash.putAll(this.getContributedEnvironment());
            String tmCurrentScope = (String)hash.get((Object)"TM_CURRENT_SCOPE");
            if ("true".equals(this.getContext().get("init_script"))) {
                tmCurrentScope = "meta.project.com.aptana.projects.webnature text.html.basic source.js source.css";
            }
            ScopeFilter filter = new ScopeFilter(tmCurrentScope);
            List<EnvironmentElement> envs = BundleManager.getInstance().getEnvs(filter);
            ScopeSelector.sort(envs);
            for (EnvironmentElement e : envs) {
                RubyProc invoke = e.getInvokeBlock();
                if (invoke == null) continue;
                invoke.call(runtime.getCurrentContext(), new IRubyObject[]{hash});
            }
        }
    }

    protected void applyStreams() {
        Ruby runtime = this.getRuntime();
        CommandContext context = this.getContext();
        boolean isVerbose = runtime.isVerbose();
        runtime.setVerbose(runtime.getNil());
        this._oldReader = this.setReader(context.getInputStream());
        this._oldWriter = this.setWriter(context.getOutputStream());
        this._oldErrorWriter = this.setErrorWriter(context.getErrorStream());
        this._oldConsole = this.setConsole(context.getConsoleStream());
        runtime.setVerbose((IRubyObject)(isVerbose ? runtime.getTrue() : runtime.getFalse()));
    }

    protected void beforeExecute() {
        Ruby runtime = this.getRuntime();
        this.applyLoadPaths(runtime);
        this.applyStreams();
        this.applyEnvironment();
        this.getContext().setOutputType(this.getCommand().getOutputType());
    }

    protected void closeStreams() {
        CommandContext context = this.getContext();
        InputStream stdin = context.getInputStream();
        OutputStream stdout = context.getOutputStream();
        if (stdin != null) {
            try {
                stdin.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (stdout != null) {
            try {
                stdout.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    protected String executeBlock() {
        CommandElement command = this.getCommand();
        CommandContext context = this.getContext();
        Ruby runtime = this.getRuntime();
        ThreadContext threadContext = runtime.getCurrentContext();
        IRubyObject rubyContext = ScriptUtils.instantiateClass(runtime, "Ruble", CONTEXT_RUBY_CLASS, JavaEmbedUtils.javaToRuby((Ruby)runtime, (Object)context));
        String resultText = null;
        this.setExecutedSuccessfully(true);
        try {
            IRubyObject result = this.getCommand().getInvokeBlock().call(threadContext, new IRubyObject[]{rubyContext});
            if (result != null && !result.isNil()) {
                if (result instanceof RubyArray || result instanceof RubyHash) {
                    result = result.inspect();
                }
                resultText = new String(result.asString().getByteList().bytes(), "UTF-8");
            }
        }
        catch (RaiseException e) {
            if (e.getException() instanceof RubySystemExit) {
                RubySystemExit exit = (RubySystemExit)e.getException();
                if (context.isForcedExit()) {
                    resultText = context.get(OUTPUT_PROPERTY).toString();
                } else if (!exit.success_p().isTrue()) {
                    this.executionFailed(command, (Exception)((Object)e));
                }
            } else {
                this.executionFailed(command, (Exception)((Object)e));
            }
        }
        catch (Exception e) {
            this.executionFailed(command, e);
        }
        return resultText;
    }

    private void executionFailed(CommandElement command, Exception e) {
        String message = MessageFormat.format(Messages.CommandElement_Error_Processing_Command_Block, command.getDisplayName(), command.getPath(), e.getMessage());
        ScriptUtils.logErrorWithStackTrace(message, e);
        this.setExecutedSuccessfully(false);
    }

    protected Ruby getRuntime() {
        return this.getCommand().getRuntime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IStatus run(IProgressMonitor monitor) {
        CommandContext context = this.getContext();
        String resultText = null;
        Ruby ruby = this.getRuntime();
        synchronized (ruby) {
            this.beforeExecute();
            resultText = this.executeBlock();
            this.afterExecute();
        }
        CommandResult result = new CommandResult(this.getCommand(), context);
        result.setExecutedSuccessfully(this.getExecutedSuccessfully());
        if (resultText != null) {
            result.setOutputString(resultText);
        } else if (context.getOutputStream() != null) {
            result.setOutputStream(context.getOutputStream());
        } else {
            result.setOutputString("");
        }
        this.setCommandResult(result);
        return Status.OK_STATUS;
    }

    protected void setConsole(IRubyObject io) {
        Ruby runtime = this.getRuntime();
        runtime.getGlobalVariables().set(CONSOLE_VARIABLE, io);
        runtime.getObject().setConstant(CONSOLE_CONSTANT, io);
    }

    protected IRubyObject setConsole(OutputStream ostream) {
        Ruby runtime = this.getRuntime();
        RubyClass object = runtime.getObject();
        IRubyObject oldValue = null;
        if (object.hasConstant(CONSOLE_CONSTANT)) {
            oldValue = object.getConstant(CONSOLE_CONSTANT);
        }
        if (ostream != null) {
            RubyIO io = new RubyIO(runtime, ostream);
            io.getOpenFile().getMainStream().setSync(true);
            this.setConsole((IRubyObject)io);
        }
        return oldValue;
    }

    protected void setErrorWriter(IRubyObject io) {
        Ruby runtime = this.getRuntime();
        runtime.defineVariable((GlobalVariable)new RubyGlobal.OutputGlobalVariable(runtime, STDERR_GLOBAL, io));
        runtime.defineGlobalConstant(STDERR_CONSTANT, io);
        runtime.getGlobalVariables().alias(DEFERR_GLOBAL, STDERR_GLOBAL);
    }

    protected IRubyObject setErrorWriter(OutputStream ostream) {
        Ruby runtime = this.getRuntime();
        IRubyObject oldValue = runtime.getObject().getConstant(STDERR_CONSTANT);
        if (ostream != null) {
            PrintStream pstream = new PrintStream(ostream);
            RubyIO io = new RubyIO(runtime, (OutputStream)pstream);
            io.getOpenFile().getMainStream().setSync(true);
            this.setErrorWriter((IRubyObject)io);
        }
        return oldValue;
    }

    protected IRubyObject setReader(InputStream istream) {
        Ruby runtime = this.getRuntime();
        IRubyObject oldValue = runtime.getObject().getConstant(STDIN_CONSTANT);
        if (istream != null) {
            this.setReader((IRubyObject)new RubyIO(runtime, istream));
        }
        return oldValue;
    }

    protected void setReader(IRubyObject io) {
        Ruby runtime = this.getRuntime();
        runtime.defineVariable((GlobalVariable)new RubyGlobal.InputGlobalVariable(runtime, STDIN_GLOBAL, io));
        runtime.defineGlobalConstant(STDIN_CONSTANT, io);
    }

    protected void setWriter(IRubyObject io) {
        Ruby runtime = this.getRuntime();
        runtime.defineVariable((GlobalVariable)new RubyGlobal.OutputGlobalVariable(runtime, STDOUT_GLOBAL, io));
        runtime.defineGlobalConstant(STDOUT_CONSTANT, io);
        runtime.getGlobalVariables().alias(STDOUT_GLOBAL2, STDOUT_GLOBAL);
        runtime.getGlobalVariables().alias(DEFOUT_GLOBAL, STDOUT_GLOBAL);
    }

    protected IRubyObject setWriter(OutputStream ostream) {
        Ruby runtime = this.getRuntime();
        IRubyObject oldValue = runtime.getObject().getConstant(STDOUT_CONSTANT);
        if (ostream != null) {
            PrintStream pstream = new PrintStream(ostream);
            RubyIO io = new RubyIO(runtime, (OutputStream)pstream);
            io.getOpenFile().getMainStream().setSync(true);
            this.setWriter((IRubyObject)io);
        }
        return oldValue;
    }

    protected void unapplyEnvironment() {
        Ruby runtime = this.getRuntime();
        IRubyObject env = runtime.getObject().getConstant(ENV_PROPERTY);
        if (env != null && env instanceof RubyHash) {
            RubyHash hash = (RubyHash)env;
            hash.replace(runtime.getCurrentContext(), (IRubyObject)this._originalEnvironment);
            this._originalEnvironment = null;
        }
    }

    protected void unapplyStreams() {
        Ruby runtime = this.getRuntime();
        boolean isVerbose = runtime.isVerbose();
        runtime.setVerbose(runtime.getNil());
        this.setReader(this._oldReader);
        this.setWriter(this._oldWriter);
        this.setErrorWriter(this._oldErrorWriter);
        if (this._oldConsole == null) {
            runtime.getObject().remove_const(runtime.getCurrentContext(), (IRubyObject)runtime.newString(CONSOLE_CONSTANT));
        } else {
            this.setConsole(this._oldConsole);
        }
        runtime.setVerbose((IRubyObject)(isVerbose ? runtime.getTrue() : runtime.getFalse()));
    }
}

