/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.scripting.listeners;

import com.aptana.core.logging.IdeLog;
import com.aptana.filewatcher.FileWatcher;
import com.aptana.scripting.ScriptingActivator;
import com.aptana.scripting.model.AbstractElement;
import com.aptana.scripting.model.BundleManager;
import com.aptana.scripting.model.CommandContext;
import com.aptana.scripting.model.CommandElement;
import com.aptana.scripting.model.ElementVisibilityListener;
import com.aptana.scripting.model.TriggerType;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.contentobjects.jnotify.JNotifyException;
import net.contentobjects.jnotify.JNotifyListener;
import org.eclipse.core.runtime.Plugin;

public class FileWatcherRegistrant
implements ElementVisibilityListener,
JNotifyListener {
    private static FileWatcherRegistrant INSTANCE;
    private Map<File, Set<CommandElement>> _fileToCommandMap = new HashMap<File, Set<CommandElement>>();
    private Map<CommandElement, Set<File>> _commandToFilesMap = new HashMap<CommandElement, Set<File>>();
    private Map<File, Integer> _fileWatcherId = new HashMap<File, Integer>();
    private Map<Integer, File> _watcherIdFile = new HashMap<Integer, File>();

    public static synchronized FileWatcherRegistrant getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new FileWatcherRegistrant();
            INSTANCE.setup();
        }
        return INSTANCE;
    }

    public static synchronized void shutdown() {
        if (INSTANCE != null) {
            INSTANCE.tearDown();
            INSTANCE = null;
        }
    }

    private FileWatcherRegistrant() {
    }

    private void addCommand(File file, CommandElement element) {
        Set<File> files = this._commandToFilesMap.get(element);
        if (files == null) {
            files = new HashSet<File>();
            this._commandToFilesMap.put(element, files);
        }
        files.add(file);
    }

    private void addFile(File file, CommandElement element) {
        Set<CommandElement> commands = this._fileToCommandMap.get(file);
        if (commands == null) {
            commands = new HashSet<CommandElement>();
            this._fileToCommandMap.put(file, commands);
        }
        commands.add(element);
    }

    protected void addWatcher(CommandElement command) {
        String[] filenames = command.getTriggerTypeValues(TriggerType.FILE_WATCHER);
        if (filenames != null && filenames.length > 0) {
            HashSet<File> beforeFiles = new HashSet<File>(this._fileToCommandMap.keySet());
            String[] stringArray = filenames;
            int n = filenames.length;
            int n2 = 0;
            while (n2 < n) {
                String filename = stringArray[n2];
                File file = new File(filename).getAbsoluteFile();
                this.addFile(file, command);
                this.addCommand(file, command);
                ++n2;
            }
            HashSet<File> afterFiles = new HashSet<File>(this._fileToCommandMap.keySet());
            afterFiles.removeAll(beforeFiles);
            for (File file : afterFiles) {
                try {
                    int id = FileWatcher.addWatch((String)file.getAbsolutePath(), (int)15, (boolean)true, (JNotifyListener)this);
                    this._fileWatcherId.put(file, id);
                    this._watcherIdFile.put(id, file);
                }
                catch (JNotifyException e) {
                    IdeLog.logError((Plugin)ScriptingActivator.getDefault(), (String)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    @Override
    public void elementBecameHidden(AbstractElement element) {
        if (element instanceof CommandElement) {
            this.removeWatcher((CommandElement)element);
        }
    }

    @Override
    public void elementBecameVisible(AbstractElement element) {
        if (element instanceof CommandElement) {
            this.addWatcher((CommandElement)element);
        }
    }

    private void execute(int wd, String type, String ... properties) {
        HashMap<String, String> propertyMap = new HashMap<String, String>();
        propertyMap.put("type", type);
        int length = properties.length & 0xFFFFFFFE;
        int i = 0;
        while (i < length) {
            String name = properties[i];
            String value = properties[i + 1];
            propertyMap.put(name, value);
            i += 2;
        }
        Set<CommandElement> commands = this.getCommandsByWatchId(wd);
        for (CommandElement command : commands) {
            CommandContext context = command.createCommandContext();
            context.put(TriggerType.FILE_WATCHER.getName(), propertyMap);
            command.execute(context);
        }
    }

    public void fileCreated(int wd, String rootPath, String name) {
        this.execute(wd, "created", "rootPath", rootPath, "name", name);
    }

    public void fileDeleted(int wd, String rootPath, String name) {
        this.execute(wd, "deleted", "rootPath", rootPath, "name", name);
    }

    public void fileModified(int wd, String rootPath, String name) {
        this.execute(wd, "modified", "rootPath", rootPath, "name", name);
    }

    public void fileRenamed(int wd, String rootPath, String oldName, String newName) {
        this.execute(wd, "deleted", "rootPath", rootPath, "oldName", oldName, "newName", newName);
    }

    private Set<CommandElement> getCommandsByWatchId(int wd) {
        File file = this._watcherIdFile.get(wd);
        Set<CommandElement> result = file != null ? this._fileToCommandMap.get(file) : Collections.emptySet();
        return result;
    }

    protected void removeWatcher(CommandElement command) {
        if (this._commandToFilesMap.containsKey(command)) {
            for (File file : this._commandToFilesMap.get(command)) {
                if (!this._fileToCommandMap.containsKey(file)) continue;
                Set<CommandElement> commands = this._fileToCommandMap.get(file);
                commands.remove(command);
                if (commands.size() != 0) continue;
                if (this._fileWatcherId.containsKey(file)) {
                    int id = this._fileWatcherId.remove(file);
                    this._watcherIdFile.remove(id);
                    try {
                        FileWatcher.removeWatch((int)id);
                    }
                    catch (JNotifyException e) {
                        IdeLog.logError((Plugin)ScriptingActivator.getDefault(), (String)e.getMessage(), (Throwable)e);
                    }
                }
                this._fileToCommandMap.remove(file);
            }
            this._commandToFilesMap.remove(command);
        }
    }

    private void setup() {
        BundleManager manager = BundleManager.getInstance();
        manager.addElementVisibilityListener(this);
    }

    private void tearDown() {
        BundleManager manager = BundleManager.getInstance();
        manager.removeElementVisibilityListener(this);
        for (int id : this._watcherIdFile.keySet()) {
            try {
                FileWatcher.removeWatch((int)id);
            }
            catch (JNotifyException e) {
                IdeLog.logError((Plugin)ScriptingActivator.getDefault(), (String)e.getMessage(), (Throwable)e);
            }
        }
        this._commandToFilesMap.clear();
        this._fileToCommandMap.clear();
        this._fileWatcherId.clear();
        this._watcherIdFile.clear();
    }
}

