/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.scripting;

import com.aptana.core.logging.IdeLog;
import com.aptana.scripting.Messages;
import com.aptana.scripting.listeners.FileWatcherRegistrant;
import com.aptana.scripting.model.BundleManager;
import com.aptana.scripting.model.BundleMonitor;
import com.aptana.scripting.model.RunType;
import net.contentobjects.jnotify.JNotifyException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.jruby.RubyInstanceConfig;
import org.osgi.framework.BundleContext;

public class ScriptingActivator
extends Plugin {
    public static final String PLUGIN_ID = "com.aptana.scripting";
    public static final String TEMPLATE_PLUGIN_ID = "com.pandora.templates.ui";
    public static final String TEMPLATE_PATH = "templates/Rubles";
    private static ScriptingActivator plugin;
    public static final String EDITOR_CONTEXT_ID = "com.aptana.editor.context";

    static {
        RubyInstanceConfig.nativeEnabled = false;
    }

    public static ScriptingActivator getDefault() {
        return plugin;
    }

    public static RunType getDefaultRunType() {
        return RunType.CURRENT_THREAD;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        try {
            this.loadRubles();
        }
        catch (Throwable e) {
            IdeLog.logError((Plugin)ScriptingActivator.getDefault(), (Throwable)e);
        }
    }

    protected void loadRubles() {
        Job startupJob = new Job("Start Ruble bundle manager"){

            protected IStatus run(IProgressMonitor monitor) {
                BundleManager manager = BundleManager.getInstance();
                FileWatcherRegistrant.getInstance();
                manager.loadBundles();
                try {
                    BundleMonitor.getInstance().beginMonitoring();
                }
                catch (JNotifyException e) {
                    IdeLog.logError((Plugin)ScriptingActivator.getDefault(), (String)Messages.EarlyStartup_Error_Initializing_File_Monitoring, (Throwable)e);
                }
                return Status.OK_STATUS;
            }
        };
        startupJob.setSystem(true);
        startupJob.setUser(false);
        startupJob.schedule();
    }

    public void stop(BundleContext context) throws Exception {
        try {
            try {
                BundleMonitor.getInstance().endMonitoring();
                FileWatcherRegistrant.shutdown();
            }
            catch (Exception exception) {
                plugin = null;
                super.stop(context);
            }
        }
        finally {
            plugin = null;
            super.stop(context);
        }
    }
}

