/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.commandline.launcher.application;

import com.aptana.commandline.launcher.CommandlineLauncherPlugin;
import com.aptana.commandline.launcher.application.Messages;
import com.aptana.commandline.launcher.server.LauncherServer;
import com.aptana.commandline.launcher.server.port.PortManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.Socket;
import java.util.LinkedList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.osgi.internal.profile.Profile;
import org.eclipse.osgi.util.NLS;

public class LauncherApplication
implements IApplication {
    private IApplication productApplication;

    public Object start(IApplicationContext context) throws Exception {
        block18: {
            boolean profile;
            boolean bl = profile = Profile.STARTUP;
            if (profile) {
                Profile.logTime((String)"EclipseStarter.run(Object)()", (String)"hbuilder.LauncherApplication.start");
            }
            System.setProperty("LauncherApplication.start", String.valueOf(System.currentTimeMillis()));
            int port = -1;
            try {
                String[] arguments;
                Object args;
                String productApplicationId = "com.aptana.rcp.application";
                this.productApplication = this.getApplication(productApplicationId);
                port = PortManager.getRunningInstancePort();
                System.setProperty("PortManager.getRunningInstancePort().end", String.valueOf(System.currentTimeMillis()));
                if (profile) {
                    Profile.logTime((String)"EclipseStarter.run(Object)()", (String)"PortManager.getRunningInstancePort().end");
                }
                if ((args = context.getArguments().get("application.args")) instanceof String[]) {
                    String[] stringArray = arguments = (String[])args;
                    int n = arguments.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String s = stringArray[n2];
                        if (String.valueOf(s).indexOf("-login") >= 0) {
                            LauncherServer.startServer();
                            System.setProperty("LauncherServer.startServer().end", String.valueOf(System.currentTimeMillis()));
                            if (profile) {
                                Profile.logTime((String)"EclipseStarter.run(Object)()", (String)"LauncherServer.startServer().end");
                            }
                            return this.productApplication.start(context);
                        }
                        ++n2;
                    }
                }
                if (port < 0) {
                    if (this.productApplication != null) {
                        try {
                            LauncherServer.startServer();
                            System.setProperty("LauncherServer.startServer().end", String.valueOf(System.currentTimeMillis()));
                            if (profile) {
                                Profile.logTime((String)"EclipseStarter.run(Object)()", (String)"LauncherServer.startServer().end");
                            }
                        }
                        catch (Exception e) {
                            CommandlineLauncherPlugin.getDefault().logError(e);
                        }
                        return this.productApplication.start(context);
                    }
                    IllegalStateException e = new IllegalStateException(NLS.bind((String)Messages.LauncherApplication_ApplicationNotFound, (Object)productApplicationId));
                    CommandlineLauncherPlugin.getDefault().logError(e);
                    break block18;
                }
                args = context.getArguments().get("application.args");
                if (args instanceof String[] && (arguments = (String[])args).length > 0) {
                    int result = LauncherApplication.sendArguments(port, arguments);
                    if (result == 0) {
                        IllegalStateException e = new IllegalStateException(Messages.LauncherApplication_CouldNotSendCommandLineArguments);
                        CommandlineLauncherPlugin.getDefault().logError(e);
                    } else if (result == 2) {
                        if (this.productApplication != null) {
                            return this.productApplication.start(context);
                        }
                        IllegalStateException e = new IllegalStateException(NLS.bind((String)Messages.LauncherApplication_ApplicationNotFound, (Object)productApplicationId));
                        CommandlineLauncherPlugin.getDefault().logError(e);
                    }
                }
            }
            catch (Exception e) {
                CommandlineLauncherPlugin.getDefault().logError(e);
            }
        }
        return EXIT_OK;
    }

    public void stop() {
        if (this.productApplication != null) {
            this.productApplication.stop();
        }
    }

    private IApplication getApplication(String applicationId) throws CoreException {
        Object runnable;
        IConfigurationElement[] runs;
        IExtension extension = Platform.getExtensionRegistry().getExtension("org.eclipse.core.runtime", "applications", applicationId);
        IConfigurationElement[] elements = extension.getConfigurationElements();
        if (elements.length > 0 && (runs = elements[0].getChildren("run")).length > 0 && (runnable = runs[0].createExecutableExtension("class")) instanceof IApplication) {
            return (IApplication)runnable;
        }
        return null;
    }

    public static int sendArguments(int port, String[] arguments) {
        LinkedList<String> filesList = new LinkedList<String>();
        String[] stringArray = arguments;
        int n = arguments.length;
        int n2 = 0;
        while (n2 < n) {
            String argument = stringArray[n2];
            File file = new File(argument);
            if (file.exists()) {
                filesList.add(file.getAbsolutePath());
            }
            ++n2;
        }
        arguments = filesList.toArray(new String[0]);
        Socket socket = null;
        InputStream is = null;
        OutputStream os = null;
        try {
            socket = new Socket(InetAddress.getByName(null), port);
            os = socket.getOutputStream();
            is = socket.getInputStream();
        }
        catch (Exception e) {
            CommandlineLauncherPlugin.getDefault().logError(e);
        }
        if (os != null) {
            PrintWriter ps;
            block20: {
                ps = new PrintWriter(os);
                if (filesList != null && !filesList.isEmpty()) break block20;
                ps.println(IApplication.EXIT_OK);
                ps.flush();
                try {
                    BufferedReader r = new BufferedReader(new InputStreamReader(is));
                    while (r.readLine() != null) {
                    }
                }
                catch (Exception e) {
                    CommandlineLauncherPlugin.getDefault().logError(e);
                }
                try {
                    socket.close();
                }
                catch (IOException iOException) {}
                return 2;
            }
            try {
                String[] stringArray2 = arguments;
                int n3 = arguments.length;
                int n4 = 0;
                while (n4 < n3) {
                    String argument = stringArray2[n4];
                    ps.println(argument);
                    ++n4;
                }
                ps.flush();
                ps.close();
                try {
                    is.read();
                }
                catch (IOException iOException) {}
            }
            catch (Throwable throwable) {
                try {
                    socket.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                socket.close();
            }
            catch (IOException iOException) {}
            return 1;
        }
        return 0;
    }
}

