/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.commandline.launcher;

import com.aptana.commandline.launcher.CommandlineLauncherPlugin;
import com.aptana.core.resources.IProjectContext;
import com.pandora.ui.action.ImportFolderAction;
import com.pandora.ui.utils.IDEUtils;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.progress.WorkbenchJob;

public class CommandlineArgumentsHandler {
    public static List<File> processCommandLineArgs(final String[] arguments) {
        if (arguments == null || arguments.length == 0) {
            return Collections.emptyList();
        }
        final List<File> files = CommandlineArgumentsHandler.gatherFilesFromCommandLineArguments(arguments);
        WorkbenchJob workbenchJob = new WorkbenchJob("Processing command line args."){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)arguments.length);
                for (File f : files) {
                    CommandlineArgumentsHandler.processArgument(f, (IProgressMonitor)sub.newChild(1));
                }
                return Status.OK_STATUS;
            }
        };
        workbenchJob.setSystem(true);
        workbenchJob.setPriority(10);
        workbenchJob.schedule();
        return files;
    }

    protected static void processArgument(File file, IProgressMonitor monitor) {
        if (!file.exists()) {
            return;
        }
        if (file.isFile()) {
            IDEUtils.openLocalFile((File)file, (IWorkbenchWindow)PlatformUI.getWorkbench().getActiveWorkbenchWindow());
        } else if (file.isDirectory()) {
            ImportFolderAction action = new ImportFolderAction(file);
            action.run();
        }
    }

    protected static void processDirectory(File file, IProgressMonitor monitor) {
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)130);
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        File dotProject = new File(file, ".project");
        String projectName = null;
        IProjectDescription description = null;
        if (dotProject.isFile()) {
            try {
                description = workspace.loadProjectDescription(Path.fromOSString((String)dotProject.getAbsolutePath()));
                projectName = description.getName();
            }
            catch (CoreException e) {
                CommandlineLauncherPlugin.getDefault().logError(e);
            }
        }
        if (description == null) {
            projectName = dotProject.getParentFile().getName();
            description = workspace.newProjectDescription(projectName);
            IPath locationPath = Path.fromOSString((String)dotProject.getParent());
            if (Platform.getLocation().isPrefixOf(locationPath)) {
                description.setLocation(null);
            } else {
                description.setLocation(locationPath);
            }
        }
        sub.worked(15);
        try {
            boolean forceAsActive = false;
            IProject project = workspace.getRoot().getProject(projectName);
            if (!project.exists()) {
                project.create(description, (IProgressMonitor)sub.newChild(30));
                forceAsActive = true;
            }
            sub.setWorkRemaining(85);
            if (project.isOpen()) {
                forceAsActive = true;
            } else {
                project.open(128, (IProgressMonitor)sub.newChild(70));
            }
            sub.setWorkRemaining(15);
            if (forceAsActive) {
                CommandlineArgumentsHandler.setActiveProject(project);
            }
        }
        catch (CoreException e) {
            CommandlineLauncherPlugin.getDefault().logError(e);
        }
    }

    protected static void setActiveProject(final IProject project) {
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                IViewReference[] refs;
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (window == null) {
                    return;
                }
                IWorkbenchPage page = window.getActivePage();
                if (page == null) {
                    return;
                }
                IViewReference[] iViewReferenceArray = refs = page.getViewReferences();
                int n = refs.length;
                int n2 = 0;
                while (n2 < n) {
                    IViewReference ref = iViewReferenceArray[n2];
                    IWorkbenchPart view = ref.getPart(false);
                    if (view instanceof IProjectContext) {
                        IProjectContext pc = (IProjectContext)view;
                        pc.setActiveProject(project);
                        return;
                    }
                    ++n2;
                }
            }
        });
    }

    protected static void processFile(File file, IProgressMonitor monitor) {
        IPath path = Path.fromOSString((String)file.getAbsolutePath());
        IFile fileForLocation = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(path);
        IEditorRegistry editorRegistry = PlatformUI.getWorkbench().getEditorRegistry();
        IEditorDescriptor editorDescriptor = null;
        if (fileForLocation == null) {
            IContentType contentType = Platform.getContentTypeManager().findContentTypeFor(file.getName());
            editorDescriptor = editorRegistry.getDefaultEditor(file.getName(), contentType);
        } else {
            editorDescriptor = editorRegistry.getDefaultEditor(file.getName());
        }
        String editorId = editorDescriptor == null ? "com.aptana.editor.text" : editorDescriptor.getId();
        try {
            IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (URI)file.toURI(), (String)editorId, (boolean)true);
        }
        catch (PartInitException e) {
            CommandlineLauncherPlugin.getDefault().logError(e);
        }
    }

    private static List<File> gatherFilesFromCommandLineArguments(String[] arguments) {
        ArrayList<File> files = new ArrayList<File>();
        int i = 0;
        while (i < arguments.length) {
            if ("-keyring".equalsIgnoreCase(arguments[i])) {
                if (arguments.length > i + 1) {
                    ++i;
                }
            } else {
                File file = new File(arguments[i]);
                if (file.exists()) {
                    files.add(file);
                }
            }
            ++i;
        }
        return files;
    }
}

