/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.projects.templates;

import com.pandora.core.log.HBLog;
import com.pandora.core.utils.Activator;
import com.pandora.projects.templates.FileTemplatesManager;
import com.pandora.projects.templates.TemplateType;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.runtime.Plugin;

public class FileTemplate
implements Comparable<FileTemplate> {
    private static final String DEFAULT_TEMPLATE = "default.";
    private String name;
    private String description;
    private File file;
    private boolean isSystem;
    private boolean isDefault;
    private String newFileName;
    private TemplateType templateType = TemplateType.FILE;

    public FileTemplate() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public FileTemplate(String name, String description, String fileExtension, boolean system, File file, TemplateType templateType) throws Exception {
        this.description = description;
        this.isSystem = system;
        if (this.isSystem && name.startsWith(DEFAULT_TEMPLATE)) {
            this.isDefault = true;
            name = name.replace(DEFAULT_TEMPLATE, "");
        }
        this.name = name;
        this.file = file;
        this.templateType = templateType;
        if (!fileExtension.startsWith(".")) {
            fileExtension = "." + fileExtension;
        }
        if (templateType == TemplateType.FILE) {
            this.newFileName = name;
            return;
        }
        if (templateType != TemplateType.GROUP) return;
        ZipFile zip = null;
        try {
            try {
                String zipEntryName;
                ZipEntry zipEntry;
                zip = new ZipFile(file, Charset.forName(FileTemplatesManager.getInstance().getEncode(this)));
                Enumeration<? extends ZipEntry> ens = zip.entries();
                if (!ens.hasMoreElements()) {
                    throw new Exception("\u7a7a\u7684zip\u4e0d\u80fd\u4f5c\u4e3a\u6a21\u677f");
                }
                do {
                    if (!ens.hasMoreElements()) {
                        return;
                    }
                    zipEntry = ens.nextElement();
                    zipEntryName = zipEntry.getName();
                } while (zipEntry.isDirectory() || !zipEntryName.endsWith(fileExtension));
                this.newFileName = zipEntryName.substring(0, zipEntryName.lastIndexOf("."));
                return;
            }
            catch (IOException iOException) {
                throw new Exception("\u635f\u574f\u7684zip\u4e0d\u80fd\u4f5c\u4e3a\u6a21\u677f");
            }
        }
        finally {
            if (zip != null) {
                try {
                    zip.close();
                }
                catch (IOException e) {
                    HBLog.logError((Plugin)Activator.getDefault(), (Throwable)e);
                }
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public boolean isSystem() {
        return this.isSystem;
    }

    public void setSystem(boolean system) {
        this.isSystem = system;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public TemplateType getTemplateType() {
        return this.templateType;
    }

    public void setTemplateType(TemplateType templateType) {
        this.templateType = templateType;
    }

    @Override
    public int compareTo(FileTemplate o) {
        if (this.isDefault) {
            return -1;
        }
        if (o.isDefault) {
            return 1;
        }
        if (this.isSystem && !o.isSystem) {
            return -1;
        }
        if (!this.isSystem && o.isSystem) {
            return 1;
        }
        return this.name.compareTo(o.name);
    }

    public String getNewFileName() {
        return this.newFileName;
    }

    public void setNewFileName(String fileName) {
        this.newFileName = fileName;
    }
}

