/*
 * Decompiled with CFR 0.152.
 */
package sun.usagetracker;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Date;
import java.util.List;
import java.util.Properties;

public final class UsageTrackerClient {
    private static final String ORCL_UT = "com.oracle.usagetracker.";
    private static final String ORCL_UT_CONFIG_FILE = "com.oracle.usagetracker.config.file";
    private static final String ORCL_UT_LOGTOFILE = "com.oracle.usagetracker.logToFile";
    private static final String ORCL_UT_LOGFILEMAXSIZE = "com.oracle.usagetracker.logFileMaxSize";
    private static final String ORCL_UT_LOGTOUDP = "com.oracle.usagetracker.logToUDP";
    private static final String ORCL_UT_VERBOSE = "com.oracle.usagetracker.verbose";
    private static final String ORCL_UT_DEBUG = "com.oracle.usagetracker.debug";
    private static final String ORCL_UT_ADDITIONALPROPERTIES = "com.oracle.usagetracker.additionalProperties";
    private static final String ORCL_UT_SEPARATOR = "com.oracle.usagetracker.separator";
    private static final String javaHome;
    private static final String userHomeKeyword = "${user.home}";
    private static final boolean enabled;
    private static final boolean verbose;
    private static final boolean debug;
    private static final String DEFAULT_SEP = ",";
    private static final String SEP;
    private static final String[] additionalProperties;
    private static final String fullLogFilename;
    private static final long logFileMaxSize;
    private static final String datagramHost;
    private static final int datagramPort;
    private static String staticMessage;

    private static String getPropertyPrivileged(String string) {
        return UsageTrackerClient.getPropertyPrivileged(string, null);
    }

    private static String getPropertyPrivileged(final String string, final String string2) {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(string, string2);
            }
        });
    }

    private static File getPropertiesFilePrivileged() {
        return AccessController.doPrivileged(new PrivilegedAction<File>(){
            final String propsFilename = System.getProperty("com.oracle.usagetracker.config.file", UsageTrackerClient.access$000() + File.separator + "lib" + File.separator + "management" + File.separator + "usagetracker.properties");

            @Override
            public File run() {
                File file = new File(this.propsFilename);
                return file.exists() ? file : null;
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String getFullLogFilename(Properties properties) {
        String string = properties.getProperty(ORCL_UT_LOGTOFILE, "");
        if (string.isEmpty()) {
            return null;
        }
        if (string.startsWith(userHomeKeyword)) {
            if (string.length() > userHomeKeyword.length()) {
                return UsageTrackerClient.getPropertyPrivileged("user.home") + string.substring(userHomeKeyword.length());
            }
            UsageTrackerClient.printVerbose("UsageTracker: blank filename after user.home.");
            return null;
        }
        if (new File(string).isAbsolute()) return string;
        UsageTrackerClient.printVerbose("UsageTracker: relative path disallowed.");
        return null;
    }

    private static long getLogFileMaxSize(Properties properties) {
        String string = properties.getProperty(ORCL_UT_LOGFILEMAXSIZE, "");
        if (!string.isEmpty()) {
            try {
                return Long.parseLong(string);
            }
            catch (NumberFormatException numberFormatException) {
                UsageTrackerClient.printVerbose("UsageTracker: bad maximum file size.");
            }
        }
        return -1L;
    }

    private static String[] getAdditionalProperties(Properties properties) {
        String string = properties.getProperty(ORCL_UT_ADDITIONALPROPERTIES, "");
        return string.isEmpty() ? new String[]{} : string.split(DEFAULT_SEP);
    }

    private static String parseDatagramHost(String string) {
        if (string != null) {
            int n = string.indexOf(58);
            if (n > 0 && n < string.length() - 1) {
                return string.substring(0, n);
            }
            UsageTrackerClient.printVerbose("UsageTracker: bad UDP details.");
        }
        return null;
    }

    private static int parseDatagramPort(String string) {
        if (string != null) {
            int n = string.indexOf(58);
            try {
                return Integer.parseInt(string.substring(n + 1));
            }
            catch (Exception exception) {
                UsageTrackerClient.printVerbose("UsageTracker: bad UDP port.");
            }
        }
        return 0;
    }

    private static void printVerbose(String string) {
        if (verbose) {
            System.err.println(string);
        }
    }

    private static void printDebug(String string) {
        if (debug) {
            System.err.println(string);
        }
    }

    private static void printDebugStackTrace(Throwable throwable) {
        if (debug) {
            throwable.printStackTrace();
        }
    }

    public void run(String string, String string2) {
        UsageTrackerClient.printDebug("UsageTracker.run: " + string + ", javaCommand: " + string2);
        if (enabled) {
            try {
                final UsageTrackerRunnable usageTrackerRunnable = new UsageTrackerRunnable(string, string2);
                AccessController.doPrivileged(new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
                        while (threadGroup.getParent() != null) {
                            threadGroup = threadGroup.getParent();
                        }
                        Thread thread = new Thread(threadGroup, usageTrackerRunnable, "UsageTracker");
                        thread.setDaemon(true);
                        thread.start();
                        return null;
                    }
                });
            }
            catch (Throwable throwable) {
                UsageTrackerClient.printVerbose("UsageTracker: error in starting thread.");
                UsageTrackerClient.printDebugStackTrace(throwable);
            }
        }
    }

    private static boolean getBooleanProperty(Properties properties, String string) {
        return Boolean.parseBoolean(properties.getProperty(string));
    }

    private String buildMessage(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder(string);
        stringBuilder.append(SEP);
        stringBuilder.append(new Date());
        stringBuilder.append(SEP);
        String string3 = "0";
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            string3 = inetAddress.toString();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        stringBuilder.append(string3);
        stringBuilder.append(SEP);
        stringBuilder.append(string2);
        stringBuilder.append(SEP);
        stringBuilder.append(UsageTrackerClient.getRuntimeDetails());
        stringBuilder.append("\n");
        return stringBuilder.toString();
    }

    private static synchronized String getRuntimeDetails() {
        if (staticMessage == null) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(javaHome);
            stringBuilder.append(SEP);
            stringBuilder.append(UsageTrackerClient.getPropertyPrivileged("java.version"));
            stringBuilder.append(SEP);
            stringBuilder.append(UsageTrackerClient.getPropertyPrivileged("java.vm.version"));
            stringBuilder.append(SEP);
            stringBuilder.append(UsageTrackerClient.getPropertyPrivileged("java.vendor"));
            stringBuilder.append(SEP);
            stringBuilder.append(UsageTrackerClient.getPropertyPrivileged("java.vm.vendor"));
            stringBuilder.append(SEP);
            stringBuilder.append(UsageTrackerClient.getPropertyPrivileged("os.name"));
            stringBuilder.append(SEP);
            stringBuilder.append(UsageTrackerClient.getPropertyPrivileged("os.arch"));
            stringBuilder.append(SEP);
            stringBuilder.append(UsageTrackerClient.getPropertyPrivileged("os.version"));
            stringBuilder.append(SEP);
            List<String> list = null;
            RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
            list = runtimeMXBean.getInputArguments();
            for (String string : list) {
                stringBuilder.append(string);
                stringBuilder.append(' ');
            }
            stringBuilder.append(SEP);
            stringBuilder.append(UsageTrackerClient.getPropertyPrivileged("java.class.path"));
            stringBuilder.append(SEP);
            for (String string : additionalProperties) {
                stringBuilder.append(string.trim());
                stringBuilder.append("=");
                stringBuilder.append(UsageTrackerClient.getPropertyPrivileged(string.trim()));
                stringBuilder.append(" ");
            }
            staticMessage = stringBuilder.toString();
        }
        return staticMessage;
    }

    private void sendDatagram(String string) {
        UsageTrackerClient.printDebug("UsageTracker: sendDatagram");
        try (DatagramSocket datagramSocket = new DatagramSocket();){
            byte[] byArray = string.getBytes("UTF-8");
            if (byArray.length > datagramSocket.getSendBufferSize()) {
                UsageTrackerClient.printVerbose("UsageTracker: message truncated for Datagram.");
            }
            UsageTrackerClient.printDebug("UsageTracker: host=" + datagramHost + ", port=" + datagramPort);
            UsageTrackerClient.printDebug("UsageTracker: SendBufferSize = " + datagramSocket.getSendBufferSize());
            UsageTrackerClient.printDebug("UsageTracker: packet length  = " + byArray.length);
            InetAddress inetAddress = InetAddress.getByName(datagramHost);
            DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length > datagramSocket.getSendBufferSize() ? datagramSocket.getSendBufferSize() : byArray.length, inetAddress, datagramPort);
            datagramSocket.send(datagramPacket);
            UsageTrackerClient.printVerbose("UsageTracker: done sending to UDP.");
            UsageTrackerClient.printDebug("UsageTracker: sent size = " + datagramPacket.getLength());
        }
        catch (Throwable throwable) {
            UsageTrackerClient.printVerbose("UsageTracker: error in sendDatagram: " + throwable);
            UsageTrackerClient.printDebugStackTrace(throwable);
        }
    }

    private void sendToFile(String string) {
        UsageTrackerClient.printDebug("UsageTracker: sendToFile");
        File file = new File(fullLogFilename);
        if (logFileMaxSize >= 0L && file.length() >= logFileMaxSize) {
            UsageTrackerClient.printVerbose("UsageTracker: log file size exceeds maximum.");
            return;
        }
        try (FileOutputStream fileOutputStream = new FileOutputStream(file, true);
             OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8");){
            outputStreamWriter.write(string, 0, string.length());
            UsageTrackerClient.printVerbose("UsageTracker: done sending to file.");
            UsageTrackerClient.printDebug("UsageTracker: " + fullLogFilename);
        }
        catch (Throwable throwable) {
            UsageTrackerClient.printVerbose("UsageTracker: error in sending to file.");
            UsageTrackerClient.printDebugStackTrace(throwable);
        }
    }

    static /* synthetic */ String access$000() {
        return javaHome;
    }

    static {
        Object object;
        javaHome = UsageTrackerClient.getPropertyPrivileged("java.home");
        File file = UsageTrackerClient.getPropertiesFilePrivileged();
        Properties properties = new Properties();
        if (file != null) {
            try {
                object = new FileInputStream(file);
                Throwable throwable = null;
                try (BufferedInputStream bufferedInputStream = new BufferedInputStream((InputStream)object);){
                    properties.load(bufferedInputStream);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (object != null) {
                        if (throwable != null) {
                            try {
                                ((FileInputStream)object).close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            ((FileInputStream)object).close();
                        }
                    }
                }
            }
            catch (Exception exception) {
                properties.clear();
            }
        }
        verbose = UsageTrackerClient.getBooleanProperty(properties, ORCL_UT_VERBOSE);
        debug = UsageTrackerClient.getBooleanProperty(properties, ORCL_UT_DEBUG);
        SEP = properties.getProperty(ORCL_UT_SEPARATOR, DEFAULT_SEP);
        fullLogFilename = UsageTrackerClient.getFullLogFilename(properties);
        logFileMaxSize = UsageTrackerClient.getLogFileMaxSize(properties);
        additionalProperties = UsageTrackerClient.getAdditionalProperties(properties);
        object = properties.getProperty(ORCL_UT_LOGTOUDP);
        datagramHost = UsageTrackerClient.parseDatagramHost((String)object);
        datagramPort = UsageTrackerClient.parseDatagramPort((String)object);
        enabled = fullLogFilename != null || datagramHost != null && datagramPort > 0;
    }

    class UsageTrackerRunnable
    implements Runnable {
        private String callerName;
        private String javaCommand;

        UsageTrackerRunnable(String string, String string2) {
            this.callerName = string;
            this.javaCommand = string2 != null ? string2 : "";
        }

        @Override
        public void run() {
            UsageTrackerClient.printDebug("UsageTrackerRunnable: run");
            String string = UsageTrackerClient.this.buildMessage(this.callerName, this.javaCommand);
            if (datagramHost != null && datagramPort > 0) {
                UsageTrackerClient.this.sendDatagram(string);
            }
            if (fullLogFilename != null) {
                UsageTrackerClient.this.sendToFile(string);
            }
        }
    }
}

