/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.generic;

import com.sun.org.apache.bcel.internal.generic.InstructionHandle;
import com.sun.org.apache.bcel.internal.generic.Select;
import com.sun.org.apache.bcel.internal.generic.Visitor;
import com.sun.org.apache.bcel.internal.util.ByteSequence;
import java.io.DataOutputStream;
import java.io.IOException;

public class TABLESWITCH
extends Select {
    TABLESWITCH() {
    }

    public TABLESWITCH(int[] nArray, InstructionHandle[] instructionHandleArray, InstructionHandle instructionHandle) {
        super((short)170, nArray, instructionHandleArray, instructionHandle);
        this.length = (short)(13 + this.match_length * 4);
        this.fixed_length = this.length;
    }

    @Override
    public void dump(DataOutputStream dataOutputStream) throws IOException {
        super.dump(dataOutputStream);
        int n = this.match_length > 0 ? this.match[0] : 0;
        dataOutputStream.writeInt(n);
        int n2 = this.match_length > 0 ? this.match[this.match_length - 1] : 0;
        dataOutputStream.writeInt(n2);
        for (int i = 0; i < this.match_length; ++i) {
            this.indices[i] = this.getTargetOffset(this.targets[i]);
            dataOutputStream.writeInt(this.indices[i]);
        }
    }

    @Override
    protected void initFromFile(ByteSequence byteSequence, boolean bl) throws IOException {
        int n;
        super.initFromFile(byteSequence, bl);
        int n2 = byteSequence.readInt();
        int n3 = byteSequence.readInt();
        this.match_length = n3 - n2 + 1;
        this.fixed_length = (short)(13 + this.match_length * 4);
        this.length = (short)(this.fixed_length + this.padding);
        this.match = new int[this.match_length];
        this.indices = new int[this.match_length];
        this.targets = new InstructionHandle[this.match_length];
        for (n = n2; n <= n3; ++n) {
            this.match[n - n2] = n;
        }
        for (n = 0; n < this.match_length; ++n) {
            this.indices[n] = byteSequence.readInt();
        }
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitVariableLengthInstruction(this);
        visitor.visitStackProducer(this);
        visitor.visitBranchInstruction(this);
        visitor.visitSelect(this);
        visitor.visitTABLESWITCH(this);
    }
}

