/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.webserver.ui.preferences;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.EclipseUtil;
import com.aptana.core.util.SocketUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.webserver.ui.WebServerUIPlugin;
import com.aptana.webserver.ui.preferences.Messages;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.jface.preference.ComboFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class LocalWebServerPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private static final Pattern PORTS_PATTERN = Pattern.compile("^(\\d+)(-(\\d+))?$");

    public void init(IWorkbench workbench) {
        this.setMessage(Messages.LocalWebServerPreferencePage_Message);
        this.setDescription(Messages.LocalWebServerPreferencePage_Description);
    }

    protected void createFieldEditors() {
        ArrayList<String[]> addresses = new ArrayList<String[]>();
        InetAddress[] inetAddressArray = SocketUtil.getLocalAddresses();
        int n = inetAddressArray.length;
        int n2 = 0;
        while (n2 < n) {
            InetAddress i = inetAddressArray[n2];
            addresses.add(new String[]{i.getHostAddress(), i.getHostAddress()});
            ++n2;
        }
        this.addField((FieldEditor)new ComboFieldEditor("com.aptana.webserver.core.http_server_address", StringUtil.makeFormLabel((String)Messages.LocalWebServerPreferencePage_Address_Label), (String[][])addresses.toArray((T[])new String[addresses.size()][]), this.getFieldEditorParent()));
        this.addField((FieldEditor)new StringFieldEditor("com.aptana.webserver.core.http_server_ports", StringUtil.makeFormLabel((String)Messages.LocalWebServerPreferencePage_Port_Label), 11, this.getFieldEditorParent()){
            {
                this.setErrorMessage(Messages.LocalWebServerPreferencePage_PortError_Message);
                this.setEmptyStringAllowed(true);
            }

            protected boolean doCheckState() {
                block5: {
                    Matcher matcher = PORTS_PATTERN.matcher(this.getStringValue());
                    if (matcher.matches()) {
                        try {
                            int start = Integer.parseInt(matcher.group(1));
                            if (matcher.group(2) != null) {
                                int end = Integer.parseInt(matcher.group(3));
                                if (start < end) {
                                    return true;
                                }
                                break block5;
                            }
                            return true;
                        }
                        catch (NumberFormatException e) {
                            IdeLog.logError((Plugin)WebServerUIPlugin.getDefault(), (Throwable)e);
                        }
                    }
                }
                return false;
            }
        });
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return new ScopedPreferenceStore((IScopeContext)EclipseUtil.instanceScope(), "com.aptana.webserver.core");
    }
}

