/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.webserver.ui.internal;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.StringUtil;
import com.aptana.ui.IPropertyDialog;
import com.aptana.ui.IPropertyDialogProvider;
import com.aptana.webserver.core.ExternalWebServer;
import com.aptana.webserver.core.IServer;
import com.aptana.webserver.core.WebServerCorePlugin;
import com.aptana.webserver.ui.WebServerUIPlugin;
import com.aptana.webserver.ui.internal.Messages;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ExternalWebServerPropertyDialog
extends TitleAreaDialog
implements IPropertyDialog {
    private static final int LABEL_WIDTH = 70;
    private ExternalWebServer source;
    private String title = Messages.SimpleWebServerPropertyDialog_Title;
    private Text nameText;
    private Text baseUrlText;
    private Button enableIncludeProjectNameButton;
    private Button disableIncludeProjectNameButton;
    private Label includeProjectNameExampleLabel;
    private Text startCommandText;
    private Text stopCommandText;
    private ModifyListener modifyListener;

    public ExternalWebServerPropertyDialog(Shell parentShell) {
        super(parentShell);
        this.setHelpAvailable(false);
    }

    public Object getPropertySource() {
        return this.source;
    }

    public void setPropertySource(Object element) {
        this.source = null;
        if (element instanceof ExternalWebServer) {
            this.source = (ExternalWebServer)element;
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        this.setTitle(this.title);
        this.getShell().setText(Messages.SimpleWebServerPropertyDialog_ShellTitle);
        Composite composite = new Composite(dialogArea, 0);
        composite.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        PixelConverter converter = new PixelConverter((Control)composite);
        composite.setLayout((Layout)GridLayoutFactory.swtDefaults().margins(converter.convertHorizontalDLUsToPixels(7), converter.convertVerticalDLUsToPixels(7)).spacing(converter.convertHorizontalDLUsToPixels(4), converter.convertVerticalDLUsToPixels(4)).numColumns(3).create());
        Label label = new Label(composite, 0);
        label.setLayoutData((Object)GridDataFactory.swtDefaults().hint(new PixelConverter((Control)label).convertHorizontalDLUsToPixels(70), -1).create());
        label.setText(StringUtil.makeFormLabel((String)Messages.SimpleWebServerPropertyDialog_Name_Label));
        this.nameText = new Text(composite, 2052);
        this.nameText.setLayoutData((Object)GridDataFactory.fillDefaults().hint(this.convertHorizontalDLUsToPixels(200), -1).span(2, 1).grab(true, false).create());
        label = new Label(composite, 0);
        label.setLayoutData((Object)GridDataFactory.swtDefaults().hint(new PixelConverter((Control)label).convertHorizontalDLUsToPixels(70), -1).create());
        label.setText(StringUtil.makeFormLabel((String)Messages.SimpleWebServerPropertyDialog_BaseURL_Label));
        this.baseUrlText = new Text(composite, 2052);
        this.baseUrlText.setLayoutData((Object)GridDataFactory.swtDefaults().hint(new PixelConverter((Control)this.baseUrlText).convertHorizontalDLUsToPixels(200), -1).span(2, 1).align(4, 0x1000000).grab(true, false).create());
        this.baseUrlText.setText("http://");
        label = new Label(composite, 0);
        label.setLayoutData((Object)GridDataFactory.swtDefaults().hint(new PixelConverter((Control)label).convertHorizontalDLUsToPixels(70), -1).create());
        label = new Label(composite, 64);
        label.setLayoutData((Object)GridDataFactory.fillDefaults().hint(this.convertHorizontalDLUsToPixels(200), -1).span(2, 1).grab(true, false).create());
        label.setText("\u6309\u7167\u5916\u90e8\u670d\u52a1\u5668\u7684\u534f\u8bae\u3001ip\u3001\u7aef\u53e3\u6765\u8bbe\u7f6e\u8bbf\u95ee\u6b64\u670d\u52a1\u5668\u7684URL\r\n\u793a\u4f8b:    http://192.168.0.103:8080");
        label = new Label(composite, 0);
        label.setLayoutData((Object)GridDataFactory.swtDefaults().hint(new PixelConverter((Control)label).convertHorizontalDLUsToPixels(70), -1).create());
        label.setText(StringUtil.makeFormLabel((String)"URL\u5305\u542b\u9879\u76ee\u540d\u79f0"));
        Composite includeProjectComposite = new Composite(composite, 0);
        includeProjectComposite.setLayoutData((Object)GridDataFactory.swtDefaults().span(2, 1).align(1, 0x1000000).grab(true, false).create());
        RowLayout layout = new RowLayout(256);
        layout.spacing = 10;
        includeProjectComposite.setLayout((Layout)layout);
        this.enableIncludeProjectNameButton = new Button(includeProjectComposite, 16);
        this.enableIncludeProjectNameButton.setText("\u5305\u542b");
        this.enableIncludeProjectNameButton.setSelection(true);
        this.disableIncludeProjectNameButton = new Button(includeProjectComposite, 16);
        this.disableIncludeProjectNameButton.setText("\u4e0d\u5305\u542b");
        label = new Label(composite, 0);
        label.setLayoutData((Object)GridDataFactory.swtDefaults().hint(new PixelConverter((Control)label).convertHorizontalDLUsToPixels(70), -1).create());
        this.includeProjectNameExampleLabel = new Label(composite, 64);
        this.includeProjectNameExampleLabel.setLayoutData((Object)GridDataFactory.fillDefaults().hint(this.convertHorizontalDLUsToPixels(200), -1).span(2, 1).grab(true, false).create());
        label = new Label(composite, 0);
        label.setLayoutData((Object)GridDataFactory.swtDefaults().hint(new PixelConverter((Control)label).convertHorizontalDLUsToPixels(70), -1).create());
        label.setText(StringUtil.makeFormLabel((String)Messages.ExternalWebServerPropertyDialog_StartCommandLabel));
        this.startCommandText = new Text(composite, 2052);
        this.startCommandText.setMessage("\u9700\u8981HBuilder\u63a7\u5236\u670d\u52a1\u5668\u542f\u52a8\u65f6\uff0c\u624d\u6709\u5fc5\u8981\u586b\u5199");
        this.startCommandText.setLayoutData((Object)GridDataFactory.swtDefaults().hint(new PixelConverter((Control)this.baseUrlText).convertHorizontalDLUsToPixels(200), -1).span(2, 1).align(4, 0x1000000).grab(true, false).create());
        label = new Label(composite, 0);
        label.setLayoutData((Object)GridDataFactory.swtDefaults().hint(new PixelConverter((Control)label).convertHorizontalDLUsToPixels(70), -1).create());
        label = new Label(composite, 64);
        label.setLayoutData((Object)GridDataFactory.fillDefaults().hint(this.convertHorizontalDLUsToPixels(200), -1).span(2, 1).grab(true, false).create());
        label.setText("\u793a\u4f8b:\r\n    nginx\u7684\u542f\u52a8\u547d\u4ee4\u4e3a:  D:/nginx/nginx.exe\r\n    \u5176\u4ed6\u79cd\u7c7b\u670d\u52a1\u5668\u7684\u542f\u52a8\u547d\u4ee4\u8bf7\u67e5\u9605\u76f8\u5173\u8d44\u6599");
        label = new Label(composite, 0);
        label.setLayoutData((Object)GridDataFactory.swtDefaults().hint(new PixelConverter((Control)label).convertHorizontalDLUsToPixels(70), -1).create());
        label.setText(StringUtil.makeFormLabel((String)Messages.ExternalWebServerPropertyDialog_StopCommandLabel));
        this.stopCommandText = new Text(composite, 2052);
        this.stopCommandText.setMessage("\u9700\u8981HBuilder\u63a7\u5236\u670d\u52a1\u5668\u5173\u95ed\u65f6\uff0c\u624d\u6709\u5fc5\u8981\u586b\u5199");
        this.stopCommandText.setLayoutData((Object)GridDataFactory.swtDefaults().hint(new PixelConverter((Control)this.baseUrlText).convertHorizontalDLUsToPixels(200), -1).span(2, 1).align(4, 0x1000000).grab(true, false).create());
        label = new Label(composite, 0);
        label.setLayoutData((Object)GridDataFactory.swtDefaults().hint(new PixelConverter((Control)label).convertHorizontalDLUsToPixels(70), -1).create());
        label = new Label(composite, 64);
        label.setLayoutData((Object)GridDataFactory.fillDefaults().hint(this.convertHorizontalDLUsToPixels(200), -1).span(2, 1).grab(true, false).create());
        label.setText("\u793a\u4f8b:\r\n    nginx\u7684\u5173\u95ed\u547d\u4ee4\u4e3a:  D:/nginx/nginx.exe -s stop\r\n    \u5176\u4ed6\u79cd\u7c7b\u670d\u52a1\u5668\u7684\u5173\u95ed\u547d\u4ee4\u8bf7\u67e5\u9605\u76f8\u5173\u8d44\u6599");
        if (this.source != null) {
            String name = this.source.getName();
            this.nameText.setText(name != null ? name : "");
            URL url = this.source.getBaseURL();
            if (url != null) {
                this.baseUrlText.setText(url.toExternalForm());
            }
            this.enableIncludeProjectNameButton.setSelection(this.source.isIncludeProjectName());
            this.disableIncludeProjectNameButton.setSelection(!this.source.isIncludeProjectName());
            String startCommand = this.source.getStartCommand();
            this.startCommandText.setText(startCommand != null ? startCommand : "");
            String stopCommand = this.source.getStopCommand();
            this.stopCommandText.setText(stopCommand != null ? stopCommand : "");
        }
        this.changeIncludeProjectNameExampleLabel();
        this.addListeners();
        return dialogArea;
    }

    protected Control createContents(Composite parent) {
        try {
            Control control = super.createContents(parent);
            return control;
        }
        finally {
            this.validate();
        }
    }

    protected void okPressed() {
        if (!this.isValid()) {
            return;
        }
        if (this.source != null) {
            this.source.setName(this.nameText.getText());
            this.source.setStartCommand(this.startCommandText.getText());
            this.source.setStopCommand(this.stopCommandText.getText());
            this.source.setIncludeProjectName(this.enableIncludeProjectNameButton.getSelection());
            try {
                this.source.setBaseURL(new URL(this.baseUrlText.getText()));
            }
            catch (MalformedURLException e) {
                IdeLog.logError((Plugin)WebServerUIPlugin.getDefault(), (Throwable)e);
            }
        }
        WebServerCorePlugin.getDefault().saveServerConfigurations();
        super.okPressed();
    }

    private boolean isValid() {
        String message = null;
        if (this.nameText.getText().length() == 0) {
            message = Messages.SimpleWebServerPropertyDialog_EmptyNameError;
        } else {
            IServer server;
            if (this.source != null && !this.nameText.getText().equals(this.source.getName()) && (server = WebServerCorePlugin.getDefault().getServerManager().findServerByName(this.nameText.getText())) != null) {
                message = "\u5df2\u5b58\u5728\u540c\u540d\u7684Web\u670d\u52a1\u5668";
            }
            if (message == null) {
                try {
                    if (new URL(this.baseUrlText.getText()).getHost().length() == 0) {
                        message = Messages.SimpleWebServerPropertyDialog_InvalidURLError;
                    }
                }
                catch (MalformedURLException malformedURLException) {
                    message = Messages.SimpleWebServerPropertyDialog_InvalidURLError;
                }
            }
        }
        if (message == null) {
            this.setErrorMessage(null);
            this.setMessage(null);
            return true;
        }
        this.setErrorMessage(message);
        return false;
    }

    private void validate() {
        boolean valid = this.isValid();
        Button okButton = this.getButton(0);
        if (okButton != null) {
            okButton.setEnabled(valid);
        }
    }

    protected void addListeners() {
        if (this.modifyListener == null) {
            this.modifyListener = new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    ExternalWebServerPropertyDialog.this.validate();
                }
            };
        }
        this.nameText.addModifyListener(this.modifyListener);
        this.baseUrlText.addModifyListener(this.modifyListener);
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ExternalWebServerPropertyDialog.this.enableIncludeProjectNameButton.getSelection()) {
                    ExternalWebServerPropertyDialog.this.disableIncludeProjectNameButton.setSelection(false);
                } else if (ExternalWebServerPropertyDialog.this.disableIncludeProjectNameButton.getSelection()) {
                    ExternalWebServerPropertyDialog.this.enableIncludeProjectNameButton.setSelection(false);
                }
                ExternalWebServerPropertyDialog.this.changeIncludeProjectNameExampleLabel();
            }
        };
        this.enableIncludeProjectNameButton.addSelectionListener((SelectionListener)selectionAdapter);
        this.disableIncludeProjectNameButton.addSelectionListener((SelectionListener)selectionAdapter);
    }

    private void changeIncludeProjectNameExampleLabel() {
        if (this.enableIncludeProjectNameButton.getSelection()) {
            this.includeProjectNameExampleLabel.setText("\u793a\u4f8b:    http://192.168.0.103:8080/\u9879\u76ee\u540d\u79f0/index.html");
        } else if (this.disableIncludeProjectNameButton.getSelection()) {
            this.includeProjectNameExampleLabel.setText("\u793a\u4f8b:    http://192.168.0.103:8080/index.html");
        }
    }

    protected void removeListeners() {
        if (this.modifyListener != null) {
            this.nameText.removeModifyListener(this.modifyListener);
            this.baseUrlText.removeModifyListener(this.modifyListener);
        }
    }

    public void setDialogTitle(String title) {
        this.title = title;
    }

    public static class Provider
    implements IPropertyDialogProvider {
        public Dialog createPropertyDialog(IShellProvider shellProvider) {
            return new ExternalWebServerPropertyDialog(shellProvider.getShell());
        }
    }
}

