/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ruby.internal.rake.actions;

import com.aptana.ruby.internal.rake.actions.RunRakeAction;
import com.aptana.ruby.rake.IRakeHelper;
import com.aptana.ruby.rake.RakePlugin;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.menus.IWorkbenchContribution;
import org.eclipse.ui.services.IEvaluationService;
import org.eclipse.ui.services.IServiceLocator;

public class RakeTasksContributionItem
extends ContributionItem
implements IWorkbenchContribution {
    static final String RAKE_NAMESPACE_DELIMETER = ":";
    private Map<String, MenuManager> fNamespaces;
    private IServiceLocator serviceLocator;

    public RakeTasksContributionItem() {
    }

    public RakeTasksContributionItem(String id) {
        super(id);
    }

    public void fill(Menu menu, int index) {
        IProject project = this.getProject();
        if (project == null) {
            return;
        }
        Map<String, String> tasks = this.getRakeHelper().getTasks(project, (IProgressMonitor)new NullProgressMonitor());
        this.fNamespaces = new HashMap<String, MenuManager>();
        ArrayList<String> values = new ArrayList<String>(tasks.keySet());
        Collections.sort(values);
        for (String task : values) {
            String[] paths = task.split(RAKE_NAMESPACE_DELIMETER);
            if (paths.length == 1) {
                RunRakeAction action = new RunRakeAction(project, task, tasks.get(task));
                ActionContributionItem item = new ActionContributionItem((IAction)action);
                item.fill(menu, -1);
                continue;
            }
            MenuManager manager = this.getOrCreate(paths);
            manager.add((IAction)new RunRakeAction(project, task, tasks.get(task)));
        }
        values = new ArrayList<String>(this.fNamespaces.keySet());
        Collections.sort(values);
        Collections.reverse(values);
        for (String path : values) {
            int index2;
            MenuManager manager = this.fNamespaces.get(path);
            String[] parts = path.split(RAKE_NAMESPACE_DELIMETER);
            if (parts.length == 1) {
                int index22 = this.getInsertIndex(menu, manager);
                manager.fill(menu, index22);
                continue;
            }
            MenuManager parent = this.getParent(parts);
            if (parent != null) {
                index2 = this.getInsertIndex(parent, manager);
                parent.insert(index2, (IContributionItem)manager);
                continue;
            }
            index2 = this.getInsertIndex(menu, manager);
            manager.fill(menu, index2);
        }
    }

    private IProject getProject() {
        IResource resource = this.getSelectedResource();
        if (resource == null) {
            return null;
        }
        return resource.getProject();
    }

    private IResource getSelectedResource() {
        IEvaluationService evalService = (IEvaluationService)this.serviceLocator.getService(IEvaluationService.class);
        if (evalService != null) {
            IEvaluationContext context = evalService.getCurrentState();
            IWorkbenchPart activePart = (IWorkbenchPart)context.getVariable("activePart");
            if (activePart instanceof IEditorPart) {
                IEditorInput input = (IEditorInput)context.getVariable("activeEditorInput");
                return (IResource)input.getAdapter(IResource.class);
            }
            ISelection selection = (ISelection)context.getVariable("selection");
            if (selection instanceof IStructuredSelection) {
                IStructuredSelection struct = (IStructuredSelection)selection;
                Object firstElement = struct.getFirstElement();
                if (firstElement instanceof IResource) {
                    return (IResource)firstElement;
                }
                if (firstElement instanceof IAdaptable) {
                    IAdaptable adaptable = (IAdaptable)firstElement;
                    return (IResource)adaptable.getAdapter(IResource.class);
                }
            }
        }
        return null;
    }

    private int getInsertIndex(MenuManager parent, MenuManager item) {
        if (parent == null || item == null) {
            return 0;
        }
        String text = item.getMenuText();
        if (text == null) {
            return 0;
        }
        IContributionItem[] items = parent.getItems();
        if (items == null) {
            return 0;
        }
        int index = 0;
        int i = 0;
        while (i < items.length) {
            ActionContributionItem actionItem;
            IAction action;
            if (items[i] != null && items[i] instanceof ActionContributionItem && (action = (actionItem = (ActionContributionItem)items[i]).getAction()) != null) {
                String other = action.getText();
                if (text.compareTo(other) < 0) break;
                index = i + 1;
            }
            ++i;
        }
        return index;
    }

    private int getInsertIndex(Menu parent, MenuManager item) {
        String text = item.getMenuText();
        MenuItem[] items = parent.getItems();
        int index = 0;
        int i = 0;
        while (i < items.length) {
            String other = items[i].getText();
            if (text.compareTo(other) < 0) break;
            index = i + 1;
            ++i;
        }
        return index;
    }

    protected IRakeHelper getRakeHelper() {
        return RakePlugin.getDefault().getRakeHelper();
    }

    private MenuManager getParent(String[] parts) {
        String[] part = this.stripLastItem(parts);
        return this.fNamespaces.get(this.join(part));
    }

    private String join(String[] part) {
        StringBuilder buffer = new StringBuilder();
        int i = 0;
        while (i < part.length) {
            if (i != 0) {
                buffer.append(RAKE_NAMESPACE_DELIMETER);
            }
            buffer.append(part[i]);
            ++i;
        }
        return buffer.toString();
    }

    private MenuManager getOrCreate(String[] paths) {
        String[] part = this.stripLastItem(paths);
        MenuManager manager = this.fNamespaces.get(this.join(part));
        if (manager == null) {
            manager = new MenuManager(part[part.length - 1]);
            this.fNamespaces.put(this.join(part), manager);
        }
        return manager;
    }

    private String[] stripLastItem(String[] paths) {
        String[] part = new String[paths.length - 1];
        System.arraycopy(paths, 0, part, 0, part.length);
        return part;
    }

    public void initialize(IServiceLocator serviceLocator) {
        this.serviceLocator = serviceLocator;
    }
}

