/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.scripting.ui.views;

import com.aptana.scripting.model.BundleElement;
import com.aptana.scripting.model.CommandElement;
import com.aptana.scripting.model.TemplateElement;
import com.aptana.scripting.ui.ScriptingUIPlugin;
import com.aptana.scripting.ui.views.BaseNode;
import com.aptana.scripting.ui.views.FileTemplateNode;
import com.aptana.scripting.ui.views.IPropertyInformation;
import com.aptana.scripting.ui.views.Messages;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.eclipse.swt.graphics.Image;

class FileTemplatesNode
extends BaseNode<Property> {
    private static final Image FILE_TEMPLATES_ICON = ScriptingUIPlugin.getImage("icons/folder.png");
    private FileTemplateNode[] fileTemplates;

    FileTemplatesNode(BundleElement bundle) {
        this(bundle.getCommands());
    }

    FileTemplatesNode(List<CommandElement> elements) {
        ArrayList<FileTemplateNode> items = new ArrayList<FileTemplateNode>();
        if (elements != null) {
            Collections.sort(elements);
            for (CommandElement command : elements) {
                if (!(command instanceof TemplateElement)) continue;
                items.add(new FileTemplateNode((TemplateElement)command));
            }
        }
        this.fileTemplates = items.toArray(new FileTemplateNode[items.size()]);
    }

    @Override
    public Object[] getChildren() {
        return this.fileTemplates;
    }

    @Override
    public Image getImage() {
        return FILE_TEMPLATES_ICON;
    }

    @Override
    protected Set<Property> getPropertyInfoSet() {
        return EnumSet.allOf(Property.class);
    }

    @Override
    public String getLabel() {
        return Messages.FileTemplatesNode_FileTemplatesNodeName;
    }

    @Override
    public boolean hasChildren() {
        return this.fileTemplates.length > 0;
    }

    static enum Property implements IPropertyInformation<FileTemplatesNode>
    {
        COUNT(Messages.FileTemplatesNode_File_Templates_Count){

            @Override
            public Object getPropertyValue(FileTemplatesNode node) {
                return node.fileTemplates.length;
            }
        };

        private String header;

        private Property(String header) {
            this.header = header;
        }

        @Override
        public String getHeader() {
            return this.header;
        }

        @Override
        public Object getPropertyValue(FileTemplatesNode node) {
            return null;
        }
    }
}

