/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.scripting.ui.internal;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.EclipseUtil;
import com.aptana.scripting.ScriptingActivator;
import com.aptana.scripting.model.AbstractElement;
import com.aptana.scripting.model.BundleManager;
import com.aptana.scripting.model.CommandElement;
import com.aptana.scripting.model.LoadCycleListener;
import com.aptana.scripting.model.filters.IModelFilter;
import com.aptana.scripting.ui.ICommandElementsProvider;
import com.aptana.scripting.ui.KeyBindingUtil;
import com.aptana.scripting.ui.internal.KeyBindingState;
import com.aptana.ui.keybinding.KeyBindingHelper;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.CommandException;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.commands.contexts.ContextManagerEvent;
import org.eclipse.core.commands.contexts.IContextManagerListener;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.bindings.Binding;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.bindings.keys.KeySequence;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.internal.keys.BindingService;
import org.eclipse.ui.internal.keys.WorkbenchKeyboard;
import org.eclipse.ui.keys.IBindingService;
import org.eclipse.ui.progress.WorkbenchJob;
import org.eclipse.ui.services.IEvaluationService;

public class KeybindingsManager
implements LoadCycleListener {
    private static final String MNEMONICS = "123456789";
    private static final AtomicBoolean installed = new AtomicBoolean(false);
    private static KeybindingsManager INSTANCE;
    private final IWorkbench workbench;
    private final Listener listener = new Listener(){

        public void handleEvent(Event event) {
            if (!KeybindingsManager.this.enabled) {
                return;
            }
            if (KeybindingsManager.this.showingCommandsMenu) {
                return;
            }
            if (event.stateMask == 0 && event.keyCode == 0 && event.character == '\u0000') {
                return;
            }
            if (!KeyBindingHelper.isKeyEventComplete((Event)event)) {
                return;
            }
            List possibleKeyStrokes = WorkbenchKeyboard.generatePossibleKeyStrokes((Event)event);
            if (possibleKeyStrokes.size() > 0) {
                KeybindingsManager.this.processKeyStrokes(event, possibleKeyStrokes);
            }
        }
    };
    private final KeyBindingState state;
    private final IWindowListener windowListener = new IWindowListener(){

        public void windowActivated(IWorkbenchWindow window) {
            KeybindingsManager.this.checkActiveWindow(window);
        }

        public void windowClosed(IWorkbenchWindow window) {
        }

        public void windowDeactivated(IWorkbenchWindow window) {
        }

        public void windowOpened(IWorkbenchWindow window) {
        }
    };
    private boolean enabled;
    private boolean showingCommandsMenu;
    private final IContextManagerListener contextManagerListener = new IContextManagerListener(){

        public void contextManagerChanged(ContextManagerEvent contextManagerEvent) {
            KeybindingsManager.this.setEnabled(contextManagerEvent.getContextManager().getActiveContextIds().contains("com.aptana.scripting.context"));
        }
    };
    private static final MutexRule MUTEX_RULE;
    private BundleManager bundleManager;
    private final Set<KeySequence> uniqueKeySequences;
    private final Set<KeySequence> uniqueKeySequencesPrefixes;
    private Job workbenchJob;

    static {
        MUTEX_RULE = new MutexRule();
    }

    public static void install() {
        if (installed.compareAndSet(false, true)) {
            IWorkbench workbench = null;
            try {
                workbench = PlatformUI.getWorkbench();
            }
            catch (Exception exception) {}
            if (workbench != null) {
                INSTANCE = new KeybindingsManager(workbench);
                INSTANCE.initBindings();
            }
        }
    }

    public static void uninstall() {
        if (installed.compareAndSet(true, false)) {
            if (INSTANCE != null) {
                INSTANCE.dispose();
            }
            INSTANCE = null;
        }
    }

    private KeybindingsManager(IWorkbench workbench) {
        this.workbench = workbench;
        this.state = new KeyBindingState(workbench);
        workbench.addWindowListener(this.windowListener);
        this.uniqueKeySequences = new HashSet<KeySequence>();
        this.uniqueKeySequencesPrefixes = new HashSet<KeySequence>();
        this.bundleManager = BundleManager.getInstance();
        this.bundleManager.addLoadCycleListener((LoadCycleListener)this);
    }

    private void dispose() {
        WorkbenchJob job = new WorkbenchJob("Disposing KeybindingsManager"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                KeybindingsManager.this.workbench.getDisplay().removeFilter(1, KeybindingsManager.this.listener);
                KeybindingsManager.this.workbench.getDisplay().removeFilter(31, KeybindingsManager.this.listener);
                return Status.OK_STATUS;
            }
        };
        EclipseUtil.setSystemForJob((Job)job);
        job.schedule();
    }

    private void initBindings() {
        WorkbenchJob workbenchJob = new WorkbenchJob("Installing KeybindingsManager"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                KeybindingsManager.this.loadbindings();
                IBindingService bindingService = (IBindingService)KeybindingsManager.this.workbench.getService(IBindingService.class);
                if (bindingService instanceof BindingService) {
                    BindingService theBindingService = (BindingService)bindingService;
                    Display display = PlatformUI.getWorkbench().getDisplay();
                    WorkbenchKeyboard keyboard = theBindingService.getKeyboard();
                    WorkbenchKeyboard.KeyDownFilter keyDownFilter = keyboard.getKeyDownFilter();
                    try {
                        if (keyDownFilter != null) {
                            display.removeFilter(1, (Listener)keyDownFilter);
                            display.removeFilter(31, (Listener)keyDownFilter);
                        }
                        display.addFilter(1, KeybindingsManager.this.listener);
                        display.addFilter(31, KeybindingsManager.this.listener);
                    }
                    finally {
                        if (keyDownFilter != null) {
                            display.addFilter(1, (Listener)keyDownFilter);
                            display.addFilter(31, (Listener)keyDownFilter);
                        }
                    }
                }
                IContextService contextService = (IContextService)KeybindingsManager.this.workbench.getService(IContextService.class);
                contextService.addContextManagerListener(KeybindingsManager.this.contextManagerListener);
                KeybindingsManager.this.setEnabled(contextService.getActiveContextIds().contains("com.aptana.scripting.context"));
                return Status.OK_STATUS;
            }
        };
        workbenchJob.setRule((ISchedulingRule)MUTEX_RULE);
        EclipseUtil.setSystemForJob((Job)workbenchJob);
        workbenchJob.setPriority(30);
        workbenchJob.schedule();
    }

    private void reloadbindings() {
        if (this.workbenchJob == null) {
            this.workbenchJob = new Job("Reloading KeybindingsManager"){

                public IStatus run(IProgressMonitor monitor) {
                    if (monitor != null && monitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    KeybindingsManager.this.loadbindings();
                    return Status.OK_STATUS;
                }

                public boolean shouldRun() {
                    return PlatformUI.isWorkbenchRunning();
                }
            };
            this.workbenchJob.setRule((ISchedulingRule)MUTEX_RULE);
            EclipseUtil.setSystemForJob((Job)this.workbenchJob);
            this.workbenchJob.setPriority(30);
        } else {
            this.workbenchJob.cancel();
        }
        this.workbenchJob.schedule(100L);
    }

    private void loadbindings() {
        this.resetState();
        this.uniqueKeySequences.clear();
        this.uniqueKeySequencesPrefixes.clear();
        IModelFilter filter = new IModelFilter(){

            public boolean include(AbstractElement element) {
                boolean result = false;
                if (element instanceof CommandElement) {
                    CommandElement node = (CommandElement)element;
                    String[] bindings = node.getKeyBindings();
                    result = bindings != null && bindings.length > 0;
                }
                return result;
            }
        };
        List commands = this.bundleManager.getExecutableCommands(filter);
        for (CommandElement commandElement : commands) {
            KeySequence[] keySequences = KeyBindingUtil.getKeySequences(commandElement);
            if (keySequences == null || keySequences.length <= 0) continue;
            KeySequence[] keySequenceArray = keySequences;
            int n = keySequences.length;
            int n2 = 0;
            while (n2 < n) {
                KeySequence keySequence = keySequenceArray[n2];
                boolean added = this.uniqueKeySequences.add(keySequence);
                if (added && keySequence.getKeyStrokes().length > 1) {
                    TriggerSequence[] prefixes;
                    TriggerSequence[] triggerSequenceArray = prefixes = keySequence.getPrefixes();
                    int n3 = prefixes.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        TriggerSequence triggerSequence = triggerSequenceArray[n4];
                        KeySequence prefixKeySequence = (KeySequence)triggerSequence;
                        if (prefixKeySequence.getKeyStrokes().length > 0) {
                            this.uniqueKeySequencesPrefixes.add(prefixKeySequence);
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
    }

    private void setEnabled(boolean enabled) {
        if (this.enabled == enabled) {
            return;
        }
        this.enabled = enabled;
        if (!enabled) {
            this.resetState();
        }
    }

    private void processKeyStrokes(Event event, List keyStrokes) {
        boolean consume = false;
        if (keyStrokes.size() > 0) {
            consume = this.processKeyStroke(event, (KeyStroke)keyStrokes.get(0));
        }
        if (consume) {
            this.consumeEvent(event);
        }
    }

    private void consumeEvent(Event event) {
        switch (event.type) {
            case 1: {
                event.doit = false;
                break;
            }
            case 31: {
                event.detail = 0;
                event.doit = true;
            }
        }
        event.type = 0;
    }

    private boolean processKeyStroke(Event event, KeyStroke keyStroke) {
        IBindingService bindingService = (IBindingService)this.workbench.getService(IBindingService.class);
        KeySequence sequenceBeforeKeyStroke = this.state.getCurrentSequence();
        KeySequence sequenceAfterKeyStroke = KeySequence.getInstance((KeySequence)sequenceBeforeKeyStroke, (KeyStroke)keyStroke);
        if (this.uniqueKeySequences.contains(sequenceAfterKeyStroke)) {
            IEvaluationService evaluationService = (IEvaluationService)this.workbench.getService(IEvaluationService.class);
            IEvaluationContext evaluationContext = evaluationService.getCurrentState();
            IWorkbenchPart workbenchPart = (IWorkbenchPart)evaluationContext.getVariable("activePart");
            ICommandElementsProvider commandElementsProvider = (ICommandElementsProvider)workbenchPart.getAdapter(ICommandElementsProvider.class);
            if (commandElementsProvider != null) {
                List<CommandElement> commandElements;
                Binding binding = null;
                if (bindingService.isPerfectMatch((TriggerSequence)sequenceAfterKeyStroke)) {
                    binding = bindingService.getPerfectMatch((TriggerSequence)sequenceAfterKeyStroke);
                }
                if ((commandElements = commandElementsProvider.getCommandElements(sequenceAfterKeyStroke)).size() == 0) {
                    if (binding == null) {
                        this.incrementState(sequenceAfterKeyStroke);
                    } else {
                        this.resetState();
                    }
                    return false;
                }
                if (binding != null && "hbuilder.accelerator".equals(binding.getSchemeId()) && this.isBindingEnable(binding)) {
                    try {
                        this.executeCommand(binding, event);
                    }
                    catch (CommandException e) {
                        e.printStackTrace();
                    }
                } else if (commandElements.size() == 1) {
                    this.executeCommandElement(commandElementsProvider, commandElements.get(0));
                } else {
                    IContextService contextService = (IContextService)this.workbench.getService(IContextService.class);
                    this.popup(workbenchPart.getSite().getShell(), bindingService, contextService, commandElementsProvider, commandElements, event, binding, this.getInitialLocation(commandElementsProvider));
                }
                this.resetState();
                return true;
            }
        } else if (this.uniqueKeySequencesPrefixes.contains(sequenceAfterKeyStroke)) {
            if (bindingService.isPerfectMatch((TriggerSequence)sequenceAfterKeyStroke)) {
                this.resetState();
            } else {
                this.incrementState(sequenceAfterKeyStroke);
            }
        } else {
            Collection match = bindingService.getConflictsFor((TriggerSequence)sequenceAfterKeyStroke);
            if (match != null) {
                for (Binding binding : match) {
                    if (!binding.getParameterizedCommand().getId().contains(".ruby.") || !this.isBindingEnable(binding)) continue;
                    try {
                        this.executeCommand(binding, event);
                    }
                    catch (CommandException e) {
                        e.printStackTrace();
                    }
                    this.resetState();
                    return true;
                }
            }
            this.resetState();
        }
        return false;
    }

    private void checkActiveWindow(IWorkbenchWindow window) {
        if (!window.equals(this.state.getAssociatedWindow())) {
            this.resetState();
            this.state.setAssociatedWindow(window);
        }
    }

    private void incrementState(KeySequence sequence) {
        this.state.setCurrentSequence(sequence);
        this.state.setAssociatedWindow(this.workbench.getActiveWorkbenchWindow());
    }

    private void resetState() {
        this.state.reset();
    }

    private void popup(final Shell shell, final IBindingService bindingService, final IContextService contextService, final ICommandElementsProvider commandElementsProvider, final List<CommandElement> commandElements, final Event event, final Binding binding, final Point initialLocation) {
        PopupDialog popupDialog = new PopupDialog(shell, 4, true, false, false, false, false, null, null){

            protected Point getInitialLocation(Point initialSize) {
                Display display = shell.getDisplay();
                Point cursorLocation = display.getCursorLocation();
                if (initialLocation != null) {
                    return initialLocation;
                }
                return cursorLocation;
            }

            protected Control createDialogArea(Composite parent) {
                ParameterizedCommand originalParameterizedCommand;
                this.registerShellType();
                Composite composite = new Composite(parent, 0);
                GridLayout compositeLayout = new GridLayout();
                compositeLayout.marginHeight = 1;
                compositeLayout.marginWidth = 1;
                composite.setLayout((Layout)compositeLayout);
                composite.setLayoutData((Object)new GridData(1808));
                final Table commandElementTable = new Table(composite, 65556);
                GridData gridData = new GridData(1808);
                commandElementTable.setLayoutData((Object)gridData);
                commandElementTable.setLinesVisible(true);
                TableColumn columnCommandName = new TableColumn(commandElementTable, 16384, 0);
                TableColumn columnAccelerator = new TableColumn(commandElementTable, 0x1000000, 1);
                int mnemonic = 0;
                for (CommandElement commandElement : commandElements) {
                    String[] text = new String[]{commandElement.getDisplayName(), mnemonic < KeybindingsManager.MNEMONICS.length() ? String.valueOf(KeybindingsManager.MNEMONICS.charAt(mnemonic++)) : ""};
                    TableItem item = new TableItem(commandElementTable, 0);
                    item.setText(text);
                    item.setData(CommandElement.class.getName(), (Object)commandElement);
                }
                if (binding != null && (originalParameterizedCommand = binding.getParameterizedCommand()) != null) {
                    try {
                        String name = originalParameterizedCommand.getName();
                        TableItem item = new TableItem(commandElementTable, 0);
                        item.setText(new String[]{name, mnemonic < KeybindingsManager.MNEMONICS.length() ? String.valueOf(KeybindingsManager.MNEMONICS.charAt(mnemonic++)) : ""});
                        item.setData(ParameterizedCommand.class.getName(), (Object)originalParameterizedCommand);
                    }
                    catch (NotDefinedException nde) {
                        IdeLog.logError((Plugin)ScriptingActivator.getDefault(), (String)nde.getMessage(), (Throwable)nde);
                    }
                }
                Dialog.applyDialogFont((Control)parent);
                columnAccelerator.pack();
                columnCommandName.pack();
                columnAccelerator.setWidth(columnAccelerator.getWidth() * 4);
                commandElementTable.addListener(14, new Listener(){

                    public final void handleEvent(Event event) {
                        Object commandElement = null;
                        Object parameterizedCommand = null;
                        TableItem[] selection = commandElementTable.getSelection();
                        if (selection.length > 0) {
                            commandElement = selection[0].getData(CommandElement.class.getName());
                            parameterizedCommand = selection[0].getData(ParameterizedCommand.class.getName());
                        }
                        this.close();
                        if (commandElement instanceof CommandElement) {
                            KeybindingsManager.this.executeCommandElement(commandElementsProvider, (CommandElement)commandElement);
                        } else if (parameterizedCommand instanceof ParameterizedCommand) {
                            try {
                                KeybindingsManager.this.executeCommand(binding, event);
                            }
                            catch (CommandException e) {
                                IdeLog.logError((Plugin)ScriptingActivator.getDefault(), (String)e.getMessage(), (Throwable)e);
                            }
                        }
                    }
                });
                commandElementTable.addKeyListener(new KeyListener(){

                    public void keyReleased(KeyEvent e) {
                    }

                    public void keyPressed(KeyEvent e) {
                        if (!e.doit) {
                            return;
                        }
                        int index = KeybindingsManager.MNEMONICS.indexOf(e.character);
                        if (index != -1 && index < commandElementTable.getItemCount()) {
                            e.doit = false;
                            TableItem tableItem = commandElementTable.getItem(index);
                            Object commandElement = tableItem.getData(CommandElement.class.getName());
                            Object parameterizedCommand = tableItem.getData(ParameterizedCommand.class.getName());
                            this.close();
                            if (commandElement instanceof CommandElement) {
                                KeybindingsManager.this.executeCommandElement(commandElementsProvider, (CommandElement)commandElement);
                            } else if (parameterizedCommand instanceof ParameterizedCommand) {
                                try {
                                    KeybindingsManager.this.executeCommand(binding, event);
                                }
                                catch (CommandException ex) {
                                    IdeLog.logError((Plugin)ScriptingActivator.getDefault(), (String)ex.getMessage(), (Throwable)ex);
                                }
                            }
                        }
                    }
                });
                return composite;
            }

            protected Color getBackground() {
                return this.getShell().getDisplay().getSystemColor(22);
            }

            protected Control createContents(Composite parent) {
                return super.createContents(parent);
            }

            public int open() {
                KeybindingsManager.this.showingCommandsMenu = true;
                bindingService.setKeyFilterEnabled(false);
                return super.open();
            }

            public boolean close() {
                boolean closed = super.close();
                if (closed) {
                    KeybindingsManager.this.showingCommandsMenu = false;
                    bindingService.setKeyFilterEnabled(true);
                }
                return closed;
            }

            private final void registerShellType() {
                Shell shell2 = this.getShell();
                contextService.registerShell(shell2, contextService.getShellType((Shell)shell2.getParent()));
            }
        };
        popupDialog.open();
    }

    private Point getInitialLocation(ICommandElementsProvider commandElementsProvider) {
        Point popupLocation = commandElementsProvider.getCommandElementsPopupLocation();
        if (popupLocation != null) {
            return popupLocation;
        }
        Display display = this.workbench.getDisplay();
        if (display != null) {
            return display.getCursorLocation();
        }
        return null;
    }

    private void executeCommandElement(ICommandElementsProvider commandElementsProvider, CommandElement commandElement) {
        commandElementsProvider.execute(commandElement);
    }

    private boolean isBindingEnable(Binding binding) {
        ParameterizedCommand parameterizedCommand = binding.getParameterizedCommand();
        IHandlerService handlerService = (IHandlerService)this.workbench.getService(IHandlerService.class);
        Command command = parameterizedCommand.getCommand();
        command.setEnabled((Object)handlerService.getCurrentState());
        return command.isEnabled();
    }

    final void executeCommand(Binding binding, Event trigger) throws CommandException {
        ParameterizedCommand parameterizedCommand = binding.getParameterizedCommand();
        IHandlerService handlerService = (IHandlerService)this.workbench.getService(IHandlerService.class);
        Command command = parameterizedCommand.getCommand();
        command.setEnabled((Object)handlerService.getCurrentState());
        try {
            handlerService.executeCommand(parameterizedCommand, trigger);
        }
        catch (NotDefinedException notDefinedException) {
        }
        catch (NotEnabledException notEnabledException) {
        }
        catch (NotHandledException notHandledException) {}
    }

    public void scriptLoaded(File script) {
        this.reloadbindings();
    }

    public void scriptReloaded(File script) {
        this.reloadbindings();
    }

    public void scriptUnloaded(File script) {
        this.reloadbindings();
    }

    private static class MutexRule
    implements ISchedulingRule {
        private MutexRule() {
        }

        public boolean isConflicting(ISchedulingRule rule) {
            return rule == this;
        }

        public boolean contains(ISchedulingRule rule) {
            return rule == this;
        }
    }
}

