/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ui.io.compare;

import com.aptana.ui.io.compare.FileStoreNode;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.internal.BufferedResourceNode;
import org.eclipse.compare.internal.Utilities;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.compare.structuremergeviewer.DiffTreeViewer;
import org.eclipse.compare.structuremergeviewer.Differencer;
import org.eclipse.compare.structuremergeviewer.IDiffContainer;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;

public class FileStoreCompareEditorInput
extends CompareEditorInput {
    private Object fRoot;
    private FileStoreNode fLeft;
    private FileStoreNode fRight;
    private IFileStore fLeftFileStore;
    private IFileStore fRightFileStore;
    private DiffTreeViewer fDiffViewer;
    private IAction fOpenAction;

    public FileStoreCompareEditorInput(CompareConfiguration config) {
        super(config);
    }

    public Viewer createDiffViewer(Composite parent) {
        this.fDiffViewer = new DiffTreeViewer(parent, this.getCompareConfiguration()){

            protected void fillContextMenu(IMenuManager manager) {
                IStructuredSelection ss;
                if (FileStoreCompareEditorInput.this.fOpenAction == null) {
                    FileStoreCompareEditorInput.this.fOpenAction = (IAction)new Action(){

                        public void run() {
                            this.handleOpen(null);
                        }
                    };
                    Utilities.initAction((IAction)FileStoreCompareEditorInput.this.fOpenAction, (ResourceBundle)this.getBundle(), (String)"action.CompareContents.");
                }
                boolean enable = false;
                ISelection selection = this.getSelection();
                if (selection instanceof IStructuredSelection && (ss = (IStructuredSelection)selection).size() == 1) {
                    Object element = ss.getFirstElement();
                    if (element instanceof MyDiffNode) {
                        ITypedElement typedElement = ((MyDiffNode)((Object)element)).getId();
                        if (typedElement != null) {
                            enable = !"FOLDER".equals(typedElement.getType());
                        }
                    } else {
                        enable = true;
                    }
                }
                FileStoreCompareEditorInput.this.fOpenAction.setEnabled(enable);
                manager.add(FileStoreCompareEditorInput.this.fOpenAction);
                super.fillContextMenu(manager);
            }
        };
        return this.fDiffViewer;
    }

    public void setLeftFileStore(IFileStore fileStore) {
        this.setLeftFileStore(fileStore, null);
    }

    public void setLeftFileStore(IFileStore fileStore, String name) {
        this.fLeftFileStore = fileStore;
        this.fLeft = new FileStoreNode(this.fLeftFileStore, name);
    }

    public void setRightFileStore(IFileStore fileStore) {
        this.setRightFileStore(fileStore, null);
    }

    public void setRightFileStore(IFileStore fileStore, String name) {
        this.fRightFileStore = fileStore;
        this.fRight = new FileStoreNode(this.fRightFileStore, name);
    }

    public void initializeCompareConfiguration() {
        CompareConfiguration cc = this.getCompareConfiguration();
        if (this.fLeft != null) {
            cc.setLeftLabel(this.fLeft.getName());
            cc.setLeftImage(this.fLeft.getImage());
        }
        if (this.fRight != null) {
            cc.setRightLabel(this.fRight.getName());
            cc.setRightImage(this.fRight.getImage());
        }
    }

    protected void prepareFiles() {
    }

    public Object prepareInput(IProgressMonitor pm) throws InvocationTargetException {
        try {
            pm.beginTask(Utilities.getString((String)"ResourceCompare.taskName"), -1);
            this.prepareFiles();
            String leftLabel = this.fLeft.getName();
            String rightLabel = this.fRight.getName();
            String format = Utilities.getString((String)"ResourceCompare.twoWay.title");
            String title = MessageFormat.format(format, leftLabel, rightLabel);
            this.setTitle(title);
            Differencer d = new Differencer(){

                protected Object visit(Object parent, int description, Object ancestor, Object left, Object right) {
                    return new MyDiffNode((IDiffContainer)parent, description, (ITypedElement)ancestor, (ITypedElement)left, (ITypedElement)right);
                }
            };
            Object object = this.fRoot = d.findDifferences(false, pm, null, null, (Object)this.fLeft, (Object)this.fRight);
            return object;
        }
        finally {
            pm.done();
        }
    }

    public String getToolTipText() {
        if (this.fLeftFileStore != null && this.fRightFileStore != null) {
            String leftLabel = this.fLeftFileStore.toString();
            String rightLabel = this.fRightFileStore.toString();
            String format = Utilities.getString((String)"ResourceCompare.twoWay.tooltip");
            return MessageFormat.format(format, leftLabel, rightLabel);
        }
        return super.getToolTipText();
    }

    public void saveChanges(IProgressMonitor pm) throws CoreException {
        super.saveChanges(pm);
        if (this.fRoot instanceof DiffNode) {
            try {
                FileStoreCompareEditorInput.commit(pm, (DiffNode)this.fRoot);
            }
            finally {
                if (this.fDiffViewer != null) {
                    this.fDiffViewer.refresh();
                }
                this.setDirty(false);
            }
        }
    }

    private static void commit(IProgressMonitor pm, DiffNode node) throws CoreException {
        IDiffElement[] children;
        ITypedElement right;
        ITypedElement left;
        if (node instanceof MyDiffNode) {
            ((MyDiffNode)node).clearDirty();
        }
        if ((left = node.getLeft()) instanceof BufferedResourceNode) {
            ((BufferedResourceNode)left).commit(pm);
        }
        if ((right = node.getRight()) instanceof BufferedResourceNode) {
            ((BufferedResourceNode)right).commit(pm);
        }
        if ((children = node.getChildren()) != null) {
            IDiffElement[] iDiffElementArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IDiffElement element = iDiffElementArray[n2];
                if (element instanceof DiffNode) {
                    FileStoreCompareEditorInput.commit(pm, (DiffNode)element);
                }
                ++n2;
            }
        }
    }

    class MyDiffNode
    extends DiffNode {
        private boolean fDirty;
        private ITypedElement fLastId;
        private String fLastName;

        protected MyDiffNode(IDiffContainer parent, int description, ITypedElement ancestor, ITypedElement left, ITypedElement right) {
            super(parent, description, ancestor, left, right);
            this.fDirty = false;
        }

        public void fireChange() {
            super.fireChange();
            FileStoreCompareEditorInput.this.setDirty(true);
            this.fDirty = true;
            if (FileStoreCompareEditorInput.this.fDiffViewer != null) {
                FileStoreCompareEditorInput.this.fDiffViewer.refresh((Object)this);
            }
        }

        void clearDirty() {
            this.fDirty = false;
        }

        public String getName() {
            if (this.fLastName == null) {
                this.fLastName = super.getName();
            }
            if (this.fDirty) {
                return MessageFormat.format("<{0}>", this.fLastName);
            }
            return this.fLastName;
        }

        public ITypedElement getId() {
            ITypedElement id = super.getId();
            if (id == null) {
                return this.fLastId;
            }
            this.fLastId = id;
            return id;
        }
    }
}

