/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.ui.io.navigator.actions;

import com.aptana.core.util.ArrayUtil;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.editor.common.internal.scripting.NewTemplateFileWizard;
import com.aptana.ide.ui.io.navigator.actions.Messages;
import com.aptana.ide.ui.io.navigator.actions.NewFileAction;
import com.aptana.scripting.model.AbstractElement;
import com.aptana.scripting.model.BundleManager;
import com.aptana.scripting.model.BundlePrecedence;
import com.aptana.scripting.model.CommandElement;
import com.aptana.scripting.model.TemplateElement;
import com.aptana.scripting.model.filters.IModelFilter;
import com.aptana.ui.util.UIUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeMatcher;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IFileEditorMapping;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.ui.services.IEvaluationService;
import org.eclipse.ui.wizards.newresource.BasicNewFileResourceWizard;

public class NewFileTemplateMenuContributor
extends ContributionItem {
    private static final String[] APTANA_EDITOR_PREFIX = new String[]{"com.aptana.editor.", "org.python.pydev.editor."};
    private static final Set<String> FILTERED_EDITORS = CollectionsUtil.newSet((Object[])new String[]{"com.aptana.editor.dtd", "com.aptana.editor.svg"});
    private static Map<String, String> aptanaEditors;
    private static String[] fileTypes;

    static {
        fileTypes = new String[]{"CSS", "HTML", "JavaScript", "XML"};
    }

    public NewFileTemplateMenuContributor() {
    }

    public NewFileTemplateMenuContributor(String id) {
        super(id);
    }

    public boolean isDynamic() {
        return true;
    }

    public void fill(Menu menu, int index) {
        if (aptanaEditors == null) {
            aptanaEditors = NewFileTemplateMenuContributor.getAptanaEditorFiletypeMap();
        }
        ArrayList<String> editors = new ArrayList<String>(aptanaEditors.keySet());
        this.sortEditors(editors);
        Map<String, List<TemplateElement>> templatesByBundle = this.getNewFileTemplates();
        for (String filetype : editors) {
            boolean hasTemplates;
            if (this.inFilterType(filetype)) continue;
            List<TemplateElement> templates = templatesByBundle.get(filetype);
            boolean bl = hasTemplates = !CollectionsUtil.isEmpty(templates);
            if (hasTemplates) {
                this.sortTempaltes(templates);
                boolean userLevel = true;
                int size = templates.size();
                int i = 0;
                while (i < size) {
                    TemplateElement template = templates.get(i);
                    if (userLevel && template.getOwningBundle().getBundlePrecedence() != BundlePrecedence.USER) {
                        userLevel = false;
                        if (i > 0) {
                            new MenuItem(menu, 2);
                        }
                    }
                    MenuItem templateItem = new MenuItem(menu, 8);
                    templateItem.setText(template.getDisplayName());
                    this.addSelectedListener(template, templateItem);
                    ++i;
                }
            }
            this.createBlankFileMenu(menu, templates, filetype);
            new MenuItem(menu, 2);
        }
    }

    protected String createBlankFileMenu(Menu menu, List<TemplateElement> templates, String filetype) {
        String fileExtension;
        if (templates != null && templates.size() > 0) {
            fileExtension = templates.get(0).getFiletype();
            int dotIndex = fileExtension.lastIndexOf(46);
            if (dotIndex > -1) {
                fileExtension = fileExtension.substring(dotIndex + 1);
            }
        } else {
            fileExtension = aptanaEditors.get(filetype);
        }
        this.createBlankFileMenu(menu, filetype, fileExtension);
        return fileExtension;
    }

    protected void addSelectedListener(final TemplateElement template, MenuItem templateItem) {
        templateItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewFileTemplateMenuContributor.this.createNewFileFromTemplate(template);
            }
        });
    }

    protected void sortEditors(List<String> editors) {
        Collections.sort(editors, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareToIgnoreCase(o2);
            }
        });
    }

    protected void sortTempaltes(List<TemplateElement> templates) {
        Collections.sort(templates, new Comparator<TemplateElement>(){

            @Override
            public int compare(TemplateElement e1, TemplateElement e2) {
                BundlePrecedence p1 = e1.getOwningBundle().getBundlePrecedence();
                BundlePrecedence p2 = e2.getOwningBundle().getBundlePrecedence();
                return p1.compareTo((Enum)p2);
            }
        });
    }

    private boolean inFilterType(String filetype) {
        String[] stringArray = fileTypes;
        int n = fileTypes.length;
        int n2 = 0;
        while (n2 < n) {
            String type = stringArray[n2];
            if (type.equals(filetype)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private MenuItem createBlankFileMenu(Menu parent, final String editorType, final String fileExtension) {
        MenuItem item = new MenuItem(parent, 8);
        item.setText(String.valueOf(editorType) + " " + Messages.NewFileTemplateMenuContributor_LBL_BlankFile);
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewFileTemplateMenuContributor.this.createNewBlankFile(editorType, fileExtension);
            }
        });
        return item;
    }

    protected void createNewFileFromTemplate(TemplateElement template) {
        IFileStore fileStore;
        Object element;
        IStructuredSelection selection = NewFileTemplateMenuContributor.getActiveSelection();
        if (!selection.isEmpty() && (element = selection.getFirstElement()) instanceof IAdaptable && (fileStore = (IFileStore)((IAdaptable)element).getAdapter(IFileStore.class)) != null) {
            String filetype = template.getFiletype();
            int index = filetype.lastIndexOf(46);
            if (index > -1) {
                filetype = filetype.substring(index);
            }
            NewFileAction action = new NewFileAction("new_file" + filetype, template);
            action.updateSelection(selection);
            action.run();
            return;
        }
        NewTemplateFileWizard wizard = new NewTemplateFileWizard(template);
        wizard.init(PlatformUI.getWorkbench(), selection);
        WizardDialog dialog = new WizardDialog(UIUtils.getActiveShell(), (IWizard)wizard);
        dialog.open();
    }

    protected void createNewBlankFile(String editorType, String fileExtension) {
        IFileStore fileStore;
        Object element;
        final String initialFileName = "new_file." + fileExtension;
        IStructuredSelection selection = NewFileTemplateMenuContributor.getActiveSelection();
        if (!selection.isEmpty() && (element = selection.getFirstElement()) instanceof IAdaptable && (fileStore = (IFileStore)((IAdaptable)element).getAdapter(IFileStore.class)) != null) {
            NewFileAction action = new NewFileAction(initialFileName){

                @Override
                protected InputStream getInitialContents() {
                    return new ByteArrayInputStream(ArrayUtil.NO_BYTES);
                }
            };
            action.updateSelection(selection);
            action.run();
            return;
        }
        BasicNewFileResourceWizard wizard = new BasicNewFileResourceWizard(){

            public void addPages() {
                super.addPages();
                ((WizardNewFileCreationPage)this.getPages()[0]).setFileName(initialFileName);
            }
        };
        wizard.init(PlatformUI.getWorkbench(), selection);
        WizardDialog dialog = new WizardDialog(UIUtils.getActiveShell(), (IWizard)wizard);
        dialog.open();
    }

    private static Map<String, String> getAptanaEditorFiletypeMap() {
        TreeMap<String, String> editorMap = new TreeMap<String, String>();
        IFileEditorMapping[] mappings = NewFileTemplateMenuContributor.getFileEditorMappings();
        IContentTypeMatcher matcher = NewFileTemplateMenuContributor.getContentTypeMatcher();
        IFileEditorMapping[] iFileEditorMappingArray = mappings;
        int n = mappings.length;
        int n2 = 0;
        while (n2 < n) {
            IFileEditorMapping mapping = iFileEditorMappingArray[n2];
            IEditorDescriptor[] editors = mapping.getEditors();
            String extension = NewFileTemplateMenuContributor.getExtension(matcher, mapping);
            IEditorDescriptor[] iEditorDescriptorArray = editors;
            int n3 = editors.length;
            int n4 = 0;
            while (n4 < n3) {
                IEditorDescriptor editor = iEditorDescriptorArray[n4];
                String editorId = editor.getId();
                if (!FILTERED_EDITORS.contains(editorId)) {
                    String[] stringArray = APTANA_EDITOR_PREFIX;
                    int n5 = APTANA_EDITOR_PREFIX.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        String prefix = stringArray[n6];
                        if (editorId.startsWith(prefix)) {
                            String name = editor.getLabel();
                            if (editorMap.containsKey(name = new StringTokenizer(name).nextToken())) break;
                            editorMap.put(name, extension);
                            break;
                        }
                        ++n6;
                    }
                }
                ++n4;
            }
            ++n2;
        }
        return editorMap;
    }

    protected static String getExtension(IContentTypeMatcher matcher, IFileEditorMapping mapping) {
        Object[] extensions;
        IContentType type;
        String extension = mapping.getExtension();
        if (matcher != null && (type = matcher.findContentTypeFor("new_file." + extension)) != null && !ArrayUtil.isEmpty((Object[])(extensions = type.getFileSpecs(8)))) {
            return extensions[0];
        }
        return extension;
    }

    protected static IFileEditorMapping[] getFileEditorMappings() {
        return PlatformUI.getWorkbench().getEditorRegistry().getFileEditorMappings();
    }

    protected static IContentTypeMatcher getContentTypeMatcher() {
        Object[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        if (!ArrayUtil.isEmpty((Object[])projects)) {
            try {
                return projects[0].getContentTypeMatcher();
            }
            catch (CoreException coreException) {}
        }
        return null;
    }

    private static IStructuredSelection getActiveSelection() {
        IEvaluationContext currentState;
        Object variable;
        IStructuredSelection selection = null;
        IEvaluationService evaluationService = (IEvaluationService)PlatformUI.getWorkbench().getService(IEvaluationService.class);
        if (evaluationService != null && (variable = (currentState = evaluationService.getCurrentState()).getVariable("selection")) instanceof IStructuredSelection) {
            selection = (IStructuredSelection)variable;
        }
        return selection == null ? StructuredSelection.EMPTY : selection;
    }

    private Map<String, List<TemplateElement>> getNewFileTemplates() {
        List commands = this.getBundleManager().getExecutableCommands(new IModelFilter(){

            public boolean include(AbstractElement element) {
                if (element instanceof TemplateElement) {
                    TemplateElement te = (TemplateElement)element;
                    return te.getFiletype() != null && te.getOwningBundle() != null;
                }
                return false;
            }
        });
        if (CollectionsUtil.isEmpty((Collection)commands)) {
            return Collections.emptyMap();
        }
        TreeMap<String, List<TemplateElement>> templatesByBundle = new TreeMap<String, List<TemplateElement>>();
        for (CommandElement command : commands) {
            String bundleName = command.getOwningBundle().getDisplayName();
            ArrayList<TemplateElement> templates = (ArrayList<TemplateElement>)templatesByBundle.get(bundleName);
            if (templates == null) {
                templates = new ArrayList<TemplateElement>(1);
                templatesByBundle.put(bundleName, templates);
            }
            templates.add((TemplateElement)command);
        }
        return templatesByBundle;
    }

    protected BundleManager getBundleManager() {
        return BundleManager.getInstance();
    }
}

