/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.ui.io.navigator;

import com.aptana.core.util.ArrayUtil;
import com.aptana.ide.core.io.CoreIOPlugin;
import com.aptana.ide.ui.io.navigator.FileTreeContentProvider;
import com.aptana.ide.ui.io.navigator.LocalFileSystems;
import com.aptana.ui.util.UIUtils;
import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.viewers.Viewer;

public class ProjectExplorerContentProvider
extends FileTreeContentProvider {
    private static final String LOCAL_SHORTCUTS_ID = "com.aptana.ide.core.io.localShortcuts";
    private Viewer treeViewer;
    private IResourceChangeListener resourceListener = new IResourceChangeListener(){

        public void resourceChanged(IResourceChangeEvent event) {
            if (ProjectExplorerContentProvider.this.shouldUpdateActions(event.getDelta())) {
                UIUtils.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ProjectExplorerContentProvider.this.treeViewer.setSelection(ProjectExplorerContentProvider.this.treeViewer.getSelection());
                    }
                });
            }
        }
    };

    public ProjectExplorerContentProvider() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourceListener, 1);
    }

    @Override
    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.resourceListener);
        super.dispose();
    }

    @Override
    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof IResource) {
            return ArrayUtil.NO_OBJECTS;
        }
        return super.getChildren(parentElement);
    }

    @Override
    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof IWorkspaceRoot) {
            ArrayList<LocalFileSystems> children = new ArrayList<LocalFileSystems>();
            children.add(LocalFileSystems.getInstance());
            children.add((LocalFileSystems)CoreIOPlugin.getConnectionPointManager().getConnectionPointCategory(LOCAL_SHORTCUTS_ID));
            return children.toArray(new Object[children.size()]);
        }
        return super.getElements(inputElement);
    }

    @Override
    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.treeViewer = viewer;
        super.inputChanged(viewer, oldInput, newInput);
    }

    private boolean shouldUpdateActions(IResourceDelta delta) {
        IResourceDelta[] children;
        if (delta.getFlags() == 16384) {
            return true;
        }
        IResourceDelta[] iResourceDeltaArray = children = delta.getAffectedChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IResourceDelta child = iResourceDeltaArray[n2];
            if (this.shouldUpdateActions(child)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

