/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.ui.io.navigator;

import com.aptana.core.util.EclipseUtil;
import com.aptana.ide.ui.io.CoreIOImages;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IDeferredWorkbenchAdapter;
import org.eclipse.ui.progress.IElementCollector;
import org.eclipse.ui.progress.PendingUpdateAdapter;
import org.eclipse.ui.progress.WorkbenchJob;

public class DeferredTreeContentManager
extends org.eclipse.ui.progress.DeferredTreeContentManager {
    private AbstractTreeViewer treeViewer;

    public DeferredTreeContentManager(AbstractTreeViewer viewer) {
        super(viewer);
        this.treeViewer = viewer;
    }

    public DeferredTreeContentManager(AbstractTreeViewer viewer, IWorkbenchPartSite site) {
        super(viewer, site);
    }

    protected PendingUpdateAdapter createPendingUpdateAdapter() {
        return new CustomPendingUpdateAdapter();
    }

    protected IElementCollector createElementCollector(Object parent, PendingUpdateAdapter placeholder) {
        if (placeholder instanceof CustomPendingUpdateAdapter) {
            ((CustomPendingUpdateAdapter)placeholder).parent = parent;
        }
        return super.createElementCollector(parent, placeholder);
    }

    protected void runClearPlaceholderJob(final PendingUpdateAdapter placeholder) {
        super.runClearPlaceholderJob(placeholder);
        if (!PlatformUI.isWorkbenchRunning() || !(placeholder instanceof CustomPendingUpdateAdapter)) {
            return;
        }
        WorkbenchJob parentUpdateJob = new WorkbenchJob("Rerent Update"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                Control control = DeferredTreeContentManager.this.treeViewer.getControl();
                if (control.isDisposed()) {
                    return Status.CANCEL_STATUS;
                }
                DeferredTreeContentManager.this.treeViewer.update(((CustomPendingUpdateAdapter)placeholder).parent, null);
                return Status.OK_STATUS;
            }
        };
        EclipseUtil.setSystemForJob((Job)parentUpdateJob);
        parentUpdateJob.schedule();
    }

    protected String getFetchJobName(Object parent, IDeferredWorkbenchAdapter adapter) {
        return super.getFetchJobName(parent, adapter);
    }

    private static class CustomPendingUpdateAdapter
    extends PendingUpdateAdapter {
        protected Object parent;

        private CustomPendingUpdateAdapter() {
        }

        public ImageDescriptor getImageDescriptor(Object object) {
            return CoreIOImages.getImageDescriptor("IMG_OBJS_PENDING");
        }

        public Object getParent(Object o) {
            if (((Object)((Object)this)).equals(o)) {
                return this.parent;
            }
            return super.getParent(o);
        }
    }
}

