/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.ui.io.actions;

import com.aptana.ide.ui.io.FileSystemUtils;
import java.io.File;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.ui.IActionFilter;

public class FileSystemActionFilter
implements IActionFilter {
    public boolean testAttribute(Object target, String name, String value) {
        if (target instanceof IAdaptable) {
            if ("isLocal".equals(name)) {
                return ((IAdaptable)target).getAdapter(File.class) != null == FileSystemActionFilter.toBoolean(value);
            }
            if ("isWorkspace".equals(name)) {
                return ((IAdaptable)target).getAdapter(IResource.class) != null == FileSystemActionFilter.toBoolean(value);
            }
            if ("isFolder".equals(name)) {
                return FileSystemUtils.isDirectory(target) == FileSystemActionFilter.toBoolean(value);
            }
            if ("isSymlink".equals(name)) {
                return FileSystemUtils.isSymlink(target) == FileSystemActionFilter.toBoolean(value);
            }
            if ("isPrivate".equals(name)) {
                return FileSystemUtils.isPrivate(target) == FileSystemActionFilter.toBoolean(value);
            }
        }
        return false;
    }

    private static boolean toBoolean(Object value) {
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            return Boolean.parseBoolean((String)value);
        }
        return false;
    }

    public static class Factory
    implements IAdapterFactory {
        public Object getAdapter(Object adaptableObject, Class adapterType) {
            if (IActionFilter.class.equals((Object)adapterType)) {
                return new FileSystemActionFilter();
            }
            if (IFileStore.class.equals((Object)adapterType)) {
                return ((IAdaptable)adaptableObject).getAdapter(adapterType);
            }
            return null;
        }

        public Class[] getAdapterList() {
            return new Class[]{IActionFilter.class, IFileStore.class};
        }
    }
}

