/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.ui.io.actions;

import com.aptana.core.io.efs.SyncUtils;
import com.aptana.core.io.vfs.IExtendedFileStore;
import com.aptana.core.logging.IdeLog;
import com.aptana.ide.core.io.preferences.CloakingUtils;
import com.aptana.ide.ui.io.IOUIPlugin;
import com.aptana.ide.ui.io.Utils;
import com.aptana.ide.ui.io.actions.Messages;
import com.aptana.ui.util.UIUtils;
import java.net.URI;
import java.text.MessageFormat;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public class CopyFilesOperation {
    private Shell fShell;
    private boolean fCancelled;
    private OverwriteStatus overwriteStatus;
    private boolean showSourceOfOverwrite = true;

    public CopyFilesOperation(Shell shell) {
        this.fShell = shell == null ? UIUtils.getActiveShell() : shell;
    }

    public void setShowSourceOfOverwrite(boolean showSourceOfOverwrite) {
        this.showSourceOfOverwrite = showSourceOfOverwrite;
    }

    public void copyFiles(IAdaptable[] sources, IFileStore destination, IJobChangeListener listener) {
        IFileStore[] fileStores = new IFileStore[sources.length];
        int i = 0;
        while (i < fileStores.length) {
            fileStores[i] = Utils.getFileStore(sources[i]);
            ++i;
        }
        this.copyFiles(fileStores, destination, listener);
    }

    public void copyFiles(String[] filenames, IFileStore destination, IJobChangeListener listener) {
        this.copyFiles(CopyFilesOperation.getFileStores(filenames), destination, listener);
    }

    public IStatus copyFiles(IFileStore[] sources, IFileStore destination, IProgressMonitor monitor) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        int successCount = 0;
        IFileStore[] iFileStoreArray = sources;
        int n = sources.length;
        int n2 = 0;
        while (n2 < n) {
            IFileStore source = iFileStoreArray[n2];
            if (this.copyFile(source, destination.getChild(source.getName()), monitor)) {
                ++successCount;
            }
            if (this.fCancelled || monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            ++n2;
        }
        return new Status(0, "com.aptana.ui.io", successCount, Messages.CopyFilesOperation_Status_OK, null);
    }

    public void copyFiles(IAdaptable[] sources, IFileStore sourceRoot, IFileStore destinationRoot, IJobChangeListener listener) {
        IFileStore[] fileStores = new IFileStore[sources.length];
        int i = 0;
        while (i < fileStores.length) {
            fileStores[i] = Utils.getFileStore(sources[i]);
            ++i;
        }
        this.copyFiles(fileStores, sourceRoot, destinationRoot, listener);
    }

    public void copyFiles(String[] filenames, IFileStore sourceRoot, IFileStore destinationRoot, IJobChangeListener listener) {
        this.copyFiles(CopyFilesOperation.getFileStores(filenames), sourceRoot, destinationRoot, listener);
    }

    public IStatus copyFiles(IFileStore[] sources, IFileStore sourceRoot, IFileStore destinationRoot, IProgressMonitor monitor) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        int successCount = 0;
        IFileStore[] iFileStoreArray = sources;
        int n = sources.length;
        int n2 = 0;
        while (n2 < n) {
            IFileStore source = iFileStoreArray[n2];
            if (this.copyFile(source, sourceRoot, destinationRoot, monitor)) {
                ++successCount;
            }
            if (this.fCancelled || monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            ++n2;
        }
        return new Status(0, "com.aptana.ui.io", successCount, Messages.CopyFilesOperation_Status_OK, null);
    }

    public static String validateDestination(IAdaptable destination, IAdaptable[] sources) {
        IFileStore[] sourceStores = new IFileStore[sources.length];
        int i = 0;
        while (i < sourceStores.length) {
            sourceStores[i] = Utils.getFileStore(sources[i]);
            ++i;
        }
        return CopyFilesOperation.validateDestination(destination, sourceStores);
    }

    public static String validateDestination(IAdaptable destination, String[] sourceNames) {
        return CopyFilesOperation.validateDestination(destination, CopyFilesOperation.getFileStores(sourceNames));
    }

    protected boolean copyFile(IFileStore sourceStore, IFileStore destinationStore, IProgressMonitor monitor) {
        IFileStore[] childStores;
        boolean success;
        block10: {
            if (sourceStore == null || CloakingUtils.isFileCloaked((IFileStore)sourceStore)) {
                return false;
            }
            success = true;
            monitor.subTask(MessageFormat.format(Messages.CopyFilesOperation_Copy_Subtask, sourceStore.getName(), destinationStore.getName()));
            if (destinationStore.equals(sourceStore) && (destinationStore = this.getNewNameFor(destinationStore)) == null) {
                return false;
            }
            boolean isDirectory = Utils.isDirectory((IAdaptable)sourceStore);
            IFileStore[] iFileStoreArray = childStores = isDirectory ? sourceStore.childStores(0, monitor) : new IFileStore[]{};
            if (isDirectory || !Utils.exists((IAdaptable)destinationStore) || !sourceStore.getName().equals(destinationStore.getName()) || this.overwriteStatus == OverwriteStatus.YES_TO_ALL) break block10;
            final IFileStore dStore = destinationStore;
            final IFileStore sStore = sourceStore;
            this.fShell.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    String msg = null;
                    msg = CopyFilesOperation.this.showSourceOfOverwrite ? MessageFormat.format(Messages.CopyFilesOperation_OverwriteWarning, dStore.toString(), sStore.toString()) : MessageFormat.format(Messages.CopyFilesOperation_OverwriteWarning2, dStore.toString());
                    MessageDialog dialog = new MessageDialog(CopyFilesOperation.this.fShell, Messages.CopyFilesOperation_OverwriteTitle, null, msg, 5, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.YES_TO_ALL_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
                    int retCode = dialog.open();
                    switch (retCode) {
                        case 0: {
                            CopyFilesOperation.this.overwriteStatus = OverwriteStatus.YES;
                            break;
                        }
                        case 1: {
                            CopyFilesOperation.this.overwriteStatus = OverwriteStatus.YES_TO_ALL;
                            break;
                        }
                        case 2: {
                            CopyFilesOperation.this.overwriteStatus = OverwriteStatus.NO;
                            break;
                        }
                        default: {
                            CopyFilesOperation.this.overwriteStatus = OverwriteStatus.CANCEL;
                        }
                    }
                }
            });
            switch (this.overwriteStatus) {
                case CANCEL: {
                    monitor.setCanceled(true);
                }
                case NO: {
                    return false;
                }
            }
        }
        try {
            SyncUtils.copy((IFileStore)sourceStore, null, (IFileStore)destinationStore, (int)0, (IProgressMonitor)monitor);
            IFileStore[] iFileStoreArray = childStores;
            int n = childStores.length;
            int n2 = 0;
            while (n2 < n) {
                IFileStore childStore = iFileStoreArray[n2];
                IFileStore destChildStore = destinationStore.getChild(childStore.getName());
                this.copyFile(childStore, destChildStore, monitor);
                ++n2;
            }
        }
        catch (CoreException e) {
            IdeLog.logError((Plugin)IOUIPlugin.getDefault(), (String)MessageFormat.format(Messages.CopyFilesOperation_ERR_FailedToCopy, sourceStore, destinationStore), (Throwable)e);
            success = false;
        }
        return success;
    }

    protected boolean copyFile(IFileStore sourceStore, IFileStore sourceRoot, IFileStore destinationRoot, IProgressMonitor monitor) {
        if (sourceStore == null || CloakingUtils.isFileCloaked((IFileStore)sourceStore)) {
            return false;
        }
        boolean success = true;
        IFileStore[] sourceStores = null;
        IFileStore[] targetStores = null;
        try {
            if (sourceStore.equals(sourceRoot)) {
                sourceStores = sourceRoot.childStores(0, monitor);
                targetStores = new IFileStore[sourceStores.length];
                int i = 0;
                while (i < targetStores.length) {
                    targetStores[i] = destinationRoot.getChild(sourceStores[i].getName());
                    ++i;
                }
            } else if (sourceRoot.isParentOf(sourceStore)) {
                sourceStores = new IFileStore[]{sourceStore};
                targetStores = new IFileStore[1];
                String sourceRootPath = sourceRoot.toString();
                String sourcePath = sourceStore.toString();
                int index = sourcePath.indexOf(sourceRootPath);
                if (index > -1) {
                    String relativePath = sourcePath.substring(index + sourceRootPath.length());
                    targetStores[0] = destinationRoot.getFileStore((IPath)new Path(relativePath));
                    IFileStore parent = CopyFilesOperation.getFolderStore((IAdaptable)targetStores[0]);
                    if (parent != targetStores[0]) {
                        parent.mkdir(0, monitor);
                    }
                }
            }
            if (sourceStores == null) {
                success = false;
                sourceStores = new IFileStore[]{};
                targetStores = new IFileStore[]{};
            }
            int i = 0;
            while (i < sourceStores.length) {
                success = this.copyFile(sourceStores[i], targetStores[i], monitor) && success;
                ++i;
            }
        }
        catch (CoreException e) {
            IdeLog.logError((Plugin)IOUIPlugin.getDefault(), (String)MessageFormat.format(Messages.CopyFilesOperation_ERR_FailedToCopyToDest, sourceStore, destinationRoot), (Throwable)e);
            success = false;
        }
        return success;
    }

    private void copyFiles(final IFileStore[] sources, final IFileStore destination, IJobChangeListener listener) {
        Job job = new Job(Messages.CopyFilesOperation_CopyJob_Title){

            protected IStatus run(IProgressMonitor monitor) {
                return CopyFilesOperation.this.copyFiles(sources, destination, monitor);
            }

            public boolean belongsTo(Object family) {
                if (Messages.CopyFilesOperation_CopyJob_Title.equals(family)) {
                    return true;
                }
                return super.belongsTo(family);
            }
        };
        if (listener != null) {
            job.addJobChangeListener(listener);
        }
        job.setUser(true);
        job.schedule();
    }

    private void copyFiles(final IFileStore[] sources, final IFileStore sourceRoot, final IFileStore destinationRoot, IJobChangeListener listener) {
        Job job = new Job(Messages.CopyFilesOperation_CopyJob_Title){

            protected IStatus run(IProgressMonitor monitor) {
                return CopyFilesOperation.this.copyFiles(sources, sourceRoot, destinationRoot, monitor);
            }

            public boolean belongsTo(Object family) {
                if (Messages.CopyFilesOperation_CopyJob_Title.equals(family)) {
                    return true;
                }
                return super.belongsTo(family);
            }
        };
        if (listener != null) {
            job.addJobChangeListener(listener);
        }
        job.setUser(true);
        job.schedule();
    }

    private IFileStore getNewNameFor(final IFileStore originalFile) {
        final IFileStore parent = originalFile.getParent();
        final String[] returnValue = new String[]{""};
        final String filename = originalFile.getName();
        final boolean isRemote = originalFile instanceof IExtendedFileStore;
        this.fShell.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                IInputValidator validator = new IInputValidator(){

                    public String isValid(String string) {
                        if (filename.equals(string)) {
                            return Messages.CopyFilesOperation_ERR_NameConflict;
                        }
                        if (!isRemote) {
                            int type = Utils.isDirectory((IAdaptable)originalFile) ? 2 : 1;
                            IStatus status = ResourcesPlugin.getWorkspace().validateName(string, type);
                            if (!status.isOK()) {
                                return status.getMessage();
                            }
                            if (Utils.exists((IAdaptable)parent.getChild(string))) {
                                return Messages.CopyFilesOperation_ERR_NameExists;
                            }
                        }
                        return null;
                    }
                };
                InputDialog dialog = new InputDialog(CopyFilesOperation.this.fShell, Messages.CopyFilesOperation_NameConflictDialog_Title, MessageFormat.format(Messages.CopyFilesOperation_NameConflictDialog_Message, filename), CopyFilesOperation.getAutoNewNameFor(originalFile), validator);
                dialog.setBlockOnOpen(true);
                dialog.open();
                returnValue[0] = dialog.getReturnCode() == 1 ? null : dialog.getValue();
            }
        });
        if (returnValue[0] == null) {
            return null;
        }
        return parent.getChild(returnValue[0]);
    }

    private static String getAutoNewNameFor(IFileStore originalFile) {
        String name = originalFile.getName();
        IFileStore parent = originalFile.getParent();
        boolean isRemote = originalFile instanceof IExtendedFileStore;
        int counter = 1;
        while (true) {
            String newName = counter > 1 ? MessageFormat.format(Messages.CopyFilesOperation_DefaultNewName_WithCount, counter, name) : MessageFormat.format(Messages.CopyFilesOperation_DefaultNewName, name);
            if (isRemote || !Utils.exists((IAdaptable)parent.getChild(newName))) {
                return newName;
            }
            ++counter;
        }
    }

    private static String validateDestination(IAdaptable destination, IFileStore[] sourceStores) {
        IResource resource = (IResource)destination.getAdapter(IResource.class);
        if (resource != null && !resource.isAccessible()) {
            return Messages.CopyFilesOperation_DestinationNotAccessible;
        }
        IFileStore destinationStore = CopyFilesOperation.getFolderStore(destination);
        IFileStore[] iFileStoreArray = sourceStores;
        int n = sourceStores.length;
        int n2 = 0;
        while (n2 < n) {
            IFileStore sourceStore = iFileStoreArray[n2];
            IFileStore sourceParentStore = sourceStore.getParent();
            if (destinationStore.equals(sourceStore) || sourceParentStore != null && destinationStore.equals(sourceParentStore)) {
                return Messages.CopyFilesOperation_ERR_SourceInDestination;
            }
            if (sourceStore.isParentOf(destinationStore)) {
                return Messages.CopyFilesOperation_ERR_DestinationInSource;
            }
            ++n2;
        }
        return null;
    }

    private static IFileStore getFileStore(String filename) {
        try {
            return EFS.getStore((URI)new Path(filename).toFile().toURI());
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    private static IFileStore[] getFileStores(String[] filenames) {
        IFileStore[] fileStores = new IFileStore[filenames.length];
        int i = 0;
        while (i < fileStores.length) {
            fileStores[i] = CopyFilesOperation.getFileStore(filenames[i]);
            ++i;
        }
        return fileStores;
    }

    private static IFileStore getFolderStore(IAdaptable adaptable) {
        IFileStore store = Utils.getFileStore(adaptable);
        IFileInfo info = Utils.getFileInfo(adaptable, 2048);
        if (store != null && info != null && !info.isDirectory()) {
            store = store.getParent();
        }
        return store;
    }

    private static enum OverwriteStatus {
        YES,
        YES_TO_ALL,
        NO,
        CANCEL;

    }
}

