/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.operations;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IProgressMonitorWithBlocking;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.ProgressMonitorWrapper;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.equinox.internal.p2.operations.Messages;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.operations.ProvisioningSession;
import org.eclipse.osgi.util.NLS;

public abstract class ProvisioningJob
extends Job {
    public static final Object JOB_FAMILY = new Object();
    public static final int RESTART_NONE = 1;
    public static final int RESTART_OR_APPLY = 2;
    public static final int RESTART_ONLY = 3;
    private ProvisioningSession session;
    private IProgressMonitor additionalMonitor;

    public boolean belongsTo(Object family) {
        return family == JOB_FAMILY;
    }

    public ProvisioningJob(String name, ProvisioningSession session) {
        super(name);
        this.session = session;
    }

    protected ProvisioningSession getSession() {
        return this.session;
    }

    private IProgressMonitor getCombinedProgressMonitor(IProgressMonitor mon1, IProgressMonitor mon2) {
        if (mon1 == null) {
            return mon2;
        }
        if (mon2 == null) {
            return mon1;
        }
        return new DoubleProgressMonitor(mon1, mon2);
    }

    public void setAdditionalProgressMonitor(IProgressMonitor monitor) {
        this.additionalMonitor = monitor;
    }

    public final IStatus run(IProgressMonitor monitor) {
        IProgressMonitor wrappedMonitor = this.getCombinedProgressMonitor(monitor, this.additionalMonitor);
        IStatus status = Status.OK_STATUS;
        try {
            status = this.runModal(wrappedMonitor);
        }
        catch (OperationCanceledException e) {
            status = Status.CANCEL_STATUS;
        }
        return status;
    }

    public abstract IStatus runModal(IProgressMonitor var1);

    public int getRestartPolicy() {
        return 1;
    }

    protected IStatus getErrorStatus(String message, ProvisionException e) {
        if (message == null) {
            message = e == null ? NLS.bind((String)Messages.ProvisioningJob_GenericErrorStatusMessage, (Object)this.getName()) : e.getLocalizedMessage();
        }
        return new Status(4, "org.eclipse.equinox.p2.operations", message, (Throwable)e);
    }

    private static class DoubleProgressMonitor
    extends ProgressMonitorWrapper {
        IProgressMonitor additionalMonitor;

        protected DoubleProgressMonitor(IProgressMonitor monitor1, IProgressMonitor monitor2) {
            super(monitor1);
            this.additionalMonitor = monitor2;
        }

        public void beginTask(String name, int totalWork) {
            super.beginTask(name, totalWork);
            this.additionalMonitor.beginTask(name, totalWork);
        }

        public void clearBlocked() {
            super.clearBlocked();
            if (this.additionalMonitor instanceof IProgressMonitorWithBlocking) {
                ((IProgressMonitorWithBlocking)this.additionalMonitor).clearBlocked();
            }
        }

        public void done() {
            super.done();
            this.additionalMonitor.done();
        }

        public void internalWorked(double work) {
            super.internalWorked(work);
            this.additionalMonitor.internalWorked(work);
        }

        public boolean isCanceled() {
            if (super.isCanceled()) {
                return true;
            }
            return this.additionalMonitor.isCanceled();
        }

        public void setBlocked(IStatus reason) {
            super.setBlocked(reason);
            if (this.additionalMonitor instanceof IProgressMonitorWithBlocking) {
                ((IProgressMonitorWithBlocking)this.additionalMonitor).setBlocked(reason);
            }
        }

        public void setCanceled(boolean b) {
            super.setCanceled(b);
            this.additionalMonitor.setCanceled(b);
        }

        public void setTaskName(String name) {
            super.setTaskName(name);
            this.additionalMonitor.setTaskName(name);
        }

        public void subTask(String name) {
            super.subTask(name);
            this.additionalMonitor.subTask(name);
        }

        public void worked(int work) {
            super.worked(work);
            this.additionalMonitor.worked(work);
        }
    }
}

