/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.formatter.ui.dialogs;

import java.text.MessageFormat;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.internal.WorkbenchMessages;

public class PropToPrefLinkArea {
    private Link pageLink;

    public PropToPrefLinkArea(Composite parent, int style, final String pageId, String message, final Shell shell, final Object pageData) {
        String result;
        this.pageLink = new Link(parent, style);
        IPreferenceNode node = this.getPreferenceNode(pageId);
        if (node == null) {
            result = NLS.bind((String)WorkbenchMessages.PreferenceNode_NotFound, (Object)pageId);
        } else {
            result = MessageFormat.format(message, node.getLabelText());
            this.pageLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    PreferencesUtil.createPreferenceDialogOn((Shell)shell, (String)pageId, (String[])new String[]{pageId}, (Object)pageData).open();
                }
            });
        }
        this.pageLink.setText(result);
    }

    public Control getControl() {
        return this.pageLink;
    }

    private IPreferenceNode getPreferenceNode(String pageId) {
        for (IPreferenceNode next : PlatformUI.getWorkbench().getPreferenceManager().getElements(0)) {
            if (!next.getId().equals(pageId)) continue;
            return next;
        }
        return null;
    }
}

