/*
 * Decompiled with CFR 0.152.
 */
package org.radrails.rails.core;

import com.aptana.core.epl.IMemento;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.webserver.core.AbstractWebServer;
import com.aptana.webserver.core.IServer;
import com.aptana.webserver.core.URLtoURIMapper;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Set;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.ILaunchesListener;
import org.eclipse.debug.core.ILaunchesListener2;
import org.eclipse.debug.core.model.IProcess;
import org.radrails.rails.core.Messages;
import org.radrails.rails.core.RailsCorePlugin;

public class RailsServer
extends AbstractWebServer {
    public static final String TYPE_ID = "org.radrails.rails.railsServer";
    public static final String DEFAULT_BINDING = "0.0.0.0";
    public static final int DEFAULT_PORT = 3000;
    private static final String RAILS = "rails";
    private static final String SERVER = "server";
    private static final String SCRIPT = "script";
    private static final String ELEMENT_PORT = "port";
    private static final String ELEMENT_HOST = "host";
    private static final String ELEMENT_PROJECT = "project";
    private IProject fProject;
    private String fMode;
    private ILaunch fLaunch;
    private Integer fPort = 3000;
    private String fHost = "0.0.0.0";

    public IStatus stop(boolean force, IProgressMonitor monitor) {
        if (this.getLaunch() == null || this.getLaunch().isTerminated()) {
            this.updateState(IServer.State.STOPPED);
            return Status.OK_STATUS;
        }
        this.updateState(IServer.State.STOPPING);
        try {
            this.getLaunch().terminate();
            this.updateState(IServer.State.STOPPED);
        }
        catch (DebugException e) {
            this.updateState(IServer.State.STARTED);
            return new Status(4, "org.radrails.rails.core", Messages.RailsServer_StopFailedErrorMsg, (Throwable)e);
        }
        return Status.OK_STATUS;
    }

    public IStatus start(String mode, IProgressMonitor monitor) {
        this.updateState(IServer.State.STARTING);
        try {
            ILaunchConfiguration config = this.findOrCreateLaunchConfiguration(this.fProject);
            if (config != null) {
                this.fMode = mode;
                this.fLaunch = config.launch(mode, monitor);
                DebugPlugin.getDefault().getLaunchManager().addLaunchListener((ILaunchesListener)new ILaunchesListener2(){

                    public void launchesRemoved(ILaunch[] launches) {
                    }

                    public void launchesChanged(ILaunch[] launches) {
                    }

                    public void launchesAdded(ILaunch[] launches) {
                    }

                    public void launchesTerminated(ILaunch[] launches) {
                        ILaunch[] iLaunchArray = launches;
                        int n = launches.length;
                        int n2 = 0;
                        while (n2 < n) {
                            ILaunch launch = iLaunchArray[n2];
                            if (launch.equals(RailsServer.this.fLaunch)) {
                                RailsServer.this.updateState(IServer.State.STOPPED);
                                break;
                            }
                            ++n2;
                        }
                    }
                });
                this.updateState(IServer.State.STARTED);
            }
        }
        catch (CoreException e) {
            this.updateState(IServer.State.STOPPED);
            return e.getStatus();
        }
        catch (Exception e) {
            this.updateState(IServer.State.STOPPED);
            return new Status(4, "org.radrails.rails.core", e.getMessage(), (Throwable)e);
        }
        return Status.OK_STATUS;
    }

    public String getMode() {
        return this.fMode;
    }

    public ILaunch getLaunch() {
        return this.fLaunch;
    }

    public IProcess[] getProcesses() {
        return this.getLaunch().getProcesses();
    }

    public String getHostname() {
        return this.fHost;
    }

    public int getPort() {
        return this.fPort;
    }

    public URI getDocumentRoot() {
        if (this.fProject == null) {
            return null;
        }
        IPath projectLocation = this.fProject.getLocation();
        if (projectLocation == null) {
            return null;
        }
        File file = projectLocation.append("public").toFile();
        if (file == null) {
            return null;
        }
        return file.toURI();
    }

    public URL getBaseURL() {
        try {
            return new URL("http", this.getHostname(), this.getPort(), "");
        }
        catch (MalformedURLException e) {
            IdeLog.logError((Plugin)RailsCorePlugin.getDefault(), (Throwable)e);
            return null;
        }
    }

    public URI resolve(IFileStore file) {
        return new URLtoURIMapper(this.getBaseURL(), this.getDocumentRoot()).resolve(file);
    }

    public IFileStore resolve(URI uri) {
        return new URLtoURIMapper(this.getBaseURL(), this.getDocumentRoot()).resolve(uri);
    }

    public void loadState(IMemento memento) {
        super.loadState(memento);
        Integer port = memento.getInteger(ELEMENT_PORT);
        if (port != null) {
            this.fPort = port;
        }
        this.fHost = memento.getString(ELEMENT_HOST);
        String location = memento.getString(ELEMENT_PROJECT);
        if (location != null) {
            this.fProject = (IProject)ResourcesPlugin.getWorkspace().getRoot().getContainerForLocation(Path.fromPortableString((String)location));
        }
    }

    public void saveState(IMemento memento) {
        super.saveState(memento);
        memento.putInteger(ELEMENT_PORT, this.fPort.intValue());
        memento.putString(ELEMENT_HOST, this.fHost);
        if (this.fProject != null && this.fProject.getLocation() != null) {
            memento.putString(ELEMENT_PROJECT, this.fProject.getLocation().toPortableString());
        }
    }

    protected ILaunchConfiguration findOrCreateLaunchConfiguration(IProject railsProject) throws CoreException {
        StringBuilder args = new StringBuilder();
        String filename = "";
        if (this.scriptServerExists(railsProject)) {
            IFile file = railsProject.getFile(new Path(SCRIPT).append(SERVER));
            filename = file.getLocation().toOSString();
        } else {
            IFile file = railsProject.getFile(new Path(SCRIPT).append(RAILS));
            filename = file.getLocation().toOSString();
            args.append(SERVER);
        }
        args.append(" --binding=").append(this.getHostname());
        args.append(" --port=").append(this.getPort());
        return this.createConfiguration(railsProject, filename, args.toString());
    }

    private ILaunchConfiguration createConfiguration(IProject project, String rubyFile, String args) throws CoreException {
        ILaunchConfigurationType configType = this.getRubyLaunchConfigType();
        ILaunchConfigurationWorkingCopy wc = configType.newInstance(null, this.getLaunchManager().generateLaunchConfigurationName(project.getName()));
        wc.setAttribute("com.aptana.ruby.debug.ATTR_FILE_NAME", rubyFile);
        wc.setAttribute("com.aptana.ruby.debug.ATTR_WORKING_DIR", project.getLocation().toOSString());
        wc.setAttribute("com.aptana.ruby.debug.ATTR_PROGRAM_ARGUMENTS", args);
        wc.setAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_ID, "com.aptana.ruby.debug.core.sourceLocator");
        wc.setAttribute("org.eclipse.debug.ui.private", true);
        wc.setAttribute("org.eclipse.debug.ui.ATTR_LAUNCH_IN_BACKGROUND", false);
        wc.setAttribute("process_factory_id", "com.aptana.ruby.debug.core.interruptingProcessFactory");
        return wc.doSave();
    }

    protected ILaunchConfigurationType getRubyLaunchConfigType() {
        return this.getLaunchManager().getLaunchConfigurationType("com.aptana.ruby.debug.core.launchConfigurationType");
    }

    protected ILaunchManager getLaunchManager() {
        return DebugPlugin.getDefault().getLaunchManager();
    }

    protected boolean scriptServerExists(IProject railsProject) {
        IFile scriptServer = railsProject.getFile(new Path(SCRIPT).append(SERVER));
        return scriptServer != null && scriptServer.exists();
    }

    public void setPort(int port) {
        this.fPort = port;
    }

    public void setHost(String host) {
        this.fHost = host;
    }

    public void setProject(IProject project) {
        this.fProject = project;
    }

    public IProject getProject() {
        return this.fProject;
    }

    public Set<String> getAvailableModes() {
        return CollectionsUtil.newSet((Object[])new String[]{"run", "debug"});
    }
}

