/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ui.preferences;

import com.aptana.buildpath.core.BuildPathEntry;
import com.aptana.buildpath.core.BuildPathManager;
import com.aptana.core.CoreStrings;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.FileUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.index.core.BuildContextType;
import com.aptana.index.core.RebuildIndexJob;
import com.aptana.ui.UIPlugin;
import com.aptana.ui.preferences.Messages;
import java.io.File;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;

public class ProjectBuildPathPropertyPage
extends PropertyPage
implements IWorkbenchPropertyPage {
    private IProject project;
    private CheckboxTableViewer tableViewer;
    private String userSDOCMLPath;
    private Button fRemoveButton;
    private Set<BuildPathEntry> systemBuildRntries;
    private static final String OS_NAME = "os.name";
    private static final String OS_NAME_LINUX = "linux";
    private static final String OS_NAME_MAC = "mac";
    private static final String SDOCML_EXTEND = ".sdocml";
    private static final String USER_HOME_PROPERTY = "user.home";
    private static final String USER_SDOCML_DIRECTORY_GENERAL = "HBuilder settings/sdocml";
    private static final String USER_SDOCML_DIRECTORY_MACOSX = "/Documents/HBuilder settings/sdocml";

    public String getUserSDOCMLPath() {
        return this.userSDOCMLPath;
    }

    public ProjectBuildPathPropertyPage() {
        this.initUserSDOCMLPath();
    }

    protected Control createContents(Composite parent) {
        this.project = (IProject)this.getElement().getAdapter(IResource.class);
        Set<BuildPathEntry> entries = this.getBuildPathEntries(this.project);
        Set<BuildPathEntry> selectedEntries = this.getSelectedBuildPathEntries(this.project);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(2).create());
        composite.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        this.setDescription(MessageFormat.format(Messages.ProjectBuildPathPropertyPage_TableDescription, this.project.getName()));
        Link link = new Link(composite, 0);
        link.setLayoutData((Object)GridDataFactory.fillDefaults().span(2, 1).create());
        link.setText("HBuilder\u7684\u6846\u67b6\u8bed\u6cd5\u5e93\u662f\u5f00\u6e90\u7684\uff0c\u6258\u7ba1\u5728<a>https://github.com/dcloudio/WebFrameworkGrammar</a>\u3002\u6b22\u8fce\u5927\u5bb6\u4fee\u6539\u66f4\u65b0\u3002");
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser().openURL(new URL("https://github.com/dcloudio/WebFrameworkGrammar"));
                    return;
                }
                catch (Exception ex) {
                    IdeLog.logError((Plugin)UIPlugin.getDefault(), (Throwable)ex);
                    return;
                }
            }
        });
        Label text = new Label(composite, 0);
        text.setLayoutData((Object)GridDataFactory.fillDefaults().span(3, 1).create());
        text.setText("\u70b9\u51fb\u786e\u8ba4\u540e\uff0c\u89c6\u9879\u76ee\u5927\u5c0f\uff0c\u9700\u8981\u7b49\u5f85\u51e0\u79d2\u540e\u4ee3\u7801\u52a9\u624b\u624d\u80fd\u63d0\u793a\u8be5\u6846\u67b6\u8bed\u6cd5");
        Composite tableComposite = new Composite(composite, 0);
        tableComposite.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(4).create());
        tableComposite.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        this.tableViewer = CheckboxTableViewer.newCheckList((Composite)tableComposite, (int)2176);
        Table table = this.tableViewer.getTable();
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        table.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        TableColumn column1 = new TableColumn(table, 16384);
        column1.setText(Messages.ProjectBuildPathPropertyPage_LibraryColumnLabel);
        column1.setWidth(165);
        TableColumn column2 = new TableColumn(table, 16384);
        column2.setText(Messages.ProjectBuildPathPropertyPage_PathColumnLabel);
        column2.setWidth(300);
        this.tableViewer.setContentProvider((IContentProvider)this.getContentProvider());
        this.tableViewer.setLabelProvider(this.getLabelProvider());
        this.tableViewer.setComparator(this.getCompartor());
        this.tableViewer.setInput(entries);
        this.tableViewer.setCheckedElements(selectedEntries.toArray());
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ProjectBuildPathPropertyPage.this.updateButtonStates();
            }
        });
        this.createTaskButtons(composite);
        this.updateButtonStates();
        return composite;
    }

    private void updateTableViewer() {
        Set<BuildPathEntry> entries = this.getBuildPathEntries(this.project);
        Set<BuildPathEntry> selectedEntries = this.getSelectedBuildPathEntries(this.project);
        this.tableViewer.setInput(entries);
        this.tableViewer.setCheckedElements(selectedEntries.toArray());
        this.tableViewer.refresh();
    }

    private void updateButtonStates() {
        StructuredSelection structuredSelection;
        Object o;
        ISelection selection = this.tableViewer.getSelection();
        if (selection.isEmpty()) {
            this.fRemoveButton.setEnabled(false);
            return;
        }
        if (selection instanceof StructuredSelection && (o = (structuredSelection = (StructuredSelection)selection).getFirstElement()) instanceof BuildPathEntry) {
            BuildPathEntry buildPathEntry = (BuildPathEntry)o;
            if (this.systemBuildRntries.contains(buildPathEntry)) {
                this.fRemoveButton.setEnabled(false);
            } else {
                this.fRemoveButton.setEnabled(true);
            }
        }
    }

    private void getUserBuildPathEntries(Set<BuildPathEntry> entries) {
        if (StringUtil.isBlank((String)this.userSDOCMLPath)) {
            this.initUserSDOCMLPath();
            return;
        }
        File targetFileDirectory = new File(this.userSDOCMLPath);
        if (!targetFileDirectory.exists() || !targetFileDirectory.isDirectory()) {
            targetFileDirectory.mkdirs();
            return;
        }
        File[] files = targetFileDirectory.listFiles();
        if (files == null || files.length < 1) {
            return;
        }
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.exists() && file.isFile() && file.getName().endsWith(SDOCML_EXTEND)) {
                String name = file.getName();
                name = name.substring(0, name.lastIndexOf("."));
                BuildPathEntry buildPath = new BuildPathEntry(name, file.toURI());
                entries.add(buildPath);
            }
            ++n2;
        }
    }

    private void createTaskButtons(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)GridDataFactory.fillDefaults().create());
        composite.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
        Button fAddButton = new Button(composite, 0x800008);
        fAddButton.setText("\u5bfc\u5165");
        fAddButton.setLayoutData((Object)GridDataFactory.swtDefaults().align(4, 0x1000000).hint(Math.max(fAddButton.computeSize((int)-1, (int)-1, (boolean)true).x, this.convertHorizontalDLUsToPixels(61)), -1).create());
        fAddButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fileDialog = new FileDialog(ProjectBuildPathPropertyPage.this.getShell(), 4096);
                fileDialog.setFilterExtensions(new String[]{"*.sdocml"});
                String path = fileDialog.open();
                if (StringUtil.isNotBlank((String)path)) {
                    String targetFilePath;
                    File targetFile;
                    File targetFileDirectory;
                    File sourceFile = new File(path);
                    if (!sourceFile.exists()) {
                        return;
                    }
                    if (StringUtil.isBlank((String)ProjectBuildPathPropertyPage.this.userSDOCMLPath)) {
                        ProjectBuildPathPropertyPage.this.initUserSDOCMLPath();
                    }
                    if (!(targetFileDirectory = new File(ProjectBuildPathPropertyPage.this.userSDOCMLPath)).exists() || !targetFileDirectory.isDirectory()) {
                        targetFileDirectory.mkdirs();
                    }
                    if ((targetFile = new File(targetFilePath = String.valueOf(ProjectBuildPathPropertyPage.this.userSDOCMLPath) + "/" + sourceFile.getName())).exists()) {
                        MessageDialog dialog = new MessageDialog(ProjectBuildPathPropertyPage.this.getShell(), "\u5bfc\u5165\u6846\u67b6\u8bed\u6cd5\u5e93", null, "\u6846\u67b6\u8bed\u6cd5\u5e93\u6587\u4ef6\u5df2\u7ecf\u5b58\u5728\uff0c\u662f\u5426\u8986\u76d6\uff0c\u8bf7\u786e\u8ba4\uff01", 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0);
                        if (dialog.open() == 0) {
                            FileUtil.copyFile((File)sourceFile, (File)targetFile);
                        }
                    } else {
                        FileUtil.copyFile((File)sourceFile, (File)targetFile);
                    }
                    ProjectBuildPathPropertyPage.this.updateTableViewer();
                }
            }
        });
        this.fRemoveButton = new Button(composite, 0x800008);
        this.fRemoveButton.setText(CoreStrings.REMOVE);
        this.fRemoveButton.setLayoutData((Object)GridDataFactory.swtDefaults().align(4, 0x1000000).hint(Math.max(this.fRemoveButton.computeSize((int)-1, (int)-1, (boolean)true).x, this.convertHorizontalDLUsToPixels(61)), -1).create());
        this.fRemoveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StructuredSelection structuredSelection;
                Object o;
                ISelection selection = ProjectBuildPathPropertyPage.this.tableViewer.getSelection();
                if (selection.isEmpty()) {
                    return;
                }
                if (selection instanceof StructuredSelection && (o = (structuredSelection = (StructuredSelection)selection).getFirstElement()) instanceof BuildPathEntry) {
                    BuildPathEntry buildPathEntry = (BuildPathEntry)o;
                    if (ProjectBuildPathPropertyPage.this.systemBuildRntries.contains(buildPathEntry)) {
                        return;
                    }
                    MessageDialog dialog = new MessageDialog(ProjectBuildPathPropertyPage.this.getShell(), "\u5220\u9664\u6846\u67b6\u8bed\u6cd5\u5e93", null, "\u662f\u5426\u5220\u9664 " + buildPathEntry.getDisplayName() + " \u6846\u67b6\u8bed\u6cd5\u5e93\u6587\u4ef6\uff0c\u8bf7\u786e\u8ba4\uff01", 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0);
                    if (dialog.open() == 0) {
                        File file = new File(buildPathEntry.getPath());
                        if (file.exists()) {
                            file.delete();
                        }
                        BuildPathManager manager = BuildPathManager.getInstance();
                        ArrayList<BuildPathEntry> buildPathEntrys = new ArrayList<BuildPathEntry>();
                        buildPathEntrys.add(buildPathEntry);
                        manager.removeBuildPathContributor(ProjectBuildPathPropertyPage.this.project, buildPathEntrys);
                        ProjectBuildPathPropertyPage.this.updateTableViewer();
                        Object[] items = ProjectBuildPathPropertyPage.this.tableViewer.getCheckedElements();
                        ArrayList<BuildPathEntry> entries = new ArrayList<BuildPathEntry>();
                        Object[] objectArray = items;
                        int n = items.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Object item = objectArray[n2];
                            if (item instanceof BuildPathEntry) {
                                entries.add((BuildPathEntry)item);
                            }
                            ++n2;
                        }
                        BuildPathManager.getInstance().setBuildPaths(ProjectBuildPathPropertyPage.this.project, entries);
                        RebuildIndexJob job = new RebuildIndexJob(ProjectBuildPathPropertyPage.this.project.getLocationURI(), BuildContextType.JS, ProjectBuildPathPropertyPage.this.project);
                        job.setNeedFilter(false);
                        job.setSystem(true);
                        job.schedule();
                    }
                }
            }
        });
    }

    private void initUserSDOCMLPath() {
        String OS = null;
        if (Platform.isRunning()) {
            OS = Platform.getOS();
        } else {
            OS = System.getProperty(OS_NAME).toLowerCase();
            if (OS.contains(OS_NAME_MAC)) {
                OS = "macosx";
            } else if (OS.contains(OS_NAME_LINUX)) {
                OS = OS_NAME_LINUX;
            }
        }
        String userHome = System.getProperty(USER_HOME_PROPERTY);
        this.userSDOCMLPath = OS.equals("macosx") || OS.equals(OS_NAME_LINUX) ? String.valueOf(userHome) + USER_SDOCML_DIRECTORY_MACOSX + "/" : String.valueOf(userHome) + File.separator + USER_SDOCML_DIRECTORY_GENERAL + "/";
    }

    private ViewerComparator getCompartor() {
        return new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (e1 instanceof BuildPathEntry && e2 instanceof BuildPathEntry) {
                    BuildPathEntry bpe1 = (BuildPathEntry)e1;
                    BuildPathEntry bpe2 = (BuildPathEntry)e2;
                    return bpe1.getDisplayName().compareTo(bpe2.getDisplayName());
                }
                return 0;
            }
        };
    }

    private Set<BuildPathEntry> getBuildPathEntries(IProject project) {
        if (this.systemBuildRntries == null) {
            this.systemBuildRntries = BuildPathManager.getInstance().getBuildPaths();
        }
        HashSet<BuildPathEntry> entries = new HashSet<BuildPathEntry>();
        entries.addAll(this.systemBuildRntries);
        this.getUserBuildPathEntries(entries);
        return entries;
    }

    private Set<BuildPathEntry> getSelectedBuildPathEntries(IProject project) {
        Set result = BuildPathManager.getInstance().getBuildPaths(project);
        if (!result.isEmpty()) {
            result.retainAll(this.getBuildPathEntries(project));
        }
        return result;
    }

    private IStructuredContentProvider getContentProvider() {
        return new BaseWorkbenchContentProvider(){

            public Object[] getChildren(Object element) {
                if (element instanceof Set) {
                    return ((Set)element).toArray();
                }
                return super.getChildren(element);
            }
        };
    }

    private IBaseLabelProvider getLabelProvider() {
        return new ITableLabelProvider(){

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }

            public String getColumnText(Object element, int columnIndex) {
                if (element instanceof BuildPathEntry) {
                    BuildPathEntry entry = (BuildPathEntry)element;
                    switch (columnIndex) {
                        case 0: {
                            return entry.getDisplayName();
                        }
                        case 1: {
                            String result = entry.getPath().toString();
                            if (result != null && result.startsWith("file:")) {
                                File f = new File(entry.getPath());
                                return f.getAbsolutePath();
                            }
                            return result;
                        }
                    }
                }
                return null;
            }
        };
    }

    public boolean performOk() {
        Object[] items = this.tableViewer.getCheckedElements();
        TableItem[] tableItems = this.tableViewer.getTable().getItems();
        ArrayList<BuildPathEntry> buildPathEntrys = new ArrayList<BuildPathEntry>(tableItems.length);
        TableItem[] tableItemArray = tableItems;
        int n = tableItems.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem tableItem = tableItemArray[n2];
            buildPathEntrys.add((BuildPathEntry)tableItem.getData());
            ++n2;
        }
        ArrayList<BuildPathEntry> entries = new ArrayList<BuildPathEntry>();
        Object[] objectArray = items;
        int n3 = items.length;
        n = 0;
        while (n < n3) {
            Object item = objectArray[n];
            if (item instanceof BuildPathEntry) {
                buildPathEntrys.remove(item);
                entries.add((BuildPathEntry)item);
            }
            ++n;
        }
        BuildPathManager manager = BuildPathManager.getInstance();
        Set currentEntries = manager.getBuildPaths(this.project);
        HashSet newEntries = new HashSet(entries);
        manager.removeBuildPathContributor(this.project, buildPathEntrys);
        if (!newEntries.equals(currentEntries)) {
            BuildPathManager.getInstance().setBuildPaths(this.project, entries);
            RebuildIndexJob job = new RebuildIndexJob(this.project.getLocationURI(), BuildContextType.JS, this.project);
            job.setNeedFilter(false);
            job.setSystem(true);
            job.setUser(false);
            job.schedule();
        }
        return true;
    }
}

