/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ui.internal.commands;

import com.aptana.core.util.URIUtil;
import java.net.URI;
import java.util.Collection;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.handlers.HandlerUtil;

public class OpenInFinderHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        if (event == null) {
            return Boolean.FALSE;
        }
        Object context = event.getApplicationContext();
        if (!(context instanceof IEvaluationContext)) {
            return Boolean.FALSE;
        }
        IEvaluationContext evContext = (IEvaluationContext)event.getApplicationContext();
        Object input = evContext.getVariable("showInInput");
        if (input instanceof IEditorInput) {
            input = HandlerUtil.getActiveEditorInput((ExecutionEvent)event);
        }
        if (input instanceof IFileEditorInput) {
            IFileEditorInput fei = (IFileEditorInput)input;
            return URIUtil.open((URI)fei.getFile().getLocationURI());
        }
        if (input instanceof IURIEditorInput) {
            IURIEditorInput uriInput = (IURIEditorInput)input;
            return URIUtil.open((URI)uriInput.getURI());
        }
        boolean result = Boolean.TRUE;
        Collection selectedFiles = (Collection)evContext.getDefaultVariable();
        if (selectedFiles.isEmpty()) {
            return Boolean.FALSE;
        }
        for (Object selected : selectedFiles) {
            IResource resource = null;
            if (!(selected instanceof IAdaptable)) continue;
            resource = (IResource)((IAdaptable)selected).getAdapter(IResource.class);
            if (resource != null) {
                result = result && URIUtil.open((URI)resource.getLocationURI());
                continue;
            }
            IFileStore fileStore = (IFileStore)((IAdaptable)selected).getAdapter(IFileStore.class);
            try {
                if (fileStore == null || fileStore.toLocalFile(0, null) == null) continue;
                result = result && URIUtil.open((URI)fileStore.toURI());
            }
            catch (CoreException coreException) {}
        }
        return result;
    }
}

