/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ui.console;

import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsolePageParticipant;
import org.eclipse.ui.console.TextConsolePage;
import org.eclipse.ui.console.TextConsoleViewer;
import org.eclipse.ui.internal.console.IOConsoleViewer;
import org.eclipse.ui.internal.console.ScrollLockAction;
import org.eclipse.ui.part.IPageBookViewPage;

public class ConsoleAutoScrollPageParticipant
extends PlatformObject
implements IConsolePageParticipant {
    private boolean scrollActionEnabled;
    private StyledText textWidget;
    private Listener listener;

    public void init(IPageBookViewPage page, IConsole console) {
        if (console.getType() != "org.eclipse.debug.ui.ProcessConsoleType" || !(page instanceof TextConsolePage)) {
            return;
        }
        TextConsolePage consolePage = (TextConsolePage)page;
        TextConsoleViewer textViewer = consolePage.getViewer();
        if (!(textViewer instanceof IOConsoleViewer)) {
            return;
        }
        IOConsoleViewer viewer = (IOConsoleViewer)textViewer;
        this.scrollActionEnabled = viewer.isAutoScroll();
        IToolBarManager toolBarManager = consolePage.getSite().getActionBars().getToolBarManager();
        IAction slAction = null;
        IContributionItem[] iContributionItemArray = toolBarManager.getItems();
        int n = iContributionItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            IAction action;
            IContributionItem item = iContributionItemArray[n2];
            if (item instanceof ActionContributionItem && (action = ((ActionContributionItem)item).getAction()) instanceof ScrollLockAction) {
                slAction = action;
                break;
            }
            ++n2;
        }
        this.textWidget = viewer.getTextWidget();
        this.listener = new ConsoleListener(viewer, toolBarManager, slAction);
        this.textWidget.addListener(3, this.listener);
        this.textWidget.addListener(5, this.listener);
        this.textWidget.addListener(4, this.listener);
        this.textWidget.addListener(1, this.listener);
        this.textWidget.addListener(2, this.listener);
        this.textWidget.addListener(11, this.listener);
        ScrollBar vBar = this.textWidget.getVerticalBar();
        if (vBar != null) {
            vBar.addListener(13, this.listener);
        }
    }

    public void dispose() {
        if (this.textWidget != null && !this.textWidget.isDisposed()) {
            this.textWidget.removeListener(3, this.listener);
            this.textWidget.removeListener(5, this.listener);
            this.textWidget.removeListener(4, this.listener);
            this.textWidget.removeListener(1, this.listener);
            this.textWidget.removeListener(2, this.listener);
            this.textWidget.removeListener(11, this.listener);
            ScrollBar vBar = this.textWidget.getVerticalBar();
            if (vBar != null && !vBar.isDisposed()) {
                vBar.removeListener(13, this.listener);
            }
        }
        this.textWidget = null;
        this.listener = null;
    }

    public void activated() {
    }

    public void deactivated() {
    }

    private boolean isLastLineVisible(int topLineIndex) {
        int visibleLines = this.textWidget.getBounds().height / this.textWidget.getLineHeight();
        return this.textWidget.getLineCount() - topLineIndex <= visibleLines;
    }

    private final class ConsoleListener
    implements Listener {
        private IOConsoleViewer viewer;
        private IToolBarManager toolBarManager;
        private IAction scrollLockAction;
        int lastIndex;

        private ConsoleListener(IOConsoleViewer viewer, IToolBarManager toolBarManager, IAction scrollLockAction) {
            this.lastIndex = ConsoleAutoScrollPageParticipant.this.textWidget.getTopIndex();
            this.viewer = viewer;
            this.toolBarManager = toolBarManager;
            this.scrollLockAction = scrollLockAction;
        }

        public void handleEvent(Event event) {
            if (ConsoleAutoScrollPageParticipant.this.textWidget.isDisposed()) {
                return;
            }
            int index = ConsoleAutoScrollPageParticipant.this.textWidget.getTopIndex();
            if (index != this.lastIndex) {
                this.lastIndex = index;
                if (ConsoleAutoScrollPageParticipant.this.isLastLineVisible(index)) {
                    this.viewer.setAutoScroll(ConsoleAutoScrollPageParticipant.this.scrollActionEnabled);
                    if (this.scrollLockAction != null) {
                        this.scrollLockAction.setChecked(!ConsoleAutoScrollPageParticipant.this.scrollActionEnabled);
                        this.toolBarManager.update(true);
                    }
                } else {
                    this.viewer.setAutoScroll(false);
                    if (this.scrollLockAction != null) {
                        this.scrollLockAction.setChecked(true);
                        this.toolBarManager.update(true);
                    }
                }
            }
        }
    }
}

