/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ui.browser;

import com.aptana.core.CoreStrings;
import com.aptana.core.IBrowserProvider;
import com.aptana.core.util.BrowserUtil;
import com.aptana.core.util.ExecutableUtil;
import com.aptana.core.util.IBrowserUtil;
import com.aptana.core.util.PlatformUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.ui.browser.Messages;
import com.aptana.ui.dialogs.BrowserDescriptorDialog;
import com.aptana.ui.util.UIUtils;
import com.aptana.ui.util.WorkbenchBrowserUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.internal.browser.BrowserDescriptorWorkingCopy;
import org.eclipse.ui.internal.browser.ExternalBrowserInstance;
import org.eclipse.ui.internal.browser.IBrowserDescriptor;
import org.eclipse.ui.internal.browser.IBrowserDescriptorWorkingCopy;
import org.eclipse.ui.internal.browser.SystemBrowserDescriptor;

public class BrowserManager
implements IBrowserProvider {
    private static IBrowserProvider instance;
    private static final String SAFARI_APP = "Safari.app";
    private static final String SAFARI_PARAMS = "-a safari ";
    private static String openCommandPath;
    private static volatile boolean hasSearched;

    static {
        hasSearched = false;
    }

    public static synchronized IBrowserProvider getInstance() {
        if (instance == null) {
            instance = new BrowserManager();
        }
        return instance;
    }

    private BrowserManager() {
    }

    private String getRealPath(String loc) {
        String path;
        if (loc == null) {
            return null;
        }
        File file = new File(loc);
        try {
            path = file.getCanonicalPath();
        }
        catch (IOException iOException) {
            path = file.getAbsolutePath();
        }
        return path;
    }

    public synchronized Collection<IBrowserUtil.BrowserInfo> searchMoreBrowsers() {
        org.eclipse.ui.internal.browser.BrowserManager eclipseBrowserManager = org.eclipse.ui.internal.browser.BrowserManager.getInstance();
        List webBrowsers = eclipseBrowserManager.getWebBrowsers();
        HashSet<String> currentBrowsers = new HashSet<String>();
        for (IBrowserDescriptor iBrowserDescriptor : webBrowsers) {
            String path = this.getRealPath(iBrowserDescriptor.getLocation());
            if (path == null) continue;
            String params = iBrowserDescriptor.getParameters();
            if (path.startsWith("/usr/bin/open") && StringUtil.isNotBlank((String)params)) {
                currentBrowsers.add(params);
                continue;
            }
            currentBrowsers.add(path);
        }
        ArrayList<IBrowserUtil.BrowserInfo> browsersFound = new ArrayList<IBrowserUtil.BrowserInfo>();
        List discoverInstalledBrowsers = BrowserUtil.discoverInstalledBrowsers();
        boolean needSave = false;
        block1: for (IBrowserUtil.BrowserInfo browserInfo : discoverInstalledBrowsers) {
            String browserLocation = this.getRealPath(browserInfo.getLocation());
            if (browserLocation == null || currentBrowsers.contains(browserLocation)) continue;
            for (String params : currentBrowsers) {
                if (params.toLowerCase().contains("-a " + browserInfo.getName().toLowerCase())) continue block1;
            }
            currentBrowsers.add(browserLocation);
            BrowserDescriptorWorkingCopy workingCopy = new BrowserDescriptorWorkingCopy();
            workingCopy.setName(browserInfo.getName());
            workingCopy.setLocation(browserInfo.getLocation());
            workingCopy.setParameters(browserInfo.getParameters());
            workingCopy.save();
            browsersFound.add(browserInfo);
            needSave = true;
        }
        hasSearched = true;
        if (needSave) {
            eclipseBrowserManager.setCurrentWebBrowser(eclipseBrowserManager.getCurrentWebBrowser());
        }
        this.verifyBrowserConfigurations();
        return browsersFound;
    }

    public List<IBrowserUtil.BrowserInfo> getBrowserInfos() {
        if (!hasSearched) {
            this.searchMoreBrowsers();
        }
        List webBrowsers = org.eclipse.ui.internal.browser.BrowserManager.getInstance().getWebBrowsers();
        ArrayList<IBrowserUtil.BrowserInfo> browsers = new ArrayList<IBrowserUtil.BrowserInfo>(webBrowsers.size());
        for (IBrowserDescriptor browser : webBrowsers) {
            if (browser instanceof SystemBrowserDescriptor) continue;
            String location = browser.getLocation();
            if (location != null && location.contains("firefox-bin") && location.contains("Firefox.app")) {
                location = location.substring(0, location.indexOf("Firefox.app") + 11);
            }
            browsers.add(new IBrowserUtil.BrowserInfo(browser.getName(), browser.getName(), location, browser.getParameters()));
        }
        return browsers;
    }

    public IBrowserUtil.BrowserInfo getCurrentBrowserInfo() {
        IBrowserDescriptor currentWebBrowser = org.eclipse.ui.internal.browser.BrowserManager.getInstance().getCurrentWebBrowser();
        return new IBrowserUtil.BrowserInfo(currentWebBrowser.getName(), currentWebBrowser.getLocation());
    }

    public String getBrowserVersion(IBrowserUtil.BrowserInfo info) {
        return BrowserUtil.getBrowserVersion((IBrowserUtil.BrowserInfo)info);
    }

    public void verifyBrowserConfigurations() {
        if (PlatformUtil.isMac()) {
            if (StringUtil.isEmpty((String)openCommandPath)) {
                IPath path = ExecutableUtil.find((String)"open", (boolean)false, null);
                openCommandPath = path != null ? path.toOSString() : "/usr/bin/open";
            }
            List browsers = org.eclipse.ui.internal.browser.BrowserManager.getInstance().getWebBrowsers();
            for (IBrowserDescriptor browser : browsers) {
                IBrowserDescriptorWorkingCopy safariWorkingcopy;
                String location = browser.getLocation();
                if (location != null && location.contains(SAFARI_APP)) {
                    safariWorkingcopy = browser.getWorkingCopy();
                    safariWorkingcopy.setLocation(openCommandPath);
                    safariWorkingcopy.setParameters(SAFARI_PARAMS);
                    safariWorkingcopy.save();
                    continue;
                }
                if (location == null || !location.contains("firefox-bin") || !location.contains("Firefox.app")) continue;
                safariWorkingcopy = browser.getWorkingCopy();
                safariWorkingcopy.setLocation(location.substring(0, location.indexOf("Firefox.app") + 11));
                safariWorkingcopy.save();
            }
        }
    }

    public IBrowserUtil.BrowserInfo getDefaultBrowserInfo(String nature) {
        File file;
        String path;
        IBrowserUtil.BrowserInfo browser = null;
        if (("win32".equals(Platform.getOS()) || "macosx".equals(Platform.getOS())) && ("Chrome".equals(nature) || nature == null) && (browser = this.findBrowserInfoByLocation("Chrome")) != null) {
            path = PlatformUtil.expandEnvironmentStrings((String)browser.getLocation());
            file = new File(path);
            if (PlatformUtil.isWindows() ? file.exists() && !file.isDirectory() : file.exists()) {
                return browser;
            }
        }
        if ("win32".equals(Platform.getOS()) && ("Edge".equals(nature) || nature == null) && BrowserUtil.isEdgeExist()) {
            browser = this.findBrowserInfoByLocation("Edge");
            if (browser == null) {
                browser = this.findBrowserInfoByID("Edge");
            }
            if (browser != null) {
                return browser;
            }
        }
        if ("win32".equals(Platform.getOS()) && ("Internet Explorer".equals(nature) || nature == null) && (browser = this.findBrowserInfoByLocation("Internet Explorer")) != null) {
            path = PlatformUtil.expandEnvironmentStrings((String)browser.getLocation());
            file = new File(path);
            if (PlatformUtil.isWindows() ? file.exists() && !file.isDirectory() : file.exists()) {
                return browser;
            }
        }
        if (("win32".equals(Platform.getOS()) || "macosx".equals(Platform.getOS())) && ("Safari".equals(nature) || nature == null) && (browser = this.findBrowserInfoByLocation("Safari")) != null) {
            path = PlatformUtil.expandEnvironmentStrings((String)browser.getLocation());
            file = new File(path);
            if (PlatformUtil.isWindows() ? file.exists() && !file.isDirectory() : file.exists()) {
                return browser;
            }
        }
        if (("win32".equals(Platform.getOS()) || "macosx".equals(Platform.getOS())) && ("Firefox".equals(nature) || nature == null) && (browser = this.findBrowserInfoByLocation("Firefox")) != null) {
            path = PlatformUtil.expandEnvironmentStrings((String)browser.getLocation());
            file = new File(path);
            if (PlatformUtil.isWindows() ? file.exists() && !file.isDirectory() : file.exists()) {
                return browser;
            }
        }
        if ("win32".equals(Platform.getOS()) && ("IETester".equals(nature) || nature == null) && (browser = this.findBrowserInfoByLocation("IETester")) != null) {
            path = PlatformUtil.expandEnvironmentStrings((String)browser.getLocation());
            file = new File(path);
            if (PlatformUtil.isWindows() ? file.exists() && !file.isDirectory() : file.exists()) {
                return browser;
            }
        }
        return null;
    }

    public IBrowserUtil.BrowserInfo findBrowserInfoByLocation(String nature) {
        if (StringUtil.isBlank((String)nature)) {
            return null;
        }
        List list = BrowserManager.getInstance().getBrowserInfos();
        if (list != null) {
            for (IBrowserUtil.BrowserInfo b : list) {
                if (!b.getLocation().toLowerCase().contains(nature.toLowerCase()) && (!b.getLocation().equals(openCommandPath) || b.getParameters() == null || !b.getParameters().toLowerCase().contains(nature.toLowerCase())) || "Chrome".equals(nature) && b.getLocation().contains("360")) continue;
                return b;
            }
        }
        return null;
    }

    public IBrowserUtil.BrowserInfo findBrowserInfoByID(String id) {
        if (StringUtil.isBlank((String)id)) {
            return null;
        }
        List list = BrowserManager.getInstance().getBrowserInfos();
        if (list != null) {
            for (IBrowserUtil.BrowserInfo b : list) {
                if (!b.getId().equals(id)) continue;
                return b;
            }
        }
        return null;
    }

    public static IBrowserUtil.BrowserInfo findBrowserInfoByName(String name) {
        if (StringUtil.isBlank((String)name)) {
            return null;
        }
        List list = BrowserManager.getInstance().getBrowserInfos();
        if (list != null) {
            for (IBrowserUtil.BrowserInfo b : list) {
                if (!b.getName().equals(name)) continue;
                return b;
            }
        }
        return null;
    }

    public static IWebBrowser getWebBrowserByID(String id, boolean autoDefault) {
        if (!hasSearched) {
            BrowserManager.getInstance().searchMoreBrowsers();
        }
        if (StringUtil.isBlank((String)id)) {
            if (!autoDefault) {
                return null;
            }
            IBrowserUtil.BrowserInfo info = BrowserManager.getInstance().getDefaultBrowserInfo(null);
            if (info != null) {
                id = info.getId();
            } else {
                return null;
            }
        }
        List webBrowsers = org.eclipse.ui.internal.browser.BrowserManager.getInstance().getWebBrowsers();
        IBrowserDescriptor bd = null;
        for (IBrowserDescriptor browser : webBrowsers) {
            if (!browser.getName().equals(id)) continue;
            bd = browser;
            IBrowserDescriptorWorkingCopy wc = bd.getWorkingCopy();
            bd = wc;
            break;
        }
        if (bd != null) {
            return new ExternalBrowserInstance(id, bd);
        }
        return null;
    }

    public static IBrowserUtil.BrowserInfo showBrowserInfoNotFoundDialog(final String brower, final boolean download) {
        final IBrowserUtil.BrowserInfo[] path = new IBrowserUtil.BrowserInfo[1];
        UIUtils.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialogWithToggle md = new MessageDialogWithToggle(UIUtils.getActiveShell(), Messages.Startup_Notification, null, Messages.Startup_StudioRequiresFirefox, 2, new String[]{StringUtil.ellipsify((String)CoreStrings.BROWSE), download ? Messages.Startup_Download : Messages.Startup_CheckAgain, IDialogConstants.CANCEL_LABEL}, 0, Messages.Startup_DontAskAgain, false);
                int returnCode = md.open();
                switch (returnCode) {
                    case 256: {
                        BrowserDescriptorDialog dialog = new BrowserDescriptorDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
                        if (dialog.open() != 0) break;
                        IBrowserDescriptor bd = dialog.getBrowser();
                        path[0] = BrowserManager.findBrowserInfoByName(bd.getName());
                        break;
                    }
                    case 257: {
                        if (!download) break;
                        if ("Firefox".equals(brower)) {
                            WorkbenchBrowserUtil.launchExternalBrowser("http://www.getfirefox.com");
                            break;
                        }
                        if ("Internet Explorer".equals(brower)) {
                            WorkbenchBrowserUtil.launchExternalBrowser("http://windows.microsoft.com/zh-cn/internet-explorer/download-ie");
                            break;
                        }
                        if ("Chrome".equals(brower)) {
                            WorkbenchBrowserUtil.launchExternalBrowser("http://www.google.cn/intl/zh-CN/chrome");
                            break;
                        }
                        if ("Safari".equals(brower)) {
                            WorkbenchBrowserUtil.launchExternalBrowser("http://support.apple.com/kb/DL1531");
                            break;
                        }
                        if (!"IETester".equals(brower)) break;
                        WorkbenchBrowserUtil.launchExternalBrowser("http://www.my-debugbar.com/wiki/IETester/HomePage");
                    }
                }
            }
        });
        return path[0];
    }
}

