/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ui.actions;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.BrowserUtil;
import com.aptana.core.util.PlatformUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.ui.UIPlugin;
import com.aptana.ui.actions.ConfigWebServerhander;
import com.aptana.ui.actions.Messages;
import com.aptana.ui.util.RunInBrowserUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class RunInBrowserPulldownAction
extends ContributionItem {
    private static final Image CHROME_IMAGE = UIPlugin.getImageDescriptor("/icons/full/etool16/chrome2.png").createImage();
    private static final Image CHROME_DISABLE_IMAGE = UIPlugin.getImageDescriptor("/icons/full/dtool16/chrome2.png").createImage();
    private static final Image INTERNET_EXPLORER_IMAGE = UIPlugin.getImageDescriptor("/icons/full/etool16/ie2.png").createImage();
    private static final Image INTERNET_EXPLORER_DISABLE_IMAGE = UIPlugin.getImageDescriptor("/icons/full/dtool16/ie2.png").createImage();
    private static final Image SAFARI_IMAGE = UIPlugin.getImageDescriptor("/icons/full/etool16/safari2.png").createImage();
    private static final Image SAFARI_DISABLE_IMAGE = UIPlugin.getImageDescriptor("/icons/full/dtool16/safari2.png").createImage();
    private static final Image FIREFOX_IMAGE = UIPlugin.getImageDescriptor("/icons/full/etool16/firefox2.png").createImage();
    private static final Image FIREFOX_DISABLE_IMAGE = UIPlugin.getImageDescriptor("/icons/full/dtool16/firefox2.png").createImage();
    private static final Image IETESTER_IMAGE = UIPlugin.getImageDescriptor("/icons/full/etool16/ietester2.png").createImage();
    private static final Image IETESTER_DISABLE_IMAGE = UIPlugin.getImageDescriptor("/icons/full/dtool16/ietester2.png").createImage();
    private static final Image EDGE_IMAGE = UIPlugin.getImageDescriptor("/icons/full/etool16/edge2.png").createImage();
    private static final Image EDGE_DISABLE_IMAGE = UIPlugin.getImageDescriptor("/icons/full/dtool16/edge2.png").createImage();
    private static boolean hasInitMainWindow = false;
    private IPartListener partListener;
    private ISelectionListener selectionListener;
    private IPropertyChangeListener propertyChangeListener;
    private Menu fMenu;
    private ToolItem menuToolItem = null;

    public RunInBrowserPulldownAction() {
        if (!hasInitMainWindow) {
            hasInitMainWindow = true;
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            this.addListeners(window);
        } else {
            PlatformUI.getWorkbench().addWindowListener(new IWindowListener(){

                public void windowOpened(IWorkbenchWindow window) {
                    try {
                        PlatformUI.getWorkbench().removeWindowListener((IWindowListener)this);
                        RunInBrowserPulldownAction.this.setEnabled(false);
                        RunInBrowserPulldownAction.this.addListeners(window);
                    }
                    catch (Throwable e) {
                        IdeLog.logError((Plugin)UIPlugin.getDefault(), (Throwable)e);
                    }
                }

                public void windowDeactivated(IWorkbenchWindow window) {
                }

                public void windowClosed(IWorkbenchWindow window) {
                    try {
                        PlatformUI.getWorkbench().removeWindowListener((IWindowListener)this);
                        if (RunInBrowserPulldownAction.this.partListener != null) {
                            window.getPartService().removePartListener(RunInBrowserPulldownAction.this.partListener);
                        }
                        if (RunInBrowserPulldownAction.this.selectionListener != null) {
                            window.getSelectionService().removeSelectionListener(RunInBrowserPulldownAction.this.selectionListener);
                        }
                    }
                    catch (Throwable e) {
                        IdeLog.logError((Plugin)UIPlugin.getDefault(), (Throwable)e);
                    }
                }

                public void windowActivated(IWorkbenchWindow window) {
                }
            });
        }
    }

    private void addListeners(IWorkbenchWindow window) {
        if (window != null) {
            this.partListener = new IPartListener(){

                public void partOpened(IWorkbenchPart part) {
                }

                public void partDeactivated(IWorkbenchPart part) {
                }

                public void partClosed(IWorkbenchPart part) {
                }

                public void partBroughtToTop(IWorkbenchPart part) {
                }

                public void partActivated(IWorkbenchPart part) {
                    try {
                        if (RunInBrowserPulldownAction.this.menuToolItem != null && !RunInBrowserPulldownAction.this.menuToolItem.isDisposed()) {
                            if (part instanceof IEditorPart) {
                                IEditorInput editorInput = ((IEditorPart)part).getEditorInput();
                                IPath file = (IPath)editorInput.getAdapter(IPath.class);
                                if (file != null && RunInBrowserUtil.isRunnable(file.toFile().getName())) {
                                    RunInBrowserPulldownAction.this.setEnabled(true);
                                    return;
                                }
                                RunInBrowserPulldownAction.this.setEnabled(false);
                            } else if (part.getSite() == null || part.getSite().getSelectionProvider() == null) {
                                RunInBrowserPulldownAction.this.setEnabled(false);
                            }
                        }
                    }
                    catch (Throwable e) {
                        IdeLog.logError((Plugin)UIPlugin.getDefault(), (Throwable)e);
                    }
                }
            };
            this.selectionListener = new ISelectionListener(){

                public void selectionChanged(IWorkbenchPart part, ISelection selection) {
                    try {
                        if (RunInBrowserPulldownAction.this.menuToolItem != null && !RunInBrowserPulldownAction.this.menuToolItem.isDisposed() && selection instanceof IStructuredSelection) {
                            Object object = ((IStructuredSelection)selection).getFirstElement();
                            if (object instanceof IFile) {
                                if (RunInBrowserUtil.isRunnable(((IFile)object).getName())) {
                                    RunInBrowserPulldownAction.this.setEnabled(true);
                                } else {
                                    RunInBrowserPulldownAction.this.setEnabled(false);
                                }
                            } else {
                                RunInBrowserPulldownAction.this.setEnabled(false);
                            }
                        }
                    }
                    catch (Throwable e) {
                        IdeLog.logError((Plugin)UIPlugin.getDefault(), (Throwable)e);
                    }
                }
            };
            window.getPartService().addPartListener(this.partListener);
            window.getSelectionService().addSelectionListener(this.selectionListener);
            this.propertyChangeListener = new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    try {
                        if ("LAST_BROWSER_NATURE".equals(event.getProperty()) && event.getNewValue() != null && !event.getNewValue().equals(event.getOldValue())) {
                            RunInBrowserPulldownAction.this.setImage();
                        }
                    }
                    catch (Throwable e) {
                        IdeLog.logError((Plugin)UIPlugin.getDefault(), (Throwable)e);
                    }
                }
            };
            UIPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(this.propertyChangeListener);
        }
    }

    public void setEnabled(boolean isEnable) {
        if (this.menuToolItem != null && !this.menuToolItem.isDisposed()) {
            this.menuToolItem.setEnabled(isEnable);
        }
    }

    public void setImage() {
        if (this.menuToolItem != null && !this.menuToolItem.isDisposed()) {
            String browserNature = RunInBrowserUtil.getLastBrowserNature();
            if (browserNature.equals("Chrome")) {
                this.menuToolItem.setImage(CHROME_IMAGE);
                this.menuToolItem.setDisabledImage(CHROME_DISABLE_IMAGE);
            } else if (browserNature.equals("Internet Explorer")) {
                this.menuToolItem.setImage(INTERNET_EXPLORER_IMAGE);
                this.menuToolItem.setDisabledImage(INTERNET_EXPLORER_DISABLE_IMAGE);
            } else if (browserNature.equals("Edge")) {
                this.menuToolItem.setImage(EDGE_IMAGE);
                this.menuToolItem.setDisabledImage(EDGE_DISABLE_IMAGE);
            } else if (browserNature.equals("Safari")) {
                this.menuToolItem.setImage(SAFARI_IMAGE);
                this.menuToolItem.setDisabledImage(SAFARI_DISABLE_IMAGE);
            } else if (browserNature.equals("Firefox")) {
                this.menuToolItem.setImage(FIREFOX_IMAGE);
                this.menuToolItem.setDisabledImage(FIREFOX_DISABLE_IMAGE);
            } else {
                this.menuToolItem.setImage(IETESTER_IMAGE);
                this.menuToolItem.setDisabledImage(IETESTER_DISABLE_IMAGE);
            }
        }
    }

    public void fill(final ToolBar parent, int index) {
        super.fill(parent, index);
        if (this.fMenu != null) {
            this.fMenu.dispose();
        }
        this.fMenu = new Menu((Decorations)parent.getShell(), 8);
        if (this.menuToolItem != null) {
            this.menuToolItem.dispose();
        }
        this.menuToolItem = new ToolItem(parent, 4);
        this.menuToolItem.setToolTipText(Messages.RunInBrowserPulldownAction_runInBrowser);
        this.menuToolItem.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (e.detail == 4) {
                    RunInBrowserPulldownAction.this.showMenu(parent, RunInBrowserPulldownAction.this.fMenu, RunInBrowserPulldownAction.this.menuToolItem);
                } else {
                    RunInBrowserPulldownAction.this.runBrower(null);
                }
            }
        });
        this.setImage();
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null) {
            IEditorInput editorInput;
            IPath file;
            Object object;
            ISelection selection = window.getSelectionService().getSelection();
            if (selection instanceof IStructuredSelection && (object = ((IStructuredSelection)selection).getFirstElement()) instanceof IFile && RunInBrowserUtil.isRunnable(((IFile)object).getName())) {
                this.setEnabled(true);
                return;
            }
            IWorkbenchPart part = window.getPartService().getActivePart();
            if (part instanceof IEditorPart && (file = (IPath)(editorInput = ((IEditorPart)part).getEditorInput()).getAdapter(IPath.class)) != null && RunInBrowserUtil.isRunnable(file.toFile().getName())) {
                this.setEnabled(true);
                return;
            }
        }
        this.setEnabled(false);
    }

    private void showMenu(ToolBar toolBar, Menu menu, ToolItem menuToolItem) {
        if (menu.getItemCount() == 0) {
            MenuItem ietester;
            MenuItem chrome = new MenuItem(menu, 64);
            chrome.setText("Chrome");
            chrome.setImage(CHROME_IMAGE);
            chrome.addSelectionListener((SelectionListener)new Selection("Chrome"));
            if (PlatformUtil.isWindows()) {
                MenuItem internet_explorer = new MenuItem(menu, 64);
                internet_explorer.setText("Internet Explorer");
                internet_explorer.setImage(INTERNET_EXPLORER_IMAGE);
                internet_explorer.addSelectionListener((SelectionListener)new Selection("Internet Explorer"));
                if (BrowserUtil.isEdgeExist()) {
                    MenuItem edge = new MenuItem(menu, 64);
                    edge.setText("Edge");
                    edge.setImage(EDGE_IMAGE);
                    edge.addSelectionListener((SelectionListener)new Selection("Edge"));
                }
            }
            MenuItem safari = new MenuItem(menu, 64);
            safari.setText("Safari");
            safari.setImage(SAFARI_IMAGE);
            safari.addSelectionListener((SelectionListener)new Selection("Safari"));
            MenuItem firefox = new MenuItem(menu, 64);
            firefox.setText("Firefox");
            firefox.setImage(FIREFOX_IMAGE);
            firefox.addSelectionListener((SelectionListener)new Selection("Firefox"));
            if (PlatformUtil.isWindows()) {
                ietester = new MenuItem(menu, 64);
                ietester.setText("IETester");
                ietester.setImage(IETESTER_IMAGE);
                ietester.addSelectionListener((SelectionListener)new Selection("IETester"));
            }
            ietester = new MenuItem(menu, 64);
            ietester.setText("\u8bbe\u7f6eweb\u670d\u52a1\u5668...");
            ietester.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ConfigWebServerhander.configWebServer();
                }
            });
        }
        Rectangle rect = menuToolItem.getBounds();
        Point pt = new Point(rect.x, rect.y + rect.height);
        pt = toolBar.toDisplay(pt);
        menu.setLocation(pt.x, pt.y);
        menu.setVisible(true);
    }

    private void runBrower(String browser) {
        try {
            if (StringUtil.isBlank((String)browser)) {
                if (CHROME_IMAGE.equals((Object)this.menuToolItem.getImage())) {
                    browser = "Chrome";
                } else if (INTERNET_EXPLORER_IMAGE.equals((Object)this.menuToolItem.getImage())) {
                    browser = "Internet Explorer";
                } else if (EDGE_IMAGE.equals((Object)this.menuToolItem.getImage())) {
                    browser = "Edge";
                } else if (SAFARI_IMAGE.equals((Object)this.menuToolItem.getImage())) {
                    browser = "Safari";
                } else if (FIREFOX_IMAGE.equals((Object)this.menuToolItem.getImage())) {
                    browser = "Firefox";
                } else if (IETESTER_IMAGE.equals((Object)this.menuToolItem.getImage())) {
                    browser = "IETester";
                }
            }
            RunInBrowserUtil.runInEnableRunner(browser);
        }
        finally {
            this.setImage();
        }
    }

    public void dispose() {
        try {
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (window != null) {
                if (this.partListener != null) {
                    window.getPartService().removePartListener(this.partListener);
                }
                if (this.selectionListener != null) {
                    window.getSelectionService().removeSelectionListener(this.selectionListener);
                }
            }
        }
        catch (Throwable e) {
            IdeLog.logError((Plugin)UIPlugin.getDefault(), (Throwable)e);
        }
        try {
            if (this.propertyChangeListener != null) {
                UIPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(this.propertyChangeListener);
            }
        }
        catch (Throwable e) {
            IdeLog.logError((Plugin)UIPlugin.getDefault(), (Throwable)e);
        }
        if (this.menuToolItem != null) {
            this.menuToolItem.dispose();
            this.menuToolItem = null;
        }
        if (this.fMenu != null) {
            this.fMenu.dispose();
            this.fMenu = null;
        }
    }

    private class Selection
    implements SelectionListener {
        public String brower;

        public Selection(String brower) {
            this.brower = brower;
        }

        public void widgetSelected(SelectionEvent e) {
            RunInBrowserPulldownAction.this.runBrower(this.brower);
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }
}

