/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ui;

import com.aptana.core.diagnostic.IDiagnosticLog;
import com.aptana.core.util.EclipseUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.ui.Messages;
import org.eclipse.core.runtime.Platform;

public class EclipseDiagnosticLog
implements IDiagnosticLog {
    private static final char NEW_LINE = '\n';

    public String getLog() {
        StringBuilder buf = new StringBuilder();
        buf.append(Messages.EclipseDiagnosticLog_host_os);
        buf.append(System.getProperty("os.name"));
        buf.append('\n');
        buf.append(Messages.EclipseDiagnosticLog_os_arch);
        buf.append(Platform.getOSArch());
        buf.append('\n');
        buf.append(Messages.EclipseDiagnosticLog_jre_version);
        buf.append(System.getProperty("java.version"));
        buf.append('\n');
        buf.append(Messages.EclipseDiagnosticLog_jre_vendor);
        buf.append(System.getProperty("java.vendor"));
        buf.append('\n');
        buf.append(Messages.EclipseDiagnosticLog_jre_home);
        buf.append(System.getProperty("java.home"));
        buf.append('\n');
        buf.append(Messages.EclipseDiagnosticLog_install_dir);
        buf.append(Platform.getInstallLocation().getURL());
        buf.append('\n');
        buf.append(Messages.EclipseDiagnosticLog_version);
        String version = EclipseUtil.getProductVersion();
        if (!StringUtil.isEmpty((String)version)) {
            buf.append(version);
        }
        buf.append('\n');
        buf.append(Messages.EclipseDiagnosticLog_vm_args);
        String property = System.getProperty("eclipse.vmargs");
        buf.append(property == null ? "" : property);
        buf.append('\n');
        buf.append(Messages.EclipseDiagnosticLog_workspace_dir);
        buf.append(Platform.getInstanceLocation().getURL());
        buf.append('\n');
        buf.append(Messages.EclipseDiagnosticLog_language);
        buf.append(Platform.getNL());
        buf.append('\n');
        return buf.toString();
    }
}

