/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.pack.core.download;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.StringUtil;
import com.pandora.core.utils.ResourceUtil;
import com.pandora.pack.core.PackActivator;
import com.pandora.pack.core.download.DownloadData;
import com.pandora.pack.core.download.DownloadStatus;
import com.pandora.pack.core.viewpack.PackageStatus;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.FileWriterWithEncoding;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Plugin;

public class DownloadDataManager {
    private static final ArrayBlockingQueue<DownloadData> queue = new ArrayBlockingQueue(50);
    private static DownloadDataManager downloadDataManager = new DownloadDataManager();
    private File downloadDataFile = PackActivator.getDefault().getBundle().getDataFile(".data");
    private static Document downloadDataDoc;

    private DownloadDataManager() {
        if (this.downloadDataFile.exists()) {
            SAXReader xmlReader = new SAXReader();
            try {
                List datas;
                downloadDataDoc = xmlReader.read(this.downloadDataFile);
                if (downloadDataDoc != null && (datas = downloadDataDoc.selectNodes("//data")) != null) {
                    for (Element data : datas) {
                        boolean downloading;
                        boolean bl = downloading = StringUtil.isBlank((String)data.attributeValue("downloading")) ? true : Boolean.parseBoolean(data.attributeValue("downloading"));
                        if (!downloading) continue;
                        queue.add(new DownloadData(data.attributeValue("id"), data.attributeValue("projectname"), downloading));
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else {
            try {
                this.downloadDataFile.createNewFile();
                downloadDataDoc = DocumentHelper.createDocument();
                downloadDataDoc.addElement("datalist");
                this.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static DownloadDataManager getInstance() {
        return downloadDataManager;
    }

    public DownloadData takeDataFromQueue() throws InterruptedException {
        DownloadData data = queue.take();
        return data;
    }

    public DownloadData getDataFromXml(String ticket) {
        if (StringUtil.isBlank((String)ticket)) {
            return null;
        }
        Element data = (Element)downloadDataDoc.selectSingleNode("//data[@id='" + ticket + "']");
        if (data != null) {
            boolean downloading = StringUtil.isBlank((String)data.attributeValue("downloading")) ? true : Boolean.parseBoolean(data.attributeValue("downloading"));
            return new DownloadData(data.attributeValue("id"), data.attributeValue("projectname"), downloading);
        }
        return null;
    }

    public synchronized void put(List<String> tickets, String projectName) throws IllegalStateException {
        Element root = downloadDataDoc.getRootElement();
        boolean changed = false;
        for (String ticket : tickets) {
            DownloadData data = new DownloadData(ticket, projectName, true);
            queue.add(data);
            Element exist = (Element)root.selectSingleNode("//data[@id='" + data.getId() + "']");
            if (exist != null) continue;
            changed = true;
            Element dataE = downloadDataDoc.getRootElement().addElement("data");
            dataE.addAttribute("id", data.getId());
            dataE.addAttribute("projectname", data.getProjectName());
            dataE.addAttribute("downloading", String.valueOf(data.isDownloading()));
        }
        if (changed) {
            this.flush();
        }
    }

    public void put(DownloadData data) throws IllegalStateException {
        queue.add(data);
    }

    public synchronized void removeDownloadData(DownloadData data) {
        Element exist = (Element)downloadDataDoc.selectSingleNode("//data[@id='" + data.getId() + "']");
        if (exist != null) {
            exist.getParent().remove(exist);
            this.flush();
        }
    }

    public synchronized void setDataDownloaded(DownloadData data) {
        Element exist = (Element)downloadDataDoc.selectSingleNode("//data[@id='" + data.getId() + "']");
        if (exist != null) {
            exist.attribute("downloading").setValue("false");
            this.flush();
        }
    }

    private void flush() {
        block5: {
            FileWriterWithEncoding out = null;
            try {
                try {
                    out = new FileWriterWithEncoding(this.downloadDataFile, Charset.forName("utf-8"));
                    downloadDataDoc.write((Writer)out);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    IOUtils.closeQuietly(out);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(out);
                throw throwable;
            }
            IOUtils.closeQuietly((Writer)out);
        }
    }

    public DownloadStatus getDownloadStatus(PackageStatus packageStatus, String projectName) {
        DownloadData download = DownloadDataManager.getInstance().getDataFromXml(packageStatus.getTicket());
        if (download != null) {
            if (download.isDownloading()) {
                try {
                    String folder = ResourceUtil.getAppProjectUnPackageDir((IProject)ResourcesPlugin.getWorkspace().getRoot().getProject(projectName), (String)"release", (String[])new String[0]).getLocation().toString();
                    File f = new File(folder, packageStatus.getPackageName());
                    if (f.exists() && f.isFile()) {
                        return DownloadStatus.SUCCESS;
                    }
                    return DownloadStatus.DOWNLOADING;
                }
                catch (Exception e) {
                    IdeLog.logError((Plugin)PackActivator.getDefault(), (Throwable)e);
                }
            }
            return download.isDownloading() ? DownloadStatus.DOWNLOADING : DownloadStatus.SUCCESS;
        }
        if ("OK".equals(packageStatus.getStatus()) && StringUtil.isNotBlank((String)projectName) && StringUtil.isNotBlank((String)packageStatus.getPackageName())) {
            return DownloadStatus.SUCCESS;
        }
        return DownloadStatus.FAILED;
    }
}

