/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.view.browser.console;

import com.pandora.view.browser.console.WebConsole;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleFactory;
import org.eclipse.ui.console.IConsoleManager;

public class WebConsoleFactory
implements IConsoleFactory {
    private final IConsoleManager fConsoleManager = ConsolePlugin.getDefault().getConsoleManager();
    private static WebConsole fConsole = null;

    public void openConsole() {
        WebConsole console = this.getConsole(true, true);
        this.fConsoleManager.showConsoleView((IConsole)console);
    }

    public synchronized WebConsole getConsole(boolean create, boolean add) {
        WebConsole console = null;
        if (fConsole != null && !fConsole.isDispose()) {
            console = fConsole;
        } else if (create) {
            fConsole = new WebConsole(this);
            fConsole.init();
            console = fConsole;
        }
        if (add && console != null) {
            IConsole[] existing = this.fConsoleManager.getConsoles();
            boolean exists = false;
            int i = 0;
            while (i < existing.length) {
                if (console == existing[i]) {
                    exists = true;
                }
                ++i;
            }
            if (!exists) {
                this.fConsoleManager.addConsoles(new IConsole[]{console});
            }
        }
        return console;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeConsole(WebConsole console) {
        WebConsoleFactory webConsoleFactory = this;
        synchronized (webConsoleFactory) {
            if (console != fConsole) {
                throw new IllegalArgumentException("Wrong console instance!");
            }
            fConsole = null;
        }
        this.fConsoleManager.removeConsoles(new IConsole[]{console});
    }
}

