/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.view.browser;

import com.pandora.core.log.HBLog;
import com.pandora.view.browser.BrowserActivator;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.osgi.framework.Bundle;

public final class ImageManager {
    public static final String IMG_BROWSER = "IMG_BROWSER";
    public static final String IMG_CONSOLE = "IMG_CONSOLE";
    public static final String IMG_QR = "IMG_QR";
    public static final String IMG_LOCK = "IMG_LOCK";
    public static final String IMG_UNLOCK = "IMG_UNLOCK";
    public static final String IMG_BACKWARD = "IMG_BACKWARD";
    public static final String IMG_FORWARD = "IMG_FORWARD";
    public static final String IMG_STOP = "IMG_STOP";
    public static final String IMG_REFRESH = "IMG_REFRESH";
    public static final String IMG_GO = "IMG_GO";
    public static final String IMG_HOME = "IMG_HOME";
    public static final String IMG_COMMAND = "IMG_COMMAND";
    private static final String URL_IMAGES = "/icons/";
    private static ImageRegistry imageRegistry;

    private ImageManager() {
    }

    private static void regImage(String key, String url) {
        try {
            URL imageUrl = FileLocator.find((Bundle)BrowserActivator.getDefault().getBundle(), (IPath)new Path(url), null);
            ImageDescriptor id = ImageDescriptor.createFromURL((URL)imageUrl);
            imageRegistry.put(key, id);
        }
        catch (Exception e) {
            HBLog.logError((Plugin)BrowserActivator.getDefault(), (Throwable)e);
        }
    }

    private static void initImageReg() {
        imageRegistry = new ImageRegistry();
        ImageManager.regImage(IMG_CONSOLE, "/icons/nav_console.png");
        ImageManager.regImage(IMG_QR, "/icons/nav_qr.png");
        ImageManager.regImage(IMG_LOCK, "/icons/nav_lock.png");
        ImageManager.regImage(IMG_UNLOCK, "/icons/nav_unlock.png");
        ImageManager.regImage(IMG_BACKWARD, "/icons/nav_backward.png");
        ImageManager.regImage(IMG_FORWARD, "/icons/nav_forward.png");
        ImageManager.regImage(IMG_STOP, "/icons/nav_stop.gif");
        ImageManager.regImage(IMG_REFRESH, "/icons/nav_refresh.png");
        ImageManager.regImage(IMG_GO, "/icons/nav_go.png");
        ImageManager.regImage(IMG_HOME, "/icons/nav_home.gif");
        ImageManager.regImage(IMG_COMMAND, "/icons/command.png");
        ImageManager.regImage(IMG_BROWSER, "/icons/browser.png");
    }

    public static Image getImage(String key) {
        if (imageRegistry == null) {
            ImageManager.initImageReg();
        }
        return imageRegistry.get(key);
    }

    public static ImageDescriptor getImageDescriptor(String key) {
        if (imageRegistry == null) {
            ImageManager.initImageReg();
        }
        return imageRegistry.getDescriptor(key);
    }
}

