/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.index.core.filter;

import com.aptana.core.IFilter;
import com.aptana.core.IMap;
import com.aptana.core.io.efs.EFSUtils;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.EclipseUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.index.core.IndexPlugin;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.osgi.service.prefs.BackingStoreException;

public class IndexFilterManager {
    private static final String ITEM_DELIMITER = "\u0000";
    private static final String PREF_NODE = "com.aptana.index.core.ui";
    private static IndexFilterManager INSTANCE;
    private Set<IFileStore> _filteredItems = this.loadFilteredItems();

    public static synchronized IndexFilterManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new IndexFilterManager();
        }
        return INSTANCE;
    }

    private IndexFilterManager() {
    }

    public void addFilterItem(IFileStore item) {
        if (item == null) {
            return;
        }
        if (!this.isFilteredItem(item)) {
            HashSet<IFileStore> toRemove = new HashSet<IFileStore>(this._filteredItems.size());
            for (IFileStore candidate : this._filteredItems) {
                if (!item.isParentOf(candidate)) continue;
                toRemove.add(candidate);
            }
            this._filteredItems.removeAll(toRemove);
            this._filteredItems.add(item);
        }
    }

    public void commitFilteredItems() {
        List uris = CollectionsUtil.map(this._filteredItems, (IMap)new IMap<IFileStore, String>(){

            public String map(IFileStore item) {
                URI uri = item.toURI();
                return uri.toString();
            }
        });
        String value = StringUtil.join((String)ITEM_DELIMITER, (Collection)uris);
        IEclipsePreferences prefs = EclipseUtil.instanceScope().getNode(PREF_NODE);
        prefs.put("FILTERED_INDEX_URIS", value);
        try {
            prefs.flush();
        }
        catch (BackingStoreException backingStoreException) {}
    }

    protected Set<IFileStore> applyFilter(Set<IFileStore> fileStores) {
        this._filteredItems = this.loadFilteredItems();
        if (CollectionsUtil.isEmpty(this._filteredItems) || fileStores == null) {
            return fileStores;
        }
        final IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        CollectionsUtil.filterInPlace(fileStores, (IFilter)new IFilter<IFileStore>(){

            public boolean include(IFileStore item) {
                IContainer[] iContainerArray = workspaceRoot.findContainersForLocationURI(item.toURI());
                int n = iContainerArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IContainer container = iContainerArray[n2];
                    IFileStore workspaceFileStore = EFSUtils.getFileStore((IResource)container);
                    if (IndexFilterManager.this.isFilteredItem(workspaceFileStore)) {
                        return false;
                    }
                    ++n2;
                }
                return true;
            }
        });
        return fileStores;
    }

    protected void addProjectFilters(IWorkspaceRoot workspaceRoot) {
        IProject[] projects = workspaceRoot.getProjects();
        String pattern = "workspace:/{0}/bin";
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            String urlString = MessageFormat.format(pattern, project.getName());
            try {
                URI uri = new URI(urlString);
                IFileStore item = EFS.getStore((URI)uri);
                if (item.fetchInfo().exists()) {
                    this._filteredItems.add(item);
                }
            }
            catch (URISyntaxException e) {
                IdeLog.logError((Plugin)IndexPlugin.getDefault(), (String)e.getMessage(), (Throwable)e);
            }
            catch (CoreException e) {
                IdeLog.logError((Plugin)IndexPlugin.getDefault(), (Throwable)e);
            }
            ++n2;
        }
    }

    public Set<IFileStore> getFilteredItems() {
        return CollectionsUtil.getSetValue(this._filteredItems);
    }

    public boolean isFilteredItem(IFileStore item) {
        if (item != null) {
            for (IFileStore candidate : this.getFilteredItems()) {
                if (!candidate.equals(item) && !candidate.isParentOf(item)) continue;
                return true;
            }
        }
        return false;
    }

    private Set<IFileStore> loadFilteredItems() {
        String uris = Platform.getPreferencesService().getString(PREF_NODE, "FILTERED_INDEX_URIS", null, null);
        if (StringUtil.isEmpty((String)uris)) {
            return new HashSet<IFileStore>(0);
        }
        String[] urisSplit = uris.split(ITEM_DELIMITER);
        HashSet<IFileStore> filteredItems = new HashSet<IFileStore>(urisSplit.length);
        String[] stringArray = urisSplit;
        int n = urisSplit.length;
        int n2 = 0;
        while (n2 < n) {
            String uriString = stringArray[n2];
            try {
                URI uri = new URI(uriString);
                IFileStore item = EFS.getStore((URI)uri);
                if (item.fetchInfo().exists()) {
                    filteredItems.add(item);
                }
            }
            catch (URISyntaxException e) {
                IdeLog.logError((Plugin)IndexPlugin.getDefault(), (String)e.getMessage(), (Throwable)e);
            }
            catch (CoreException e) {
                IdeLog.logError((Plugin)IndexPlugin.getDefault(), (Throwable)e);
            }
            ++n2;
        }
        return filteredItems;
    }

    public void removeFilterItem(IFileStore item) {
        if (item != null && this._filteredItems != null) {
            this._filteredItems.remove(item);
        }
    }

    public void removeIndex(List<IFileStore> fileStoreList) {
        if (CollectionsUtil.isEmpty(fileStoreList)) {
            return;
        }
        HashMap uriMap = new HashMap();
        for (IFileStore item : fileStoreList) {
            IResource resource = (IResource)item.getAdapter(IResource.class);
            if (resource == null || !resource.exists()) continue;
            IProject project = resource.getProject();
            if (resource instanceof IProject) {
                IndexPlugin.getDefault().getIndexManager().removeProjectIndex(project);
                continue;
            }
            if (resource instanceof IFile) {
                ArrayList<URI> uriList = (ArrayList<URI>)uriMap.get(project);
                if (CollectionsUtil.isEmpty((Collection)uriList)) {
                    uriList = new ArrayList<URI>();
                }
                uriList.add(resource.getLocationURI());
                uriMap.put(project, uriList);
                continue;
            }
            if (!(resource instanceof IFolder)) continue;
            try {
                IFileStore[] fileStores = EFSUtils.getFiles((IFileStore)item, (boolean)true, (boolean)false);
                ArrayList<URI> uriList = (ArrayList<URI>)uriMap.get(project);
                if (CollectionsUtil.isEmpty((Collection)uriList)) {
                    uriList = new ArrayList<URI>();
                }
                IFileStore[] iFileStoreArray = fileStores;
                int n = fileStores.length;
                int n2 = 0;
                while (n2 < n) {
                    IFileStore store = iFileStoreArray[n2];
                    uriList.add(((IResource)store.getAdapter(IResource.class)).getLocationURI());
                    ++n2;
                }
                uriMap.put(project, uriList);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (IProject project : uriMap.keySet()) {
            IndexPlugin.getDefault().getIndexManager().removeBuildPathContributor(project, (List)uriMap.get(project));
        }
    }
}

