/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.index.core.build;

import com.aptana.build.util.BuildHelper;
import com.aptana.core.IFilter;
import com.aptana.core.build.IProblem;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.ArrayUtil;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.EclipseUtil;
import com.aptana.core.util.IOUtil;
import com.aptana.index.core.IndexPlugin;
import com.aptana.parsing.IParseState;
import com.aptana.parsing.ParseResult;
import com.aptana.parsing.ParseState;
import com.aptana.parsing.ParserPoolFactory;
import com.aptana.parsing.WorkingParseResult;
import com.aptana.parsing.ast.IParseError;
import com.aptana.parsing.ast.IParseRootNode;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeMatcher;

public class BuildContext {
    public static final IContentType[] NO_CONTENT_TYPES = new IContentType[0];
    private IFile file;
    protected Map<String, Collection<IProblem>> problems = new HashMap<String, Collection<IProblem>>();
    private ParseResult fParseResult;
    private Boolean save;
    private String fContents;
    private boolean isFullBuild;
    private boolean isCompleted;
    private boolean needSleep;
    private boolean isHighPriority;
    private boolean isOpenManualValidator;
    private ParseState parseState;

    public boolean isNeedSleep() {
        return this.needSleep;
    }

    public void setNeedSleep(boolean needSleep) {
        this.needSleep = needSleep;
    }

    public ParseState getParseState() {
        return this.parseState;
    }

    public void setParseState(ParseState parseState) {
        this.parseState = parseState;
    }

    public boolean isCompleted() {
        return this.isCompleted;
    }

    public void setCompleted(boolean isCompleted) {
        this.isCompleted = isCompleted;
    }

    public boolean isFullBuild() {
        return this.isFullBuild;
    }

    public void setFullBuild(boolean isFullBuild) {
        this.isFullBuild = isFullBuild;
    }

    protected BuildContext() {
    }

    public BuildContext(IFile file) {
        this();
        this.file = file;
        this.isFullBuild = false;
        this.isCompleted = false;
    }

    public BuildContext(IFile file, boolean isFullBuild) {
        this();
        this.file = file;
        this.isFullBuild = isFullBuild;
        this.isCompleted = false;
    }

    public IProject getProject() {
        IFile file = this.getFile();
        if (file == null) {
            return null;
        }
        return file.getProject();
    }

    public IFile getFile() {
        return this.file;
    }

    public URI getURI() {
        IFile file = this.getFile();
        if (file == null) {
            return null;
        }
        return file.getLocationURI();
    }

    public boolean isSave() {
        return this.save != null && this.save != false;
    }

    public void setSave(Boolean save) {
        this.save = save != null && save != false;
    }

    public IParseRootNode getAST() throws CoreException {
        if (this.getParseState() != null) {
            return this.getAST((IParseState)this.getParseState()).getRootNode();
        }
        return this.getAST((IParseState)new ParseState(this.getContents())).getRootNode();
    }

    public synchronized ParseResult getAST(IParseState parseState) throws CoreException {
        try {
            try {
                WorkingParseResult working = new WorkingParseResult();
                if (this.isNeedSleep()) {
                    parseState.setNeedSleep(true);
                }
                this.fParseResult = this.parse(this.getContentType(), parseState, working);
            }
            catch (CoreException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CoreException((IStatus)new Status(4, "com.aptana.index.core", e.getMessage(), (Throwable)e));
            }
            if (this.fParseResult == null) {
                ParseResult parseResult = ParseResult.EMPTY;
                return parseResult;
            }
            ParseResult parseResult = this.fParseResult;
            return parseResult;
        }
        finally {
            if (parseState != null) {
                parseState.clearEditState();
            }
        }
    }

    protected ParseResult parse(String contentType, IParseState parseState, WorkingParseResult working) throws Exception {
        return ParserPoolFactory.parse((String)contentType, (IParseState)parseState);
    }

    public synchronized void resetAST() {
        this.fParseResult = null;
    }

    public synchronized String getContents() {
        if (this.fContents == null) {
            try {
                this.fContents = IOUtil.read((InputStream)this.openInputStream((IProgressMonitor)new NullProgressMonitor()), (String)this.getCharset());
            }
            catch (CoreException coreException) {
                this.fContents = "";
            }
        }
        return this.fContents;
    }

    public String getCharset() throws CoreException {
        IFile file = this.getFile();
        if (file == null) {
            return null;
        }
        return file.getCharset(true);
    }

    public String getContentType() throws CoreException {
        Object[] types = this.getContentTypes();
        if (ArrayUtil.isEmpty((Object[])types)) {
            return null;
        }
        return types[0].getId();
    }

    protected IContentType[] getContentTypes() throws CoreException {
        IProject theProject = this.getProject();
        if (theProject != null) {
            IContentTypeMatcher matcher = theProject.getContentTypeMatcher();
            return matcher.findContentTypesFor(this.getName());
        }
        Object[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        if (ArrayUtil.isEmpty((Object[])projects)) {
            return Platform.getContentTypeManager().findContentTypesFor(this.getName());
        }
        Object[] objectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            Object project = objectArray[n2];
            try {
                IContentType[] type = project.getContentTypeMatcher().findContentTypesFor(this.getName());
                if (type != null) {
                    return type;
                }
            }
            catch (CoreException e) {
                IdeLog.logError((Plugin)IndexPlugin.getDefault(), (Throwable)e);
            }
            ++n2;
        }
        return NO_CONTENT_TYPES;
    }

    public String getName() {
        IFile file = this.getFile();
        if (file == null) {
            return null;
        }
        return file.getName();
    }

    public void removeProblems(String markerType) {
        this.problems.remove(markerType);
    }

    public void putProblems(String markerType, Collection<IProblem> problems) {
        boolean includeWarning = EclipseUtil.defaultScope().getNode("com.aptana.index.core").getBoolean("PREFERENCE_PROBLEM_INCLUDE_WARNING", true);
        if (!includeWarning) {
            final int[] counts = new int[]{0};
            problems = CollectionsUtil.filter(problems, (IFilter)new IFilter<IProblem>(){

                public boolean include(IProblem item) {
                    if (BuildContext.this.isNeedSleep()) {
                        counts[0] = counts[0] + 1;
                        BuildHelper.sleepLoop((String)"TASK_TYPE", (int)counts[0]);
                    }
                    return item.getSeverity() != IProblem.Severity.WARNING || item.isQuickFixable();
                }
            });
        }
        this.problems.put(markerType, problems);
    }

    public Map<String, Collection<IProblem>> getProblems() {
        return Collections.unmodifiableMap(this.problems);
    }

    public Collection<IParseError> getParseErrors() {
        if (this.fParseResult == null) {
            return Collections.emptyList();
        }
        return this.fParseResult.getErrors();
    }

    public InputStream openInputStream(IProgressMonitor monitor) throws CoreException {
        IFile file = this.getFile();
        if (file == null) {
            return new ByteArrayInputStream(ArrayUtil.NO_BYTES);
        }
        try {
            file.refreshLocal(0, null);
        }
        catch (Throwable throwable) {}
        if (!file.exists()) {
            return new ByteArrayInputStream(ArrayUtil.NO_BYTES);
        }
        try {
            return file.getContents();
        }
        catch (Exception e) {
            IdeLog.logWarning((Plugin)IndexPlugin.getDefault(), (String)"Error while opening the input stream.", (Throwable)e, (String)"com.aptana.index.core/debug/indexer");
            return new ByteArrayInputStream(ArrayUtil.NO_BYTES);
        }
    }

    public boolean isOpenManualValidator() {
        return this.isOpenManualValidator;
    }

    public void setOpenManualValidator(boolean isOpenManualValidator) {
        this.isOpenManualValidator = isOpenManualValidator;
    }

    public boolean isReconcile() {
        return false;
    }

    public boolean isHighPriority() {
        return this.isHighPriority;
    }

    public void setHighPriority(boolean isHighPriority) {
        this.isHighPriority = isHighPriority;
    }
}

