/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.index.core;

import com.aptana.core.util.CollectionsUtil;
import java.lang.reflect.Field;
import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.internal.refresh.RefreshJob;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;

public class JobNotice
extends JobChangeAdapter {
    private static JobNotice instance;
    public static final QualifiedName BIG_PROJECT_KEY;
    private Map<IProject, Long> refreshProjects = new HashMap<IProject, Long>();

    static {
        BIG_PROJECT_KEY = new QualifiedName("project", "big");
    }

    public static synchronized JobNotice getInstance() {
        if (instance == null) {
            instance = new JobNotice();
        }
        return instance;
    }

    public boolean isRefresh(URI uri) {
        if (uri == null) {
            return false;
        }
        if (!this.refreshProjects.isEmpty()) {
            IProject project = this.refreshProjects.keySet().iterator().next();
            return uri.equals(project.getLocationURI());
        }
        return false;
    }

    public void aboutToRun(IJobChangeEvent event) {
        if (event.getJob() instanceof RefreshJob) {
            RefreshJob ref = (RefreshJob)event.getJob();
            try {
                Field[] fields;
                Field[] fieldArray = fields = ref.getClass().getDeclaredFields();
                int n = fields.length;
                int n2 = 0;
                while (n2 < n) {
                    Field f = fieldArray[n2];
                    if ("fRequests".equals(f.getName())) {
                        this.refreshProjects.clear();
                        f.setAccessible(true);
                        List fRequests = (List)f.get(ref);
                        if (CollectionsUtil.isNotEmpty((Collection)fRequests) && fRequests.size() == 1 && fRequests.get(0) instanceof IProject) {
                            this.refreshProjects.put((IProject)fRequests.get(0), System.currentTimeMillis());
                        }
                        break;
                    }
                    ++n2;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void done(IJobChangeEvent event) {
        if (event.getJob() instanceof RefreshJob) {
            try {
                if (!this.refreshProjects.isEmpty()) {
                    IProject refreshProject = this.refreshProjects.keySet().iterator().next();
                    if (event.getResult().getSeverity() == 8) {
                        refreshProject.setPersistentProperty(BIG_PROJECT_KEY, Boolean.toString(true));
                    } else {
                        Long refreshStartTime = this.refreshProjects.get(refreshProject);
                        if (System.currentTimeMillis() - refreshStartTime > 5000L) {
                            refreshProject.setPersistentProperty(BIG_PROJECT_KEY, Boolean.toString(true));
                        }
                    }
                    this.refreshProjects.clear();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

