/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.index.core;

import com.aptana.core.CorePlugin;
import com.aptana.core.logging.IdeLog;
import com.aptana.index.core.AbstractFileIndexingParticipant;
import com.aptana.index.core.Index;
import com.aptana.index.core.IndexPlugin;
import com.aptana.index.core.RemoteIndexProcessStateHelper;
import com.aptana.index.core.build.BuildContext;
import com.aptana.parsing.IParseState;
import com.aptana.parsing.ParseResult;
import com.aptana.parsing.ParseState;
import com.aptana.parsing.ParserPoolFactory;
import com.aptana.parsing.ast.IParseRootNode;
import com.pandora.index.service.ILocalIndexService;
import com.pandora.index.service.IRemoteIndexService;
import com.pandora.index.service.IndexRequest;
import com.pandora.index.service.IndexServicePlugin;
import java.net.URI;
import java.rmi.ConnectException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.osgi.framework.BundleActivator;

public abstract class AbstractRemoteFileIndexingParticipant
extends AbstractFileIndexingParticipant {
    public boolean debug = Platform.inDebugMode();
    protected Map<String, Set<String>> indexResult = new HashMap<String, Set<String>>();

    protected void addIndex(String category, String word) {
        Set<Object> words = null;
        if (!this.indexResult.containsKey(category)) {
            words = new HashSet();
            this.indexResult.put(category, words);
        } else {
            words = this.indexResult.get(category);
        }
        words.add(word);
    }

    public void submitIndex(IndexRequest request) {
        try {
            if (this.indexResult.isEmpty()) {
                return;
            }
            try {
                ILocalIndexService localIndexService = AbstractRemoteFileIndexingParticipant.getLocalIndexService();
                request.setContents(null);
                localIndexService.submitIndex(request, this.indexResult);
            }
            catch (Exception e) {
                IdeLog.logError((Plugin)CorePlugin.getDefault(), (Throwable)e);
            }
        }
        finally {
            this.indexResult.clear();
        }
    }

    public void saveIndex(IndexRequest request, Index index) {
        if (this.indexResult.isEmpty()) {
            return;
        }
        try {
            try {
                for (String category : this.indexResult.keySet()) {
                    Set<String> words = this.indexResult.get(category);
                    if (words == null) continue;
                    for (String word : words) {
                        this.addIndex(index, request.getIndexURI(), category, word);
                    }
                }
            }
            catch (Exception e) {
                IdeLog.logError((Plugin)IndexPlugin.getDefault(), (Throwable)e);
                this.indexResult.clear();
            }
        }
        finally {
            this.indexResult.clear();
        }
    }

    @Override
    public final void index(BuildContext context, Index index, IProgressMonitor monitor) throws CoreException {
        boolean success = false;
        IndexRequest request = new IndexRequest();
        request.setCharset(context.getCharset());
        request.setIndexURI(context.getURI());
        request.setNeedSleep(context.isNeedSleep());
        request.setReconcile(context.isReconcile());
        request.setHighPriority(context.isReconcile() || context.isHighPriority());
        if (context.isReconcile()) {
            request.setContents(context.getContents());
        }
        if (context.getProject() != null) {
            request.setProjectURI(context.getProject().getLocationURI());
        }
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        if (RemoteIndexProcessStateHelper.isRunning()) {
            block8: {
                sub.subTask("Remote " + this.getIndexingMessage(request.getProjectURI(), request.getIndexURI()));
                try {
                    if (this.debug) {
                        request.setRequestTime(System.currentTimeMillis());
                        System.out.println(">>> request >>> " + request.getIndexURI());
                    }
                    IRemoteIndexService remoteIndexService = AbstractRemoteFileIndexingParticipant.getRemoteIndexService();
                    remoteIndexService.index(request);
                    success = true;
                }
                catch (Exception e) {
                    IdeLog.logError((Plugin)IndexPlugin.getDefault(), (String)("" + e));
                    if (!(e instanceof ConnectException)) break block8;
                    RemoteIndexProcessStateHelper.setState(0);
                    RemoteIndexProcessStateHelper.startIndexProcess();
                    this.restartRemoteService();
                }
            }
            if (!success) {
                this.offlineIndex(index, monitor, request);
            }
        } else {
            sub.subTask("Local " + this.getIndexingMessage(request.getProjectURI(), request.getIndexURI()));
            this.offlineIndex(index, monitor, request);
        }
    }

    public void offlineIndex(Index index, IProgressMonitor monitor, IndexRequest request) {
        request.setHBuilder(true);
        this.deleteFileIndex(request);
        this.requestIndex(request, monitor);
        this.saveIndex(request, index);
    }

    protected void restartRemoteService() {
        try {
            IndexServicePlugin.getDefault().restartRemoteService();
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)CorePlugin.getDefault(), (String)"restart RemoteService failed!", (Throwable)e);
        }
    }

    protected Index getIndex(IndexRequest request) {
        if (request.isHBuilder()) {
            return IndexPlugin.getDefault().getIndexManager().getIndex(request.getProjectURI());
        }
        return Index.getSimpleIndex(request.getProjectURI());
    }

    protected static ILocalIndexService getLocalIndexService() throws Exception {
        return IndexServicePlugin.getDefault().getLocalIndexService((BundleActivator)IndexPlugin.getDefault());
    }

    protected static IRemoteIndexService getRemoteIndexService() throws Exception {
        return IndexServicePlugin.getDefault().getRemoteIndexService((BundleActivator)IndexPlugin.getDefault());
    }

    protected IParseRootNode getAST(ParseState parseState, String contentType) throws CoreException {
        ParseResult fParseResult;
        try {
            try {
                fParseResult = ParserPoolFactory.parse((String)contentType, (IParseState)parseState);
            }
            catch (CoreException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CoreException((IStatus)new Status(4, "com.aptana.index.core", e.getMessage(), (Throwable)e));
            }
        }
        finally {
            if (parseState != null) {
                parseState.clearEditState();
            }
        }
        if (fParseResult == null) {
            fParseResult = ParseResult.EMPTY;
        }
        return fParseResult.getRootNode();
    }

    @Override
    protected final void addIndex(Index index, URI uri, String category, String word) {
        super.addIndex(index, uri, category, word);
    }

    public abstract void requestIndex(IndexRequest var1, IProgressMonitor var2);

    public boolean deleteFileIndex(IndexRequest request) {
        try {
            if (request.isHBuilder()) {
                Index index = IndexPlugin.getDefault().getIndexManager().getIndex(request.getProjectURI());
                if (index != null) {
                    index.remove(request.getIndexURI());
                }
            } else {
                AbstractRemoteFileIndexingParticipant.getLocalIndexService().deleteFileIndex(request);
            }
            return true;
        }
        catch (Exception e1) {
            e1.printStackTrace();
            return false;
        }
    }
}

