/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.webserver.internal.core;

import com.aptana.core.IFilter;
import com.aptana.core.epl.IMemento;
import com.aptana.core.epl.XMLMemento;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.EclipseUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.webserver.core.AliasServer;
import com.aptana.webserver.core.IServer;
import com.aptana.webserver.core.IServerChangeListener;
import com.aptana.webserver.core.IServerManager;
import com.aptana.webserver.core.IServerType;
import com.aptana.webserver.core.ServerChangeEvent;
import com.aptana.webserver.core.WebServerCorePlugin;
import com.aptana.webserver.internal.core.ServerType;
import com.pandora.core.utils.RegistryUtils;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.osgi.service.prefs.BackingStoreException;

public final class ServerManager
implements IServerManager {
    public static final String STATE_FILENAME = "webservers";
    private static final String EXTENSION_POINT_ID = "com.aptana.webserver.core.webServerTypes";
    public static final String PREFIXS_SERVER_POINT_ID = "com.aptana.webserver.core.serverPrefix";
    private static final String TAG_TYPE = "type";
    public static final String ATT_ID = "id";
    private static final String ATT_CLASS = "class";
    public static final String ATT_NAME = "name";
    private static final String ELEMENT_ROOT = "servers";
    private static final String ELEMENT_SERVER = "server";
    private static final String ATTR_TYPE = "type";
    private Map<String, IConfigurationElement> configurationElements = new HashMap<String, IConfigurationElement>();
    private List<IServerType> types = new ArrayList<IServerType>();
    private List<IServer> serverConfigurations = new CopyOnWriteArrayList<IServer>();
    private List<IMemento> unresolvedElements = new ArrayList<IMemento>();
    private ListenerList listeners = new ListenerList(1);
    private List<AliasServer> aliasServers = new ArrayList<AliasServer>();

    public ServerManager() {
        this.readExtensionRegistry();
    }

    private void readExtensionRegistry() {
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_POINT_ID);
        int i = 0;
        while (i < elements.length) {
            this.readElement(elements[i], "type");
            ++i;
        }
        try {
            List es;
            if (this.aliasServers.isEmpty() && !(es = RegistryUtils.getEp((String)PREFIXS_SERVER_POINT_ID, (String)"prefix")).isEmpty()) {
                Collections.sort(es, new Comparator<IConfigurationElement>(){

                    @Override
                    public int compare(IConfigurationElement o1, IConfigurationElement o2) {
                        String order2;
                        String order1 = o1.getAttribute("order");
                        return order1 == (order2 = o2.getAttribute("order")) ? 0 : (order1 == null && order2 != null ? -1 : order1.compareTo(order2));
                    }
                });
                for (IConfigurationElement element : es) {
                    try {
                        String alias = element.getAttribute(ATT_NAME);
                        int order = Integer.parseInt(element.getAttribute("order"));
                        boolean enableBuildin = Boolean.parseBoolean(element.getAttribute("enableBuildin"));
                        String contentType = element.getAttribute("contentType");
                        this.aliasServers.add(new AliasServer(alias, order, enableBuildin, contentType));
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private void readElement(IConfigurationElement element, String elementName) {
        if (!elementName.equals(element.getName())) {
            return;
        }
        if ("type".equals(element.getName())) {
            String id = element.getAttribute(ATT_ID);
            if (id == null || id.length() == 0) {
                return;
            }
            String name = element.getAttribute(ATT_NAME);
            if (name == null || name.length() == 0) {
                return;
            }
            String clazz = element.getAttribute(ATT_CLASS);
            if (clazz == null || clazz.length() == 0) {
                return;
            }
            this.configurationElements.put(id, element);
            this.types.add(new ServerType(id, name));
        }
    }

    public void loadState(IPath path) {
        block25: {
            File file = path.toFile();
            if (file.exists()) {
                this.serverConfigurations.clear();
                FileReader reader = null;
                try {
                    reader = new FileReader(file);
                    XMLMemento memento = XMLMemento.createReadRoot((Reader)reader);
                    IMemento[] iMementoArray = memento.getChildren(ELEMENT_SERVER);
                    int n = iMementoArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IMemento child = iMementoArray[n2];
                        IServer serverConfiguration = this.restoreServerConfiguration(child, null);
                        if (serverConfiguration != null) {
                            this.serverConfigurations.add(serverConfiguration);
                        } else {
                            this.unresolvedElements.add(child);
                        }
                        ++n2;
                    }
                }
                catch (IOException e) {
                    IdeLog.logError((Plugin)WebServerCorePlugin.getDefault(), (Throwable)e);
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException e2) {
                            IdeLog.logError((Plugin)WebServerCorePlugin.getDefault(), (Throwable)e2);
                        }
                    }
                    break block25;
                }
                catch (CoreException e) {
                    try {
                        IdeLog.logError((Plugin)WebServerCorePlugin.getDefault(), (Throwable)e);
                        break block25;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (IOException e3) {
                                IdeLog.logError((Plugin)WebServerCorePlugin.getDefault(), (Throwable)e3);
                            }
                        }
                    }
                }
                if (reader == null) break block25;
                try {
                    reader.close();
                }
                catch (IOException e) {
                    IdeLog.logError((Plugin)WebServerCorePlugin.getDefault(), (Throwable)e);
                }
            }
        }
        if (!this.aliasServers.isEmpty()) {
            IEclipsePreferences node = EclipseUtil.instanceScope().getNode("com.aptana.webserver.core");
            for (AliasServer aliasServer : this.aliasServers) {
                try {
                    String serverName = node.get("RUNINBROWSER_SERVER_PREFIX_" + aliasServer.getAlias(), null);
                    aliasServer.setServer(this.findServerByName(serverName));
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveState(IPath path) {
        block23: {
            XMLMemento memento = XMLMemento.createWriteRoot((String)ELEMENT_ROOT);
            List<IServer> list = this.serverConfigurations;
            synchronized (list) {
                for (IServer serverConfiguration : this.serverConfigurations) {
                    if (!serverConfiguration.isPersistent() || !this.configurationElements.containsKey(serverConfiguration.getId())) continue;
                    IMemento child = memento.createChild(ELEMENT_SERVER);
                    child.putMemento(this.storeServerConfiguration(serverConfiguration));
                }
            }
            list = this.unresolvedElements;
            synchronized (list) {
                for (IMemento child : this.unresolvedElements) {
                    memento.copyChild(child);
                }
            }
            FileWriter writer = null;
            try {
                try {
                    writer = new FileWriter(path.toFile());
                    memento.save((Writer)writer);
                }
                catch (IOException e) {
                    IdeLog.logError((Plugin)WebServerCorePlugin.getDefault(), (Throwable)e);
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (IOException e2) {
                            IdeLog.logError((Plugin)WebServerCorePlugin.getDefault(), (Throwable)e2);
                        }
                    }
                    break block23;
                }
            }
            catch (Throwable throwable) {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException e) {
                        IdeLog.logError((Plugin)WebServerCorePlugin.getDefault(), (Throwable)e);
                    }
                }
                throw throwable;
            }
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    IdeLog.logError((Plugin)WebServerCorePlugin.getDefault(), (Throwable)e);
                }
            }
        }
        for (IServer serverConfiguration : this.serverConfigurations) {
            this.notifyListeners(ServerChangeEvent.Kind.UPDATED, serverConfiguration, false);
        }
    }

    public void fireServerChangeEvent(IServer server, boolean isStateUpdate) {
        this.notifyListeners(ServerChangeEvent.Kind.UPDATED, server, isStateUpdate);
    }

    @Override
    public List<IServerType> getServerTypes() {
        return Collections.unmodifiableList(this.types);
    }

    @Override
    public IServer createServer(String typeId) throws CoreException {
        Object object;
        IServer serverConfiguration = null;
        IConfigurationElement element = this.configurationElements.get(typeId);
        if (element != null && (object = element.createExecutableExtension(ATT_CLASS)) instanceof IServer) {
            serverConfiguration = (IServer)object;
        }
        return serverConfiguration;
    }

    @Override
    public void add(IServer serverConfiguration) {
        Assert.isLegal((serverConfiguration != null ? 1 : 0) != 0);
        if (!this.serverConfigurations.contains(serverConfiguration)) {
            this.serverConfigurations.add(serverConfiguration);
            this.notifyListeners(ServerChangeEvent.Kind.ADDED, serverConfiguration, false);
        }
    }

    @Override
    public void remove(IServer serverConfiguration) {
        if (this.serverConfigurations.remove(serverConfiguration)) {
            this.notifyListeners(ServerChangeEvent.Kind.REMOVED, serverConfiguration, false);
            try {
                for (AliasServer aliasServer : this.aliasServers) {
                    if (aliasServer.getServer() != serverConfiguration) continue;
                    this.setServerByAlias(aliasServer.getAlias(), null);
                    return;
                }
            }
            catch (Throwable e) {
                IdeLog.logError((Plugin)WebServerCorePlugin.getDefault(), (Throwable)e);
            }
        }
    }

    @Override
    public List<IServer> getAllServers() {
        ArrayList<IServer> list = new ArrayList<IServer>();
        list.add(WebServerCorePlugin.getDefault().getBuiltinWebServer());
        list.addAll(this.serverConfigurations);
        return list;
    }

    @Override
    public List<IServer> getServers() {
        return Collections.unmodifiableList(this.serverConfigurations);
    }

    @Override
    public IServer findAndCheckServerByAlias(String alias) {
        if (StringUtil.isEmpty((String)alias)) {
            return null;
        }
        for (AliasServer aliasServer : this.aliasServers) {
            if (!alias.equals(aliasServer.getAlias())) continue;
            IServer server = aliasServer.getServer();
            if (server == null) {
                if (!aliasServer.isEnableBuildin() && !this.serverConfigurations.isEmpty()) {
                    return this.serverConfigurations.get(0);
                }
                return WebServerCorePlugin.getDefault().getBuiltinWebServer();
            }
            return server;
        }
        return null;
    }

    @Override
    public void setServerByAlias(String alias, String serverName) {
        if (alias == null) {
            return;
        }
        IEclipsePreferences node = EclipseUtil.instanceScope().getNode("com.aptana.webserver.core");
        for (AliasServer aliasServer : this.aliasServers) {
            if (!alias.equals(aliasServer.getAlias())) continue;
            if (StringUtil.isNotBlank((String)serverName)) {
                aliasServer.setServer(this.findServerByName(serverName));
                node.put("RUNINBROWSER_SERVER_PREFIX_" + alias, serverName);
            } else {
                aliasServer.setServer(null);
                node.remove("RUNINBROWSER_SERVER_PREFIX_" + alias);
            }
            try {
                node.flush();
            }
            catch (BackingStoreException e) {
                e.printStackTrace();
            }
            break;
        }
    }

    @Override
    public List<AliasServer> getAllAliasServers() {
        return this.aliasServers;
    }

    @Override
    public IServer findServerByName(final String name) {
        if (StringUtil.isEmpty((String)name)) {
            return null;
        }
        IServer server = WebServerCorePlugin.getDefault().getBuiltinWebServer();
        if (name.equals(server.getName())) {
            return server;
        }
        List<IServer> matches = this.getServers(new IFilter<IServer>(){

            public boolean include(IServer item) {
                return name.equals(item.getName());
            }
        });
        if (matches.isEmpty()) {
            return null;
        }
        return matches.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<IServer> getServers(IFilter<IServer> filter) {
        List matches;
        List<IServer> list = this.serverConfigurations;
        synchronized (list) {
            matches = CollectionsUtil.filter(this.serverConfigurations, filter);
        }
        return Collections.unmodifiableList(matches);
    }

    @Override
    public void addServerChangeListener(IServerChangeListener listener) {
        this.listeners.add((Object)listener);
    }

    @Override
    public void removeServerChangeListener(IServerChangeListener listener) {
        this.listeners.remove((Object)listener);
    }

    private IMemento storeServerConfiguration(IServer serverConfiguration) {
        IMemento saveMemento = XMLMemento.createWriteRoot((String)ELEMENT_ROOT).createChild(ELEMENT_SERVER);
        serverConfiguration.saveState(saveMemento);
        saveMemento.putString("type", serverConfiguration.getType().getId());
        return saveMemento;
    }

    private IServer restoreServerConfiguration(IMemento memento, String id) throws CoreException {
        Object object;
        IConfigurationElement element;
        IServer serverConfiguration = null;
        String typeId = memento.getString("type");
        if (typeId != null && (element = this.configurationElements.get(typeId)) != null && (object = element.createExecutableExtension(ATT_CLASS)) instanceof IServer) {
            serverConfiguration = (IServer)object;
            serverConfiguration.loadState(memento);
        }
        return serverConfiguration;
    }

    private void notifyListeners(ServerChangeEvent.Kind kind, IServer serverConfiguration, boolean isStateUpdate) {
        final ServerChangeEvent event = new ServerChangeEvent(kind, serverConfiguration, isStateUpdate);
        Object[] objectArray = this.listeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object i = objectArray[n2];
            final IServerChangeListener listener = (IServerChangeListener)i;
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void run() {
                    listener.configurationChanged(event);
                }

                public void handleException(Throwable exception) {
                    IdeLog.logError((Plugin)WebServerCorePlugin.getDefault(), (Throwable)exception);
                }
            });
            ++n2;
        }
    }
}

