/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.webserver.core;

import com.aptana.core.epl.IMemento;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.ProcessUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.webserver.core.IServer;
import com.aptana.webserver.core.SimpleWebServer;
import com.aptana.webserver.core.WebServerCorePlugin;
import java.io.File;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.Launch;
import org.eclipse.debug.core.commands.ITerminateHandler;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.RuntimeProcess;
import org.eclipse.debug.internal.core.commands.CommandAdapterFactory;
import org.eclipse.debug.internal.core.commands.TerminateCommand;

public class ExternalWebServer
extends SimpleWebServer {
    private static final String START_SERVER_COMMAND = "startCommand";
    private static final String STOP_SERVER_COMMAND = "stopCommand";
    private String startCommand;
    private String stopCommand;
    private Launch fLaunch;
    private static SelfAdapterFactory adapterFactory;

    @Override
    public void saveState(IMemento memento) {
        super.saveState(memento);
        if (this.startCommand != null) {
            memento.createChild(START_SERVER_COMMAND).putTextData(this.startCommand);
        }
        if (this.stopCommand != null) {
            memento.createChild(STOP_SERVER_COMMAND).putTextData(this.stopCommand);
        }
    }

    @Override
    public void loadState(IMemento memento) {
        super.loadState(memento);
        IMemento child = memento.getChild(START_SERVER_COMMAND);
        if (child != null) {
            this.startCommand = child.getTextData();
        }
        if ((child = memento.getChild(STOP_SERVER_COMMAND)) != null) {
            this.stopCommand = child.getTextData();
        }
    }

    private IStatus doLaunch(String arg, boolean isStop) throws CoreException {
        if (arg == null || arg.length() == 0) {
            return Status.CANCEL_STATUS;
        }
        String[] arguments = DebugPlugin.parseArguments((String)arg);
        Path workingDirectory = null;
        if (arguments != null && arguments.length > 0 && arguments[0] != null) {
            try {
                File f = new File(arguments[0]);
                if (f.getParentFile() != null && f.getParentFile().exists() && f.getParentFile().isDirectory()) {
                    workingDirectory = new Path(f.getParentFile().getAbsolutePath());
                }
            }
            catch (Exception e) {
                IdeLog.logError((Plugin)WebServerCorePlugin.getDefault(), (Throwable)e);
            }
        }
        this.exec(arguments, (IPath)workingDirectory, isStop);
        return Status.OK_STATUS;
    }

    private IProcess exec(String[] arguments, IPath workingDirectory, boolean isStop) throws CoreException {
        File workingDir = null;
        if (workingDirectory != null && !(workingDir = workingDirectory.toFile()).isDirectory()) {
            workingDir = null;
        }
        Process p = DebugPlugin.exec((String[])arguments, (File)workingDir);
        IProcess process = null;
        if (p != null) {
            try {
                int exitValue;
                if (isStop) {
                    Thread.sleep(300L);
                }
                if ((exitValue = p.exitValue()) != 0) {
                    throw new CoreException(ProcessUtil.processResult((Process)p));
                }
                if (isStop && exitValue == 0) {
                    return null;
                }
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
            }
            catch (InterruptedException interruptedException) {}
            this.fLaunch = new Launch(ExternalWebServer.createLaunchConfig(), "run", null);
            this.fLaunch.setAttribute("org.eclipse.debug.core.launch.timestamp", Long.toString(System.currentTimeMillis()));
            this.getLaunchManager().addLaunch((ILaunch)this.fLaunch);
            process = DebugPlugin.newProcess((ILaunch)this.fLaunch, (Process)p, (String)this.getName());
            process.setAttribute(IProcess.ATTR_CMDLINE, this.renderCommandLine(arguments));
            if (adapterFactory == null) {
                adapterFactory = new SelfAdapterFactory();
                Platform.getAdapterManager().registerAdapters((IAdapterFactory)adapterFactory, RuntimeProcess.class);
            }
        }
        return process;
    }

    private static ILaunchConfiguration createLaunchConfig() {
        try {
            ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
            ILaunchConfigurationType configType = manager.getLaunchConfigurationType("com.aptana.webserver.ui.LaunchConfigurationType");
            ILaunchConfiguration[] configs = manager.getLaunchConfigurations(configType);
            if (configs != null && configs.length > 0) {
                return configs[0];
            }
            return configType.newInstance(null, manager.generateLaunchConfigurationName("HBuilder"));
        }
        catch (CoreException e) {
            IdeLog.logError((Plugin)WebServerCorePlugin.getDefault(), (Throwable)e);
            return null;
        }
    }

    protected ILaunchManager getLaunchManager() {
        return DebugPlugin.getDefault().getLaunchManager();
    }

    private String renderCommandLine(String[] commandLine) {
        if (commandLine.length < 1) {
            return "";
        }
        return StringUtil.join((String)" ", (String[])commandLine);
    }

    @Override
    public IStatus stop(boolean force, IProgressMonitor monitor) {
        this.updateState(IServer.State.STOPPING);
        try {
            IStatus status = Status.CANCEL_STATUS;
            if (StringUtil.isNotBlank((String)this.stopCommand)) {
                status = this.doLaunch(this.stopCommand, true);
            } else if (this.getLaunch() != null) {
                IProcess[] ps = this.getLaunch().getProcesses();
                if (ps != null && ps.length > 0) {
                    IProcess[] iProcessArray = ps;
                    int n = ps.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IProcess p = iProcessArray[n2];
                        if (p.canTerminate()) {
                            p.terminate();
                        }
                        ++n2;
                    }
                }
                status = Status.OK_STATUS;
            }
            this.updateState(IServer.State.STOPPED);
            return status;
        }
        catch (CoreException e) {
            this.updateState(IServer.State.UNKNOWN);
            IdeLog.logError((Plugin)WebServerCorePlugin.getDefault(), (Throwable)e);
            return e.getStatus();
        }
    }

    @Override
    public IStatus start(String mode, IProgressMonitor monitor) {
        try {
            IStatus status = this.doLaunch(this.startCommand, false);
            this.updateState(IServer.State.STARTED);
            return status;
        }
        catch (CoreException e) {
            this.updateState(IServer.State.STOPPED);
            return e.getStatus();
        }
    }

    @Override
    public String getMode() {
        return "run";
    }

    @Override
    public ILaunch getLaunch() {
        return this.fLaunch;
    }

    @Override
    public IProcess[] getProcesses() {
        return this.getLaunch().getProcesses();
    }

    public String getStartCommand() {
        return this.startCommand;
    }

    public String getStopCommand() {
        return this.stopCommand;
    }

    public void setStartCommand(String text) {
        this.startCommand = text;
    }

    public void setStopCommand(String text) {
        this.stopCommand = text;
    }

    @Override
    public IServer.State getState() {
        return this.fState;
    }

    @Override
    public Set<String> getAvailableModes() {
        return CollectionsUtil.newSet((Object[])new String[]{"run"});
    }

    private static class SelfAdapterFactory
    extends CommandAdapterFactory {
        private static ITerminateHandler fgTerminateCommand = new TerminateCommand(){

            protected void execute(Object target) throws CoreException {
                if (target instanceof RuntimeProcess) {
                    try {
                        ILaunch launch = ((RuntimeProcess)target).getLaunch();
                        if (launch != null) {
                            List<IServer> servers = WebServerCorePlugin.getDefault().getServerManager().getServers();
                            for (IServer server : servers) {
                                if (!launch.equals(server.getLaunch())) continue;
                                server.stop(true, (IProgressMonitor)new NullProgressMonitor());
                                return;
                            }
                        }
                    }
                    catch (Exception e) {
                        IdeLog.logError((Plugin)WebServerCorePlugin.getDefault(), (Throwable)e);
                    }
                }
                super.equals(target);
            }
        };

        private SelfAdapterFactory() {
        }

        public Object getAdapter(Object adaptableObject, Class adapterType) {
            if (adapterType.equals(ITerminateHandler.class)) {
                return fgTerminateCommand;
            }
            return super.getAdapter(adaptableObject, adapterType);
        }
    }
}

