/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.projects.wizards;

import com.aptana.core.util.StringUtil;
import com.aptana.core.util.WorkspaceUtil;
import com.pandora.core.auth.UserAuth;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URI;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.dialogs.ProjectContentsLocationArea;

public class PandoraProjectContentsLocationArea
extends ProjectContentsLocationArea {
    private String projectName = null;
    private ProjectContentsLocationArea.IErrorMessageReporter reporter = null;

    public PandoraProjectContentsLocationArea(ProjectContentsLocationArea.IErrorMessageReporter reporter, Composite composite) {
        super(reporter, composite);
        this.reporter = reporter;
        this.updateContents();
    }

    private void updateContents() {
        Class<?> superClass = ((Object)((Object)this)).getClass().getSuperclass();
        try {
            Field useDefaultsButtonField = superClass.getDeclaredField("useDefaultsButton");
            if (useDefaultsButtonField != null) {
                String codedir;
                useDefaultsButtonField.setAccessible(true);
                final Button button = (Button)useDefaultsButtonField.get((Object)this);
                button.setSelection(false);
                button.setVisible(false);
                Text locationPathField = this.getLocationPathField();
                locationPathField.setEnabled(true);
                if (!Platform.inDevelopmentMode()) {
                    codedir = WorkspaceUtil.getCodeDir((String)UserAuth.getUsername());
                    if ("".equals(codedir)) {
                        codedir = WorkspaceUtil.getCodeLocation();
                    }
                } else {
                    codedir = WorkspaceUtil.getCodeLocation();
                }
                locationPathField.setText(codedir);
                Label locationLabel = this.getlocationLabel();
                locationLabel.setEnabled(true);
                Button browseButton = this.getbrowseButton();
                browseButton.setEnabled(true);
                Listener[] listeners = button.getListeners(13);
                if (listeners != null && listeners.length > 0) {
                    Listener[] listenerArray = listeners;
                    int n = listeners.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Listener listener = listenerArray[n2];
                        if (listener instanceof SelectionListener) {
                            button.removeSelectionListener((SelectionListener)listener);
                        }
                        ++n2;
                    }
                }
                button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        boolean useDefaults = button.getSelection();
                        Text locationPathField = PandoraProjectContentsLocationArea.this.getLocationPathField();
                        if (useDefaults) {
                            String userPath = PandoraProjectContentsLocationArea.this.getLocationAreaText();
                            PandoraProjectContentsLocationArea.this.setFieldValue("userPath", userPath);
                            locationPathField.setText(TextProcessor.process((String)PandoraProjectContentsLocationArea.this.getDefaultPathDisplayString()));
                        } else {
                            locationPathField.setText("");
                        }
                        String error = PandoraProjectContentsLocationArea.this.checkValidLocation();
                        PandoraProjectContentsLocationArea.this.reporter.reportError(error, error != null && error.equals(IDEWorkbenchMessages.WizardNewProjectCreationPage_projectLocationEmpty));
                        PandoraProjectContentsLocationArea.this.invokeMethod("setUserAreaEnabled", new Object[]{!useDefaults});
                    }
                });
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Object invokeMethod(String methodName, Object ... params) {
        Class<?> superClass = ((Object)((Object)this)).getClass().getSuperclass();
        Class[] paramClazzs = new Class[params.length];
        int i = 0;
        while (i < params.length) {
            paramClazzs[i] = params[i].getClass() == Boolean.class ? Boolean.TYPE : params[i].getClass();
            ++i;
        }
        try {
            Method method = superClass.getDeclaredMethod(methodName, paramClazzs);
            if (method != null) {
                method.setAccessible(true);
                return method.invoke((Object)this, params);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private String getFieldStringValue(String fieldName) {
        try {
            Class<?> superClass = ((Object)((Object)this)).getClass().getSuperclass();
            Field field = superClass.getDeclaredField(fieldName);
            if (field != null) {
                field.setAccessible(true);
                Object obj = field.get((Object)this);
                if (obj != null) {
                    return obj.toString();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }

    private void setFieldValue(String fieldName, Object fieldValue) {
        try {
            Class<?> superClass = ((Object)((Object)this)).getClass().getSuperclass();
            Field field = superClass.getDeclaredField(fieldName);
            if (field != null) {
                field.setAccessible(true);
                field.set((Object)this, fieldValue);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void updateProjectName(String newName) {
        try {
            Text location;
            this.projectName = newName;
            this.setFieldValue("projectName", newName);
            if (this.isDefault() && (location = this.getLocationPathField()) != null) {
                location.setText(TextProcessor.process((String)this.getDefaultPathDisplayString()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String getDefaultPathDisplayString() {
        String codeDir;
        String username;
        String defaultPath = "";
        try {
            Class<?> superClass = ((Object)((Object)this)).getClass().getSuperclass();
            Method method = superClass.getDeclaredMethod("getDefaultPathDisplayString", new Class[0]);
            if (method != null) {
                method.setAccessible(true);
                Object obj = method.invoke((Object)this, new Object[0]);
                if (obj != null) {
                    defaultPath = obj.toString();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (StringUtil.isNotEmpty((String)(username = UserAuth.getUsername())) && StringUtil.isNotEmpty((String)(codeDir = WorkspaceUtil.getCodeDir((String)username)))) {
            return String.valueOf(codeDir) + File.separator + StringUtil.avoidNull((String)this.projectName);
        }
        return defaultPath;
    }

    public URI getProjectLocationURI() {
        String location = this.getLocationAreaText();
        if (StringUtil.isEmpty((String)this.projectName) || StringUtil.isEmpty((String)location)) {
            return super.getProjectLocationURI();
        }
        File locationFile = new File(location);
        if (this.isDefault()) {
            return locationFile.getParentFile().toURI();
        }
        return locationFile.toURI();
    }

    private Text getLocationPathField() {
        try {
            Class<?> superClass = ((Object)((Object)this)).getClass().getSuperclass();
            Field locationPathField = superClass.getDeclaredField("locationPathField");
            if (locationPathField != null) {
                locationPathField.setAccessible(true);
                Text location = (Text)locationPathField.get((Object)this);
                return location;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private Button getbrowseButton() {
        try {
            Class<?> superClass = ((Object)((Object)this)).getClass().getSuperclass();
            Field browseButton = superClass.getDeclaredField("browseButton");
            if (browseButton != null) {
                browseButton.setAccessible(true);
                Button button = (Button)browseButton.get((Object)this);
                return button;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private Label getlocationLabel() {
        try {
            Class<?> superClass = ((Object)((Object)this)).getClass().getSuperclass();
            Field locationLabel = superClass.getDeclaredField("locationLabel");
            if (locationLabel != null) {
                locationLabel.setAccessible(true);
                Label label = (Label)locationLabel.get((Object)this);
                return label;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private String getLocationAreaText() {
        Text text = this.getLocationPathField();
        if (text != null) {
            return text.getText();
        }
        return null;
    }

    public String getProjectLocation() {
        String location = this.getLocationAreaText();
        if (StringUtil.isNotEmpty((String)location)) {
            File locationFile = new File(location);
            if (this.isDefault()) {
                return locationFile.getParentFile().getAbsolutePath();
            }
            return locationFile.getAbsolutePath();
        }
        return Platform.getLocation().toOSString();
    }
}

