/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.projects.wizards;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.projects.templates.IProjectTemplate;
import com.aptana.core.projects.templates.ProjectTemplate;
import com.aptana.core.projects.templates.TemplateType;
import com.aptana.core.util.ProcessStatus;
import com.aptana.core.util.ResourceUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.core.util.WorkspaceUtil;
import com.aptana.projects.ProjectsPlugin;
import com.aptana.projects.internal.wizards.Messages;
import com.aptana.projects.listeners.IStudioProjectListener;
import com.aptana.projects.listeners.StudioProjectListenersManager;
import com.aptana.projects.templates.IDefaultProjectTemplate;
import com.aptana.projects.wizards.CommonWizardNewProjectCreationPage;
import com.aptana.projects.wizards.IStepIndicatorWizardPage;
import com.aptana.projects.wizards.IWizardProjectCreationPage;
import com.aptana.projects.wizards.ProjectTemplateSelectionPage;
import com.aptana.ui.util.UIUtils;
import com.pandora.core.auth.UserAuth;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.WizardNewProjectReferencePage;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.ide.undo.CreateProjectOperation;
import org.eclipse.ui.ide.undo.WorkspaceUndoUtil;
import org.eclipse.ui.statushandlers.IStatusAdapterConstants;
import org.eclipse.ui.statushandlers.StatusAdapter;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;

public abstract class AbstractNewProjectWizard
extends BasicNewResourceWizard
implements IExecutableExtension {
    public static final String TEMPLATE_SELECTION_PAGE_NAME = "templateSelectionPage";
    protected IWizardProjectCreationPage mainPage;
    protected ProjectTemplateSelectionPage templatesPage;
    protected WizardNewProjectReferencePage referencePage;
    protected String projectTemplateId;
    protected IProjectTemplate selectedTemplate;
    protected IConfigurationElement configElement;
    protected IProject newProject;
    private URI location;
    private IPath destPath;
    private IProject[] refProjects;
    protected String[] stepNames;

    public AbstractNewProjectWizard() {
        this.initDialogSettings();
    }

    protected abstract String[] getProjectNatures();

    protected abstract String[] getProjectBuilders();

    protected abstract String getProjectCreationDescription();

    protected abstract TemplateType[] getProjectTemplateTypes();

    protected void initDialogSettings() {
        IDialogSettings workbenchSettings = ProjectsPlugin.getDefault().getDialogSettings();
        IDialogSettings section = workbenchSettings.getSection("BasicNewProjectResourceWizard");
        if (section == null) {
            section = workbenchSettings.addNewSection("BasicNewProjectResourceWizard");
        }
        this.setDialogSettings(section);
    }

    public void addPages() {
        super.addPages();
        TemplateType[] templateTypes = this.getProjectTemplateTypes();
        this.validateProjectTemplate(templateTypes);
        ArrayList<String> steps = new ArrayList<String>();
        ArrayList<IStepIndicatorWizardPage> stepPages = new ArrayList<IStepIndicatorWizardPage>();
        List<IProjectTemplate> templates = ProjectsPlugin.getDefault().getTemplatesManager().getTemplates(templateTypes);
        if (AbstractNewProjectWizard.hasNonDefaultTemplates(templates) && this.selectedTemplate == null) {
            this.templatesPage = new ProjectTemplateSelectionPage(TEMPLATE_SELECTION_PAGE_NAME, templates);
            this.addPage((IWizardPage)this.templatesPage);
            stepPages.add(this.templatesPage);
            steps.add(this.templatesPage.getStepName());
        }
        this.mainPage = this.createMainPage();
        this.addPage(this.mainPage);
        if (this.mainPage instanceof IStepIndicatorWizardPage) {
            stepPages.add((IStepIndicatorWizardPage)((Object)this.mainPage));
            steps.add(((IStepIndicatorWizardPage)((Object)this.mainPage)).getStepName());
        }
        this.stepNames = steps.toArray(new String[steps.size()]);
        if (this.stepNames.length > 1) {
            for (IStepIndicatorWizardPage page : stepPages) {
                page.initStepIndicator(this.stepNames);
            }
        }
    }

    protected IWizardProjectCreationPage createMainPage() {
        CommonWizardNewProjectCreationPage mainPage = new CommonWizardNewProjectCreationPage("basicNewProjectPage", this.selectedTemplate);
        mainPage.setTitle(Messages.NewProjectWizard_ProjectPage_Title);
        mainPage.setDescription(Messages.NewProjectWizard_ProjectPage_Description);
        return mainPage;
    }

    protected boolean checkCreateProjectCondition() throws CoreException {
        return true;
    }

    public boolean performFinish() {
        this.newProject = this.mainPage.getProjectHandle();
        this.destPath = this.mainPage.getLocationPath();
        this.location = null;
        try {
            if (!this.checkCreateProjectCondition()) {
                return false;
            }
        }
        catch (CoreException e1) {
            e1.printStackTrace();
        }
        if (!this.mainPage.useDefaults()) {
            this.location = this.mainPage.getLocationURI();
            this.location = URI.create(String.valueOf(this.location.toString()) + "/" + this.newProject.getName());
        } else {
            this.destPath = this.destPath.append(this.newProject.getName());
        }
        String codedir = "";
        String newdir = this.destPath.toFile().getPath();
        if (!Platform.inDevelopmentMode()) {
            codedir = WorkspaceUtil.getCodeDir((String)UserAuth.getUsername());
            if (!codedir.equals(newdir)) {
                WorkspaceUtil.setNewCodeDir((String)UserAuth.getUsername(), (String)newdir);
            }
        } else {
            codedir = WorkspaceUtil.getCodeLocation();
        }
        if (this.templatesPage != null) {
            this.selectedTemplate = this.templatesPage.getSelectedTemplate();
        }
        if (this.referencePage != null) {
            this.refProjects = this.referencePage.getReferencedProjects();
        }
        boolean success = false;
        try {
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

                        public void run(IProgressMonitor monitor) throws CoreException {
                            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)5);
                            try {
                                AbstractNewProjectWizard.this.createNewProject((IProgressMonitor)subMonitor.newChild(4));
                            }
                            catch (InvocationTargetException e) {
                                throw new CoreException((IStatus)new Status(4, "com.aptana.projects", 0, e.getTargetException().getMessage(), (Throwable)e));
                            }
                            IStudioProjectListener[] projectListeners = new IStudioProjectListener[]{};
                            IProjectDescription description = (this).AbstractNewProjectWizard.this.newProject.getDescription();
                            if (description != null) {
                                projectListeners = StudioProjectListenersManager.getManager().getProjectListeners(description.getNatureIds());
                            }
                            int listenerSize = projectListeners.length;
                            SubMonitor hookMonitor = SubMonitor.convert((IProgressMonitor)subMonitor.newChild(1), (String)Messages.AbstractNewProjectWizard_ProjectListener_TaskName, (int)Math.max(1, listenerSize));
                            IStudioProjectListener[] iStudioProjectListenerArray = projectListeners;
                            int n = projectListeners.length;
                            int n2 = 0;
                            while (n2 < n) {
                                IStatus status;
                                IStudioProjectListener projectListener = iStudioProjectListenerArray[n2];
                                if (projectListener != null && (status = projectListener.projectCreated((this).AbstractNewProjectWizard.this.newProject, (IProgressMonitor)hookMonitor.newChild(1))) != null && status.matches(4)) {
                                    UIUtils.getDisplay().syncExec(new Runnable(){

                                        @Override
                                        public void run() {
                                            String message = status.getMessage();
                                            if (status instanceof ProcessStatus) {
                                                message = ((ProcessStatus)status).getStdErr();
                                            }
                                            MessageDialog.openError((Shell)UIUtils.getActiveWorkbenchWindow().getShell(), (String)Messages.AbstractNewProjectWizard_ProjectListenerErrorTitle, (String)message);
                                        }
                                    });
                                }
                                ++n2;
                            }
                        }
                    };
                    try {
                        ResourcesPlugin.getWorkspace().run(runnable, monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e, Messages.AbstractNewProjectWizard_ProjectListener_NoDescriptor_Error);
                    }
                }
            });
            success = true;
        }
        catch (InterruptedException e) {
            StatusManager.getManager().handle((IStatus)new Status(4, "com.aptana.projects", e.getMessage(), (Throwable)e), 4);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof ExecutionException && t.getCause() instanceof CoreException) {
                CoreException cause = (CoreException)t.getCause();
                StatusAdapter status = cause.getStatus().getCode() == 275 ? new StatusAdapter((IStatus)new Status(2, "com.aptana.projects", NLS.bind((String)Messages.NewProjectWizard_Warning_DirectoryExists, (Object)this.mainPage.getProjectHandle().getName()), (Throwable)cause)) : new StatusAdapter((IStatus)new Status(cause.getStatus().getSeverity(), "com.aptana.projects", Messages.NewProjectWizard_CreationProblem, (Throwable)cause));
                status.setProperty(IStatusAdapterConstants.TITLE_PROPERTY, (Object)Messages.NewProjectWizard_CreationProblem);
                StatusManager.getManager().handle(status, 4);
            }
            StatusAdapter status = new StatusAdapter((IStatus)new Status(2, "com.aptana.projects", 0, NLS.bind((String)Messages.NewProjectWizard_InternalError, (Object)t.getMessage()), t));
            status.setProperty(IStatusAdapterConstants.TITLE_PROPERTY, (Object)Messages.NewProjectWizard_CreationProblem);
            StatusManager.getManager().handle(status, 5);
        }
        if (!success) {
            return false;
        }
        this.updatePerspective();
        this.selectAndReveal((IResource)this.newProject);
        try {
            this.createProjectSetting(this.newProject, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            StatusManager.getManager().handle((IStatus)new Status(4, "com.aptana.projects", e.getMessage(), (Throwable)e), 4);
            return false;
        }
        this.openIndexFile();
        this.sendProjectCreateEvent();
        return true;
    }

    protected void createProjectSetting(IProject project, IProgressMonitor monitor) throws CoreException {
    }

    public IProject getCreatedProject() {
        return this.newProject;
    }

    protected abstract String getProjectCreateEventName();

    protected void sendProjectCreateEvent() {
    }

    protected Map<String, String> generatePayload() {
        HashMap<String, String> payload = new HashMap<String, String>();
        payload.put("name", this.newProject.getName());
        if (this.selectedTemplate != null) {
            String id = this.selectedTemplate.getId();
            if (StringUtil.isEmpty((String)id)) {
                payload.put("template", "custom.template-" + this.selectedTemplate.getDisplayName());
            } else {
                payload.put("template", id);
            }
        }
        return payload;
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.configElement = config;
        if ("projectTemplateId".equals(propertyName) && data instanceof String) {
            this.projectTemplateId = (String)data;
        }
    }

    protected void validateProjectTemplate(TemplateType[] templateType) {
        this.selectedTemplate = null;
        if (this.projectTemplateId != null) {
            List<IProjectTemplate> templates = ProjectsPlugin.getDefault().getTemplatesManager().getTemplates(templateType);
            for (IProjectTemplate template : templates) {
                if (template.getId() == null || !template.getId().equals(this.projectTemplateId)) continue;
                this.selectedTemplate = template;
                return;
            }
        }
    }

    public void init(IWorkbench workbench, IStructuredSelection currentSelection) {
        super.init(workbench, currentSelection);
        this.setNeedsProgressMonitor(true);
    }

    private void updatePerspective() {
        BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)this.configElement);
    }

    protected IProject createNewProject(IProgressMonitor monitor) throws InvocationTargetException {
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IProjectDescription description = ResourceUtil.getProjectDescription((IPath)this.destPath, (String[])this.getProjectNatures(), (String[])this.getProjectBuilders());
        description.setName(this.newProject.getName());
        if (this.location != null) {
            description.setLocationURI(this.location);
        }
        if (this.refProjects != null && this.refProjects.length > 0) {
            description.setReferencedProjects(this.refProjects);
        }
        sub.worked(10);
        if (!this.applySourcedProjectFilesAfterProjectCreated() && this.isCloneFromGit()) {
            this.cloneFromGit(this.newProject, description, (IProgressMonitor)sub.newChild(90));
        } else {
            this.doBasicCreateProject(this.newProject, description, (IProgressMonitor)sub.newChild(75));
            if (!this.applySourcedProjectFilesAfterProjectCreated() && this.selectedTemplate != null && !this.isCloneFromGit()) {
                this.selectedTemplate.apply(this.newProject, false);
                this.replaceProjectTemplateFile(this.newProject);
            }
        }
        return this.newProject;
    }

    protected void replaceProjectTemplateFile(IProject newProject2) {
    }

    protected boolean applySourcedProjectFilesAfterProjectCreated() {
        return false;
    }

    protected boolean isCloneFromGit() {
        return this.selectedTemplate != null && !this.selectedTemplate.getLocation().endsWith(".zip");
    }

    protected void cloneFromGit(IProject newProjectHandle, IProjectDescription description, IProgressMonitor monitor) throws InvocationTargetException {
        this.doCloneFromGit(this.selectedTemplate.getLocation(), newProjectHandle, description, monitor);
    }

    protected void cloneAfter(IProgressMonitor monitor) throws Exception {
    }

    private void doBasicCreateProject(IProject project, IProjectDescription description, IProgressMonitor monitor) throws InvocationTargetException {
        CreateProjectOperation op = new CreateProjectOperation(description, this.getProjectCreationDescription());
        try {
            op.execute(monitor, WorkspaceUndoUtil.getUIInfoAdapter((Shell)this.getShell()));
        }
        catch (ExecutionException e) {
            throw new InvocationTargetException(e);
        }
    }

    protected void doCloneFromGit(String sourceURI, IProject projectHandle, IProjectDescription projectDescription, IProgressMonitor monitor) throws InvocationTargetException {
    }

    protected void openIndexFile() {
        IWorkbenchPage page;
        String indexFileName = "index.html";
        if (this.getIndexFile() != null) {
            indexFileName = this.getIndexFile();
        }
        IFile indexFile = this.newProject.getFile(indexFileName);
        this.waitForIndexFile(indexFile);
        if (indexFile.exists() && (page = UIUtils.getActivePage()) != null) {
            try {
                IDE.openEditor((IWorkbenchPage)page, (IFile)indexFile);
            }
            catch (PartInitException e) {
                IdeLog.logError((Plugin)ProjectsPlugin.getDefault(), (String)Messages.NewProjectWizard_ERR_OpeningIndex, (Throwable)e);
            }
        }
    }

    protected void waitForIndexFile(IFile indexFile) {
        long waitFor = 2000L;
        while (!indexFile.exists()) {
            if (waitFor <= 0L) break;
            waitFor -= 100L;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public String getIndexFile() {
        return "index.html";
    }

    protected IPath getDestinationPath() {
        return this.destPath;
    }

    public static void extractZip(IProjectTemplate template, IProject project, Set<IPath> preExistingResources) {
        template.apply(project, !preExistingResources.isEmpty());
    }

    public static void extractZip(IProjectTemplate template, IProject project, boolean promptForOverwrite) {
        template.apply(project, promptForOverwrite);
    }

    public static void extractZip(File zipPath, IProject project, boolean promptForOverwrite, Set<IPath> preExistingResources, boolean isReplacingParameters) {
        new ProjectTemplate(zipPath.getAbsolutePath(), null, "", isReplacingParameters, "", null, "").apply(project, promptForOverwrite);
    }

    private static boolean hasNonDefaultTemplates(List<IProjectTemplate> templates) {
        for (IProjectTemplate template : templates) {
            if (template instanceof IDefaultProjectTemplate) continue;
            return true;
        }
        return false;
    }
}

