/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.projects.internal.wizards;

import com.aptana.core.projects.templates.IProjectTemplate;
import com.aptana.core.util.ArrayUtil;
import com.aptana.projects.ProjectsPlugin;
import com.aptana.projects.internal.wizards.Messages;
import com.aptana.projects.wizards.IStepIndicatorWizardPage;
import com.aptana.ui.widgets.StepIndicatorComposite;
import java.net.URL;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class ProjectTemplateSelectionPage
extends WizardPage
implements ISelectionChangedListener,
IStepIndicatorWizardPage {
    public static final String COMMAND_PROJECT_FROM_TEMPLATE_PROJECT_TEMPLATE_NAME = "projectTemplateId";
    public static final String COMMAND_PROJECT_FROM_TEMPLATE_NEW_WIZARD_ID = "newWizardId";
    private TableViewer fTemplateSelectionViewer;
    private Label fPreviewText;
    private IProjectTemplate[] fTemplates;
    private IProjectTemplate fSelectedTemplate;
    private static ImageDescriptor wizardDesc = ProjectsPlugin.getImageDescriptor("/icons/project_template_blank.png");
    private Image defaultTemplateImage = null;
    private Map<Object, Image> templateImages;
    protected StepIndicatorComposite stepIndicatorComposite;
    protected String[] stepNames;

    public ProjectTemplateSelectionPage(String pageName, List<IProjectTemplate> templates) {
        super(pageName);
        if (templates == null) {
            this.fTemplates = new IProjectTemplate[0];
        } else {
            Collections.sort(templates, new Comparator<IProjectTemplate>(){

                @Override
                public int compare(IProjectTemplate o1, IProjectTemplate o2) {
                    return o1.getPriority() - o2.getPriority();
                }
            });
            this.fTemplates = templates.toArray(new IProjectTemplate[templates.size()]);
        }
        this.setTitle(Messages.ProjectTemplateSelectionPage_Title);
        this.setDescription(Messages.ProjectTemplateSelectionPage_Description);
        this.templateImages = new HashMap<Object, Image>();
    }

    public IProjectTemplate getSelectedTemplate() {
        return this.fSelectedTemplate;
    }

    public void createControl(Composite parent) {
        this.defaultTemplateImage = wizardDesc.createImage();
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (ProjectTemplateSelectionPage.this.defaultTemplateImage != null) {
                    ProjectTemplateSelectionPage.this.defaultTemplateImage.dispose();
                    ProjectTemplateSelectionPage.this.defaultTemplateImage = null;
                }
                for (Image image : ProjectTemplateSelectionPage.this.templateImages.values()) {
                    if (image.isDisposed()) continue;
                    image.dispose();
                }
                ProjectTemplateSelectionPage.this.templateImages = null;
            }
        });
        Composite main = new Composite(parent, 0);
        main.setLayout((Layout)GridLayoutFactory.fillDefaults().spacing(0, 10).create());
        main.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        this.stepIndicatorComposite = new StepIndicatorComposite(main, this.stepNames);
        this.stepIndicatorComposite.setSelection(this.getStepName());
        Label label = new Label(main, 0);
        label.setText(Messages.ProjectTemplateSelectionPage_AvailableTemplates_TXT);
        label.setLayoutData((Object)GridDataFactory.swtDefaults().create());
        SashForm sashForm = new SashForm(main, 256);
        sashForm.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        this.fTemplateSelectionViewer = new TableViewer((Composite)sashForm, 2048);
        this.fTemplateSelectionViewer.setContentProvider((IContentProvider)new ListContentProvider());
        this.fTemplateSelectionViewer.setLabelProvider((IBaseLabelProvider)new ListLabelProvider());
        this.fTemplateSelectionViewer.setInput((Object)this.fTemplates);
        this.fTemplateSelectionViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.fPreviewText = new Label((Composite)sashForm, 72);
        if (!ArrayUtil.isEmpty((Object[])this.fTemplates)) {
            this.fTemplateSelectionViewer.setSelection((ISelection)new StructuredSelection((Object)this.fTemplates[0]));
            this.setSelectedTemplate(this.fTemplates[0]);
        }
        Dialog.applyDialogFont((Control)main);
        this.setControl((Control)main);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        StructuredSelection selection = (StructuredSelection)event.getSelection();
        this.setSelectedTemplate(selection.isEmpty() ? null : (IProjectTemplate)selection.getFirstElement());
    }

    private void setSelectedTemplate(IProjectTemplate template) {
        String text = template == null ? null : template.getDescription();
        this.fPreviewText.setText(text == null ? "" : text);
        this.fSelectedTemplate = template;
    }

    @Override
    public void initStepIndicator(String[] stepNames) {
        this.stepNames = stepNames;
    }

    @Override
    public String getStepName() {
        return this.getTitle();
    }

    private class ListContentProvider
    implements IStructuredContentProvider {
        private ListContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return ProjectTemplateSelectionPage.this.fTemplates;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class ListLabelProvider
    extends LabelProvider {
        private static final int IMAGE_SIZE = 48;

        private ListLabelProvider() {
        }

        public Image getImage(Object element) {
            Image image = (Image)ProjectTemplateSelectionPage.this.templateImages.get(element);
            if (image == null) {
                if (element instanceof IProjectTemplate) {
                    ImageDescriptor descriptor;
                    IProjectTemplate template = (IProjectTemplate)element;
                    URL iconPath = template.getIconURL();
                    if (iconPath != null && (descriptor = ImageDescriptor.createFromURL((URL)iconPath)) != null && (image = descriptor.createImage()) != null) {
                        ImageData imageData = image.getImageData();
                        if (imageData.x != 48 || imageData.y != 48) {
                            image.dispose();
                            imageData = imageData.scaledTo(48, 48);
                            image = ImageDescriptor.createFromImageData((ImageData)imageData).createImage();
                        }
                    }
                    if (image == null) {
                        image = ProjectTemplateSelectionPage.this.defaultTemplateImage;
                    }
                    ProjectTemplateSelectionPage.this.templateImages.put(element, image);
                } else {
                    image = ProjectTemplateSelectionPage.this.defaultTemplateImage;
                }
            }
            return image;
        }

        public String getText(Object element) {
            if (element instanceof IProjectTemplate) {
                IProjectTemplate template = (IProjectTemplate)element;
                return template.getDisplayName();
            }
            return super.getText(element);
        }
    }
}

