/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.nodejs.service;

import com.pandora.core.log.HBLog;
import com.pandora.nodejs.NodejsClient;
import com.pandora.nodejs.NodejsPlugin;
import com.pandora.nodejs.service.ActionException;
import com.pandora.nodejs.service.ContentType;
import com.pandora.nodejs.service.NodeAction;
import java.util.HashMap;
import java.util.Map;
import org.apache.thrift.TException;
import org.apache.wink.json4j.JSONObject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;

public class NodeService {
    public static String format(JSONObject config, ContentType contentType, String content) throws CoreException {
        try {
            return NodeService.action(NodeAction.FORMAT, config, contentType, content);
        }
        catch (ActionException e) {
            HBLog.logError((Plugin)NodejsPlugin.getDefault(), (Throwable)e);
            return null;
        }
    }

    public static String compressor(JSONObject config, ContentType contentType, String content) throws CoreException {
        try {
            return NodeService.action(NodeAction.COMPRESSOR, config, contentType, content);
        }
        catch (ActionException e) {
            HBLog.logError((Plugin)NodejsPlugin.getDefault(), (Throwable)e);
            return null;
        }
    }

    public static String compile(JSONObject config, ContentType contentType, String content) throws ActionException, CoreException {
        return NodeService.action(NodeAction.COMPILE, config, contentType, content);
    }

    private static String action(NodeAction action, JSONObject config, ContentType contentType, String content) throws ActionException, CoreException {
        try {
            HashMap<String, String> request = new HashMap<String, String>();
            request.put("action", action.toString().toLowerCase());
            if (config != null) {
                request.put("config", config.toString());
            }
            request.put("type", contentType.name().toLowerCase());
            request.put("content", content);
            Map<String, String> response = NodejsClient.getInstance().request(request);
            if (response.containsKey("error")) {
                throw new ActionException(response);
            }
            return response.get("result");
        }
        catch (TException e) {
            HBLog.logError((Plugin)NodejsPlugin.getDefault(), (Throwable)e);
            throw new CoreException((IStatus)new Status(4, "com.pandora.nodejs", e.getMessage(), (Throwable)e));
        }
    }
}

