/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ruby.internal.debug.ui;

import com.aptana.core.logging.IdeLog;
import com.aptana.ruby.debug.ui.RubyDebugUIPlugin;
import com.aptana.ruby.internal.debug.ui.StorageEditorInputFactory;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.editors.text.ILocationProvider;

public class StorageEditorInput
implements IStorageEditorInput,
ILocationProvider,
IPersistableElement {
    private IStorage storage;

    public StorageEditorInput(IStorage storage) {
        this.storage = storage;
    }

    public boolean exists() {
        return this.storage.getFullPath().toFile().exists();
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public String getName() {
        return this.storage.getName();
    }

    public IStorage getStorage() {
        return this.storage;
    }

    public IPersistableElement getPersistable() {
        return this;
    }

    public String getToolTipText() {
        return this.storage.getFullPath().toPortableString();
    }

    public Object getAdapter(Class adapter) {
        if (ILocationProvider.class.equals((Object)adapter)) {
            return this;
        }
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    public IPath getPath(Object element) {
        if (element instanceof StorageEditorInput) {
            StorageEditorInput input = (StorageEditorInput)element;
            return input.storage.getFullPath();
        }
        return null;
    }

    public boolean equals(Object object) {
        try {
            return object instanceof IStorageEditorInput && this.getStorage().equals(((IStorageEditorInput)object).getStorage());
        }
        catch (CoreException e) {
            IdeLog.logError((Plugin)RubyDebugUIPlugin.getDefault(), (Throwable)e);
            return false;
        }
    }

    public int hashCode() {
        return this.getStorage().hashCode();
    }

    public void saveState(IMemento memento) {
        StorageEditorInputFactory.saveState(memento, this.storage);
    }

    public String getFactoryId() {
        return StorageEditorInputFactory.getFactoryId();
    }
}

